/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.deal.BusiNotificationPushErpYfService;
import com.tydic.pfscext.api.deal.bo.BusiNotificationPushErpYsReqBO;
import com.tydic.pfscext.api.deal.bo.BusiNotificationPushErpYsRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.external.api.bo.BillNotificationPushErpInfo;
import com.tydic.pfscext.external.api.bo.BusiNotificationPushErpInfoBO;
import com.tydic.pfscext.service.busi.BusiPushErpBillService;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYfReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYfRspBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.BusiNotificationPushErpYfService"})
public class BusiNotificationPushErpYfServiceImpl
implements BusiNotificationPushErpYfService {
    private static final Logger log = LoggerFactory.getLogger(BusiNotificationPushErpYfServiceImpl.class);
    @Autowired
    private BusiPushErpBillService busiPushErpBillService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;

    @PostMapping(value={"pushErpYf"})
    public BusiNotificationPushErpYsRspBO pushErpYf(@RequestBody BusiNotificationPushErpYsReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a8\u9001erp\u5e94\u4ed8\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getNotificationNo())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByNotifyNo(reqBO.getNotificationNo());
        if (billNotificationInfo == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u901a\u77e5\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        PayPurchaseOrderInfo querOrderVo = new PayPurchaseOrderInfo();
        querOrderVo.setNotificationNo(reqBO.getNotificationNo());
        List<PayPurchaseOrderInfo> orderInfoList = this.payPurchaseOrderInfoMapper.getListByCondition(querOrderVo);
        if (CollectionUtils.isEmpty(orderInfoList)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5f00\u7968\u76f8\u5173\u4fe1\u606f\uff01");
        }
        boolean pushFlag = true;
        HashSet<Long> supplierNoList = new HashSet<Long>();
        for (PayPurchaseOrderInfo orderInfo : orderInfoList) {
            if (orderInfo.getIsErp() != null && "1".equals(orderInfo.getIsErp())) continue;
            supplierNoList.add(orderInfo.getSupplierNo());
            pushFlag = false;
            break;
        }
        if (!pushFlag) {
            return new BusiNotificationPushErpYsRspBO();
        }
        LinkedList<Long> inspectionIdList = new LinkedList<Long>();
        BusiNotificationPushErpYsRspBO rspBO = new BusiNotificationPushErpYsRspBO();
        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(billNotificationInfo.getSupplierNo());
        UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
        if (!umcQrySupplierInfoDetailAbilityRspBO.getRespCode().equals("0000")) {
            throw new BusinessException(umcQrySupplierInfoDetailAbilityRspBO.getRespCode(), "\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff1a" + umcQrySupplierInfoDetailAbilityRspBO.getRespDesc());
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(reqBO.getNotificationNo());
        LinkedList<BusiNotificationPushErpInfoBO> yfList = new LinkedList<BusiNotificationPushErpInfoBO>();
        for (PayInvoiceInfo payInvoiceInfo : payInvoiceInfoList) {
            BusiNotificationPushErpInfoBO pushErpInfoBO = new BusiNotificationPushErpInfoBO();
            TreeSet<String> idList = new TreeSet<String>();
            pushErpInfoBO.setInvoiceNum(payInvoiceInfo.getInvoiceNo());
            pushErpInfoBO.setInvoiceDate(DateUtil.dateToStr(payInvoiceInfo.getInvoiceDate(), "yyyy-MM-dd"));
            pushErpInfoBO.setInvoiceCode(payInvoiceInfo.getInvoiceCode());
            pushErpInfoBO.setSuppCode(umcQrySupplierInfoDetailAbilityRspBO.getCreditNo());
            pushErpInfoBO.setPlatformSign("1");
            List<PayInvoiceDetail> invoiceDetailList = this.payInvoiceDetailMapper.selectByInvoiceListPK(payInvoiceInfo.getInvoiceCode(), payInvoiceInfo.getInvoiceNo(), payInvoiceInfo.getInvoiceDate());
            LinkedList<BillNotificationPushErpInfo> pushErpInfoList = new LinkedList<BillNotificationPushErpInfo>();
            for (PayInvoiceDetail payInvoiceDetail : invoiceDetailList) {
                BillNotificationPushErpInfo pushErpInfo = new BillNotificationPushErpInfo();
                pushErpInfo.setQty(payInvoiceDetail.getQuantity());
                pushErpInfo.setTaxMoney(payInvoiceDetail.getTaxAmt());
                pushErpInfo.setNoTaxMoney(payInvoiceDetail.getUntaxAmt());
                pushErpInfo.setTotalMoney(payInvoiceDetail.getAmount());
                pushErpInfo.setTaxPrice(payInvoiceDetail.getPriceIntax());
                pushErpInfo.setSrcDocNo(String.valueOf(payInvoiceDetail.getInspectionId()));
                idList.add(String.valueOf(payInvoiceDetail.getInspectionId()));
                pushErpInfo.setSrcorderitemid(String.valueOf(payInvoiceDetail.getItemNo()));
                SaleItemInfo saleItemInfo = this.saleItemInfoMapper.selectByItemNo(payInvoiceDetail.getItemNo());
                if (saleItemInfo != null) {
                    pushErpInfo.setOrderitemid(String.valueOf(saleItemInfo.getPurchaseItemNo()));
                }
                pushErpInfoList.add(pushErpInfo);
                inspectionIdList.add(payInvoiceDetail.getInspectionId());
            }
            pushErpInfoBO.setInspectionIdList(idList);
            pushErpInfoBO.setRows(pushErpInfoList);
            yfList.add(pushErpInfoBO);
        }
        BusiPushErpYfReqBO yfReqBO = new BusiPushErpYfReqBO();
        yfReqBO.setNotificationNo(reqBO.getNotificationNo());
        yfReqBO.setInspectionIdList(inspectionIdList);
        yfReqBO.setYfList(yfList);
        BusiPushErpYfRspBO busiPushErpYsRspBO = this.busiPushErpBillService.pushErpYf(yfReqBO);
        rspBO.setRespCode(busiPushErpYsRspBO.getRespCode());
        rspBO.setRespDesc(busiPushErpYsRspBO.getRespDesc());
        return rspBO;
    }
}

