/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityRspBo;
import com.tydic.pfscext.api.deal.FscGetCallBackPayStatusService;
import com.tydic.pfscext.api.deal.bo.GetCallBackPayStatusReqBO;
import com.tydic.pfscext.api.deal.bo.GetCallBackPayStatusRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.ApplyPayInfoPayStatusPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.external.pay.api.FscPayProAbleQueryOrderStatusAbilityService;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import com.tydic.pfscext.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.FscGetCallBackPayStatusService"})
public class FscGetCallBackPayStatusServiceImpl
implements FscGetCallBackPayStatusService {
    private static final Logger log = LoggerFactory.getLogger(FscGetCallBackPayStatusServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Resource
    private FscPayProAbleQueryOrderStatusAbilityService fscPayProAbleQueryOrderStatusAbilityService;
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    private static final String SERVICE_NAME_DECODE = "FscPayableCallBackUoc-decode";
    private static final String SERVICE_NAME_ENCRY = "FscPayableCallBackUoc-encry";

    @PostMapping(value={"getCallBackPayStatus"})
    public GetCallBackPayStatusRspBO getCallBackPayStatus(@RequestBody GetCallBackPayStatusReqBO reqBO) {
        log.info("\u7ed3\u7b97\u4e2d\u5fc3\u4e3b\u52a8\u83b7\u53d6\u8d22\u4f01\u901a\u652f\u4ed8\u4e8c\u6b21\u56de\u8c03\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=====================");
        GetCallBackPayStatusRspBO rspBO = new GetCallBackPayStatusRspBO();
        ApplyPayInfoPayStatusPO applyPayInfoPayStatusPO = new ApplyPayInfoPayStatusPO();
        ArrayList<String> payStatusList = new ArrayList<String>();
        payStatusList.add("06");
        applyPayInfoPayStatusPO.setPayStatusList(payStatusList);
        List<ApplyPayInfoPO> applyPayInfoPOS = this.applyPayInfoMapper.getListByPayStatus(applyPayInfoPayStatusPO);
        try {
            if (!CollectionUtils.isEmpty(applyPayInfoPOS)) {
                for (ApplyPayInfoPO applyPayInfoPO : applyPayInfoPOS) {
                    PayProAbleQueryOrderStatusAbilityReqBo orderStatusAbilityReqBo = new PayProAbleQueryOrderStatusAbilityReqBo();
                    orderStatusAbilityReqBo.setRealQueryFlag("1");
                    orderStatusAbilityReqBo.setBusiCode("D500");
                    orderStatusAbilityReqBo.setOriOrderId("PAYMENT-" + applyPayInfoPO.getPayno());
                    log.info("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u5165\u53c2:" + JSON.toJSONString((Object)orderStatusAbilityReqBo));
                    PayProAbleQueryOrderStatusAbilityRspBo orderStatusAbilityRspBo = this.fscPayProAbleQueryOrderStatusAbilityService.queryStatus(orderStatusAbilityReqBo);
                    log.info("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u51fa\u53c2:" + JSON.toJSONString((Object)orderStatusAbilityRspBo));
                    if (!"0000".equals(orderStatusAbilityRspBo.getRespCode())) continue;
                    List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(applyPayInfoPO.getPayno());
                    if (CollectionUtils.isEmpty(applyDetails)) {
                        this.saveLog(SERVICE_NAME_DECODE, JSON.toJSONString((Object)orderStatusAbilityRspBo), null);
                        return rspBO;
                    }
                    ArrayList<String> payableNos = new ArrayList<String>(applyDetails.size());
                    applyDetails.forEach(applyDetail -> payableNos.add(applyDetail.getPayableNo()));
                    List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByIds(payableNos);
                    if (CollectionUtils.isEmpty(payableDetailPOS)) {
                        this.saveLog(SERVICE_NAME_DECODE, JSON.toJSONString((Object)orderStatusAbilityRspBo), null);
                        return rspBO;
                    }
                    this.updatePayStatus(orderStatusAbilityRspBo, applyPayInfoPO.getPayno(), payableNos, JSON.toJSONString((Object)orderStatusAbilityRspBo));
                    this.notifyUoc(orderStatusAbilityRspBo, payableNos, rspBO, payableDetailPOS.get(0));
                }
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void notifyUoc(PayProAbleQueryOrderStatusAbilityRspBo orderStatusAbilityRspBo, List<String> payableNos, GetCallBackPayStatusRspBO rspBO, PayableDetailPO payableDetailPO) {
        PebExtPayResultReqBO extPayResultReqBO = new PebExtPayResultReqBO();
        extPayResultReqBO.setBusiCode("D500");
        ArrayList<Long> orders = new ArrayList<Long>();
        orders.add(payableDetailPO.getOrderId());
        payableDetailPO.setOrderIdList(orders);
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
        log.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfo1);
        extPayResultReqBO.setTotalFee(payableDetailPOS.get(0).getPayableAmt().subtract(paymentFlowInfo1 == null ? BigDecimal.ZERO : paymentFlowInfo1.getOrderAmt()).toString());
        extPayResultReqBO.setPayableNos(payableNos);
        if (payableDetailPO.getOrderId() != null) {
            extPayResultReqBO.setOrderId(payableDetailPO.getOrderId().toString());
        }
        extPayResultReqBO.setPaymentFinishTime(this.getTradeTime(orderStatusAbilityRspBo.getTradeTime()));
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
        PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
        if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
            rspBO.setNotifyResult(SUCCESS);
        } else {
            rspBO.setNotifyResult(FAILURE);
        }
    }

    private Date getTradeTime(String tradeTime) {
        if (StringUtils.isNotBlank((CharSequence)tradeTime)) {
            try {
                Date payTime = DateUtil.strToDate(tradeTime, "yyyyMMddHHmmss");
                return payTime;
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u4e2d\u5fc3\u65f6\u95f4\u8bfb\u53d6\u9519\u8bef\uff1a{}", (Object)tradeTime);
            }
        }
        return null;
    }

    private void updatePayStatus(PayProAbleQueryOrderStatusAbilityRspBo orderStatusAbilityRspBo, String payNo, List<String> payableNos, String content) {
        String payStatus = PayResultStatus.SUCCESS.getCode();
        String payableStatus = PayableStatus.SUCCESS.getCode();
        if (!SUCCESS.equals(orderStatusAbilityRspBo.getRespCode())) {
            payStatus = PayResultStatus.FAILED.getCode();
            payableStatus = PayableStatus.PENDING.getCode();
        }
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayStatus(payStatus);
        applyPayInfoPO.setPayno(payNo);
        applyPayInfoPO.setPayMathod(orderStatusAbilityRspBo.getPayMethod());
        applyPayInfoPO.setRemark(orderStatusAbilityRspBo.getPayStatusMsg());
        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payNo);
        applyDetail.setStatus(payStatus);
        this.applyDetailMapper.updateByApplyNo(applyDetail);
        for (String payableNo : payableNos) {
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableNo(payableNo);
            payableDetailPO.setPayableStatus(payableStatus);
            this.payableDetailMapper.updateCallBackResultByNo(payableDetailPO);
        }
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setOutOrderId(orderStatusAbilityRspBo.getOutOrderId());
        paymentFlowInfo.setPaymentStatus(orderStatusAbilityRspBo.getRespCode());
        paymentFlowInfo.setPaymentFlowId(orderStatusAbilityRspBo.getPayNotifyTransId());
        paymentFlowInfo.setPayOrderId(orderStatusAbilityRspBo.getPayOrderId());
        paymentFlowInfo.setResultJson(content);
        paymentFlowInfo.setPayType(orderStatusAbilityRspBo.getPayMethod());
        if (null != orderStatusAbilityRspBo.getPaymentInsId()) {
            if (PayChannel.PAY_OFFLINE.getCode().equals(orderStatusAbilityRspBo.getPaymentInsId())) {
                paymentFlowInfo.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
            } else {
                paymentFlowInfo.setPayChannel(orderStatusAbilityRspBo.getPaymentInsId());
            }
        }
        paymentFlowInfo.setPayTime(new Date());
        this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
    }

    private void saveLog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

