/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.FscQryOutPushMsgBusiService;
import com.tydic.pfscext.api.busi.bo.FscQryOutPushMsgReqBO;
import com.tydic.pfscext.api.busi.bo.FscQryOutPushMsgRspBO;
import com.tydic.pfscext.api.busi.bo.MsgResult;
import com.tydic.pfscext.api.busi.bo.MsgResultBO;
import com.tydic.pfscext.api.deal.FscQryOutPushMsgService;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.FscDelMsgPushBusiService;
import com.tydic.pfscext.external.api.FscGetMsgPushService;
import com.tydic.pfscext.external.api.bo.BusiDelMsgReqBO;
import com.tydic.pfscext.external.api.bo.BusiDelMsgRspBO;
import com.tydic.pfscext.external.api.bo.BusiGetMsgReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetMsgRspBO;
import com.tydic.pfscext.external.api.bo.ResultBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.FscQryOutPushMsgService"})
public class FscQryOutPushMsgServiceImpl
implements FscQryOutPushMsgService {
    private static final Logger log = LoggerFactory.getLogger(FscQryOutPushMsgServiceImpl.class);
    @Value(value="${INVOICE_AUDIT_TYPE:1081}")
    private String invoiceAuditType;
    @Autowired
    private FscGetMsgPushService fscGetMsgPushService;
    @Autowired
    private FscDelMsgPushBusiService fscDelMsgPushBusiService;
    @Autowired
    private FscQryOutPushMsgBusiService fscQryOutPushMsgBusiService;

    @PostMapping(value={"createAndQryOutPushMsg"})
    public FscQryOutPushMsgRspBO createAndQryOutPushMsg(@RequestBody FscQryOutPushMsgReqBO reqBO) {
        log.info("\u83b7\u53d6\u7535\u5546\u53d1\u7968\u6d88\u606f\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        this.validataParams(reqBO);
        Long supNo = reqBO.getGoodsSupplierId();
        BusiGetMsgRspBO qryMsgRsp = this.qryPushMsg(supNo, this.invoiceAuditType);
        if (null != qryMsgRsp && null != qryMsgRsp.getResult() && !qryMsgRsp.getResult().isEmpty()) {
            ArrayList<MsgResultBO> resultVOlist = new ArrayList<MsgResultBO>();
            for (ResultBO resultBO : qryMsgRsp.getResult()) {
                MsgResultBO msgResultBO = new MsgResultBO();
                BeanUtils.copyProperties((Object)resultBO, (Object)msgResultBO);
                MsgResult msgResult = new MsgResult();
                BeanUtils.copyProperties((Object)resultBO.getResult(), (Object)msgResult);
                msgResultBO.setResult(msgResult);
                resultVOlist.add(msgResultBO);
            }
            FscQryOutPushMsgReqBO fscQryOutPushMsgReqBO = new FscQryOutPushMsgReqBO();
            fscQryOutPushMsgReqBO.setGoodsSupplierId(reqBO.getGoodsSupplierId());
            fscQryOutPushMsgReqBO.setResultVOlist(resultVOlist);
            fscQryOutPushMsgReqBO.setType(this.invoiceAuditType);
            FscQryOutPushMsgRspBO rspBO = this.fscQryOutPushMsgBusiService.createAndQryOutPushMsg(fscQryOutPushMsgReqBO);
            if ("0000".equals(rspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)rspBO.getList())) {
                for (String msgId : rspBO.getList()) {
                    this.deletePushMsg(msgId, reqBO.getGoodsSupplierId());
                }
            }
        } else {
            log.debug("\u672a\u67e5\u8be2\u5230\u6d88\u606f\u7c7b\u578b\u4e3a[dealType=" + this.invoiceAuditType + "]\u7684\u5916\u90e8\u7535\u5546\u63a8\u9001\u6d88\u606f");
        }
        FscQryOutPushMsgRspBO rspBO = new FscQryOutPushMsgRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void validataParams(FscQryOutPushMsgReqBO reqBO) {
        if (reqBO.getGoodsSupplierId() == null || reqBO.getGoodsSupplierId() == 0L) {
            throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u7f16\u53f7[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private BusiGetMsgRspBO qryPushMsg(Long supNo, String dealType) {
        BusiGetMsgReqBO busiGetMsgReq = new BusiGetMsgReqBO();
        busiGetMsgReq.setSupplierId(supNo);
        busiGetMsgReq.setType(Integer.valueOf(dealType));
        BusiGetMsgRspBO qryMsgRsp = this.fscGetMsgPushService.getMsg(busiGetMsgReq);
        if (qryMsgRsp == null || !qryMsgRsp.isSuccess()) {
            log.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u5931\u8d25");
            return null;
        }
        List resultVOlist = qryMsgRsp.getResult();
        if (null == resultVOlist) {
            log.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u5916\u90e8\u670d\u52a1\u672a\u8fd4\u56de\u5904\u7406\u6d88\u606f");
            return null;
        }
        for (ResultBO resultVO : resultVOlist) {
            log.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2resultVO\uff1a" + resultVO.toString());
            if (null == resultVO.getResult()) continue;
            log.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2Result: " + resultVO.getResult().toString());
        }
        return qryMsgRsp;
    }

    private void deletePushMsg(String msgId, Long supplierId) {
        BusiDelMsgReqBO busiDelMsgReq = new BusiDelMsgReqBO();
        busiDelMsgReq.setId(msgId);
        busiDelMsgReq.setSupplierId(supplierId);
        BusiDelMsgRspBO usiDelMsgRsp = this.fscDelMsgPushBusiService.delMsgPush(busiDelMsgReq);
        if (!"0000".equals(usiDelMsgRsp.getRespCode())) {
            log.error("\u63a8\u9001\u6d88\u606f\u5165\u5e93\u65f6\u672a\u6210\u529f\u5220\u9664\u6570\u636e\u5e93\u4e2d\u672a\u5b58\u5728\u7684\u5916\u90e8\u8ba2\u5355\u7684\u63a8\u9001\u6d88\u606f!" + usiDelMsgRsp.getRespDesc());
        }
    }
}

