/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.authority.user.bo.SelectByUserIdsWebReqBO;
import com.ohaotian.authority.user.bo.SelectByUserIdsWebRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoWebBO;
import com.ohaotian.authority.user.service.SelectByUserIdsWebService;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.busi.bo.SaleOrderInfoBO;
import com.tydic.pfscext.api.deal.QueryOrderFlowService;
import com.tydic.pfscext.api.deal.bo.QueryOrderFlowReqBO;
import com.tydic.pfscext.api.deal.bo.QueryOrderFlowRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umcext.ability.org.UmcSelectMemByOrgAndRoleAbilityService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcSelectMemByOrgAndRoleAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcSelectMemByOrgAndRoleAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryOrderFlowService"})
public class QueryOrderFlowServiceImpl
implements QueryOrderFlowService {
    private static final Logger log = LoggerFactory.getLogger(QueryOrderFlowServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private ActQryActivitiesByConditionAbilityService activitiesByConditionAbilityService;
    @Autowired
    private UmcSelectMemByOrgAndRoleAbilityService umcSelectMemByOrgAndRoleAbilityService;
    @Autowired
    private SelectByUserIdsWebService selectByUserIdsWebService;
    private final String PURCHASE = "purchaser";
    @Value(value="${PURCHASE_SETTLE}")
    private String PURCHASE_SETTLE;
    @Value(value="${SUPPLIER_SETTLE}")
    private String SUPPLIER_SETTLE;
    @Value(value="${OPER_SETTLE}")
    private String OPER_SETTLE;
    private final String APPLY = "\u53d1\u8d77\u5f00\u7968";
    private final String INVOICE = "\u4e0a\u4f20\u53d1\u7968";
    private final String VERIFY = "\u6838\u5bf9\u7b7e\u6536";
    private final String FINISH = "\u5df2\u5b8c\u6210";
    private final String PAY = "\u53d1\u8d77\u4ed8\u6b3e";
    private final String CONFIRM = "\u786e\u8ba4\u4ed8\u6b3e";

    @PostMapping(value={"queryOrderFlow"})
    public QueryOrderFlowRspBO queryOrderFlow(@RequestBody QueryOrderFlowReqBO reqBO) {
        log.info("\u8ba2\u5355\u6d41\u7a0b\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        if (reqBO == null || reqBO.getOrderId() == null || StringUtils.isEmpty((Object)reqBO.getBusiModel()) || StringUtils.isEmpty((Object)reqBO.getOrderCode())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryOrderFlowRspBO rspBO = new QueryOrderFlowRspBO();
        ArrayList<PayPurchaseOrderInfoBO> payPurchaseOrderInfoBOS = new ArrayList<PayPurchaseOrderInfoBO>();
        ArrayList<SaleOrderInfoBO> saleOrderInfoBOS = new ArrayList<SaleOrderInfoBO>();
        ArrayList<ApplyPayInfoBO> applyPayInfoBOS = new ArrayList<ApplyPayInfoBO>();
        this.queryOrderInfo(reqBO, payPurchaseOrderInfoBOS, saleOrderInfoBOS);
        this.queryApplyPayInfo(reqBO, applyPayInfoBOS);
        rspBO.setApplyPayInfoBOS(applyPayInfoBOS);
        rspBO.setPayPurchaseOrderInfoBOS(payPurchaseOrderInfoBOS);
        rspBO.setSaleOrderInfoBOS(saleOrderInfoBOS);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getPayPurchaseOrderInfoBOS())) {
            rspBO.setUpOrDownFlag("1");
        } else {
            rspBO.setUpOrDownFlag("2");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void queryOrderInfo(QueryOrderFlowReqBO reqBO, List<PayPurchaseOrderInfoBO> payPurchaseOrderInfoBOS, List<SaleOrderInfoBO> saleOrderInfoBOS) {
        block33: {
            List<String> purchaseSettle;
            block32: {
                Object extJson;
                String[] split1 = this.PURCHASE_SETTLE.split(",");
                purchaseSettle = Arrays.asList(split1);
                String[] split3 = this.SUPPLIER_SETTLE.split(",");
                List<String> supplierSettle = Arrays.asList(split3);
                if (!BusiModel.MATCH_UP_MODEL.getCode().equals(reqBO.getBusiModel()) && !"2".equals(reqBO.getIsProfessionalOrgExt())) break block32;
                PayPurchaseOrderInfo info = new PayPurchaseOrderInfo();
                info.setOrderId(reqBO.getOrderId());
                List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByCondition(info);
                if (CollectionUtils.isEmpty(purchaseOrderInfos)) break block33;
                String settleModel = "";
                UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
                umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(purchaseOrderInfos.get(0).getPurchaseNo());
                UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
                if ("0000".equals(umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode()) && null != umcZhEnterpriseOrgDetailAbilityRspBO && null != umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() && null != (extJson = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getExtJson()) && !"".equals(extJson)) {
                    JSONObject json = JSON.parseObject((String)extJson);
                    settleModel = json.getString("settleModel");
                }
                for (PayPurchaseOrderInfo purchaseOrderInfo : purchaseOrderInfos) {
                    String nextStepName;
                    PayPurchaseOrderInfoBO bo = new PayPurchaseOrderInfoBO();
                    bo.setInspectionId(purchaseOrderInfo.getInspectionId().toString());
                    bo.setNotificationNo(purchaseOrderInfo.getNotificationNo());
                    bo.setOrderAmt(purchaseOrderInfo.getOrderAmt());
                    BillNotificationInfo notificationInfo = null;
                    ArrayList<String> roleIds = new ArrayList<String>();
                    if (!StringUtils.isEmpty((Object)purchaseOrderInfo.getNotificationNo()) && (notificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(purchaseOrderInfo.getNotificationNo())) != null) {
                        bo.setDrawerName(notificationInfo.getDrawerName());
                        bo.setApplyDate(notificationInfo.getApplyDate());
                    }
                    if (OrderStatus.NO_APPLY.getCode().equals(purchaseOrderInfo.getOrderStatus()) || OrderStatus.HANGING.getCode().equals(purchaseOrderInfo.getOrderStatus()) || OrderStatus.AUTO_HANG_UP.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
                        bo.setNextStep("\u53d1\u8d77\u5f00\u7968");
                        if ("purchaser".equals(settleModel)) {
                            bo.setNextStepName(purchaseOrderInfo.getPurchaserName());
                        } else {
                            roleIds.addAll(purchaseSettle);
                            nextStepName = this.queryUmcMemByRoleAndCompany(purchaseOrderInfo.getPurchaseNo(), roleIds);
                            bo.setNextStepName(nextStepName);
                        }
                    } else if (OrderStatus.APPLIED.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
                        bo.setNextStep("\u4e0a\u4f20\u53d1\u7968");
                        if ("2".equals(purchaseOrderInfo.getSource())) {
                            bo.setNextStepName("\u5916\u90e8\u7cfb\u7edf\u5904\u7406");
                        } else {
                            roleIds.addAll(supplierSettle);
                            nextStepName = this.queryUmcMemByRoleAndCompany(purchaseOrderInfo.getSupplierNo(), roleIds);
                            bo.setNextStepName(nextStepName);
                        }
                    } else if (OrderStatus.SEND_BILL.getCode().equals(purchaseOrderInfo.getOrderStatus()) && notificationInfo != null) {
                        bo.setNextStep("\u6838\u5bf9\u7b7e\u6536");
                        bo.setNextStepName(notificationInfo.getName());
                    } else if (OrderStatus.RECEIVE_BILL.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
                        bo.setNextStep("\u5df2\u5b8c\u6210");
                    }
                    payPurchaseOrderInfoBOS.add(bo);
                }
                break block33;
            }
            SaleOrderInfoVO vo = new SaleOrderInfoVO();
            vo.setOrderId(reqBO.getOrderId());
            List<SaleOrderInfo> orderInfos = this.saleOrderInfoMapper.getList(vo);
            if (!CollectionUtils.isEmpty(orderInfos)) {
                String extJson;
                String settleModel = "";
                UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
                umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(orderInfos.get(0).getPurchaseNo());
                UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
                if (null != umcZhEnterpriseOrgDetailAbilityRspBO && "0000".equals(umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode()) && null != umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() && null != (extJson = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getExtJson()) && !"".equals(extJson)) {
                    JSONObject json = JSON.parseObject((String)extJson);
                    settleModel = json.getString("settleModel");
                }
                for (SaleOrderInfo orderInfo : orderInfos) {
                    String nextStepName;
                    SaleOrderInfoBO bo = new SaleOrderInfoBO();
                    bo.setInspectionId(orderInfo.getInspectionId().toString());
                    bo.setApplyNo(orderInfo.getApplyNo());
                    bo.setOrderAmt(orderInfo.getOrderAmt());
                    BillApplyInfo billApplyInfo = null;
                    ArrayList<String> roleIds = new ArrayList<String>();
                    if (!StringUtils.isEmpty((Object)orderInfo.getApplyNo()) && (billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(orderInfo.getApplyNo())) != null) {
                        bo.setDrawerName(billApplyInfo.getName());
                        bo.setApplyDate(billApplyInfo.getApplyDate());
                    }
                    if (OrderStatus.NO_APPLY.getCode().equals(orderInfo.getOrderStatus()) || OrderStatus.HANGING.getCode().equals(orderInfo.getOrderStatus()) || OrderStatus.AUTO_HANG_UP.getCode().equals(orderInfo.getOrderStatus())) {
                        bo.setNextStep("\u53d1\u8d77\u5f00\u7968");
                        if (!StringUtils.isEmpty((Object)orderInfo.getActivityId())) {
                            if ("purchaser".equals(settleModel)) {
                                ActQryActivitiesByConditionAbilityReqBO activitiesByConditionAbilityReqBO = new ActQryActivitiesByConditionAbilityReqBO();
                                activitiesByConditionAbilityReqBO.setActiveId(orderInfo.getActivityId());
                                ActQryActivitiesByConditionAbilityRspBO activitiesByConditionAbilityRspBO = this.activitiesByConditionAbilityService.qryActivitiesByCondition(activitiesByConditionAbilityReqBO);
                                log.info("\u6d3b\u52a8\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)activitiesByConditionAbilityRspBO));
                                if ("0000".equals(activitiesByConditionAbilityRspBO.getRespCode())) {
                                    bo.setNextStepName(((ActivitiesBO)activitiesByConditionAbilityRspBO.getRows().get(0)).getActiveField5());
                                }
                            } else {
                                roleIds.addAll(purchaseSettle);
                                nextStepName = this.queryUmcMemByRoleAndCompany(orderInfo.getPurchaseNo(), roleIds);
                                bo.setNextStepName(nextStepName);
                            }
                        } else if ("purchaser".equals(settleModel)) {
                            bo.setNextStepName(orderInfo.getPurchaserName());
                        } else {
                            roleIds.addAll(purchaseSettle);
                            nextStepName = this.queryUmcMemByRoleAndCompany(orderInfo.getPurchaseNo(), roleIds);
                            bo.setNextStepName(nextStepName);
                        }
                    } else if (OrderStatus.APPLIED.getCode().equals(orderInfo.getOrderStatus())) {
                        bo.setNextStep("\u4e0a\u4f20\u53d1\u7968");
                        roleIds.add(this.OPER_SETTLE);
                        nextStepName = this.queryUmcMemByRoleAndCompany(orderInfo.getOperUnitNo(), roleIds);
                        bo.setNextStepName(nextStepName);
                    } else if (OrderStatus.SEND_BILL.getCode().equals(orderInfo.getOrderStatus()) && billApplyInfo != null) {
                        bo.setNextStep("\u6838\u5bf9\u7b7e\u6536");
                        bo.setNextStepName(billApplyInfo.getUserName());
                    } else if (OrderStatus.RECEIVE_BILL.getCode().equals(orderInfo.getOrderStatus())) {
                        bo.setNextStep("\u5df2\u5b8c\u6210");
                    }
                    saleOrderInfoBOS.add(bo);
                }
            }
        }
    }

    private void queryApplyPayInfo(QueryOrderFlowReqBO reqBO, List<ApplyPayInfoBO> applyPayInfoBOS) {
        String[] split2 = this.OPER_SETTLE.split(",");
        List<String> operSettle = Arrays.asList(split2);
        String[] split3 = this.SUPPLIER_SETTLE.split(",");
        List<String> supplierSettle = Arrays.asList(split3);
        QueryPayableDetailReqBO detailReqBO = new QueryPayableDetailReqBO();
        detailReqBO.setPurchaseOrderCodeLike(reqBO.getOrderCode());
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListPageByTerms(detailReqBO, (Page<Map<String, Object>>)new Page(-1, -1), null);
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            return;
        }
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            ApplyPayInfoBO bo = new ApplyPayInfoBO();
            bo.setPayableNo(payableDetailPO.getPayableNo());
            bo.setPayAmt(payableDetailPO.getPayableAmt());
            ApplyDetail applyDetail = this.applyDetailMapper.getModelByPayableNo(payableDetailPO.getPayableNo());
            if (applyDetail == null) {
                bo.setNextStep("\u53d1\u8d77\u4ed8\u6b3e");
                String purchaserId = payableDetailPO.getPurchaserId();
                List<Object> userIdList = new ArrayList<String>();
                if (purchaserId.contains(",")) {
                    String[] userIdArr = purchaserId.split(",");
                    userIdList = Arrays.asList(userIdArr);
                } else {
                    userIdList.add(purchaserId);
                }
                LinkedList<Long> userIds = new LinkedList<Long>();
                for (String string : userIdList) {
                    userIds.add(Long.valueOf(string));
                }
                SelectByUserIdsWebReqBO selectByUserIdsWebReqBO = new SelectByUserIdsWebReqBO();
                selectByUserIdsWebReqBO.setUserIds(userIds);
                SelectByUserIdsWebRspBO selectByUserIdsWebRspBO = this.selectByUserIdsWebService.selectUserInfoByIds(selectByUserIdsWebReqBO);
                if (selectByUserIdsWebRspBO == null || CollectionUtils.isEmpty((Collection)selectByUserIdsWebRspBO.getUserInfoList())) {
                    log.error("\u67e5\u8be2\u4f1a\u5458\u7528\u6237\u4fe1\u606f\u5931\u8d25" + selectByUserIdsWebRspBO.getMessage());
                    return;
                }
                List userInfoList = selectByUserIdsWebRspBO.getUserInfoList();
                LinkedList<String> nameList = new LinkedList<String>();
                for (SelectUserInfoWebBO selectUserInfoWebBO : userInfoList) {
                    nameList.add(selectUserInfoWebBO.getName());
                }
                if (!CollectionUtils.isEmpty(nameList)) {
                    String s = ((Object)nameList).toString();
                    bo.setNextStepName(s.substring(1, s.length() - 1));
                }
            } else {
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(applyDetail.getApplyNo());
                bo.setPayno(applyPayInfoPO.getPayno());
                bo.setApplyDate(applyPayInfoPO.getApplyDate());
                bo.setOperatorName(applyPayInfoPO.getOperatorName());
                if (ApplyPayStatus.PIDNG_DEALING.getCode().equals(applyPayInfoPO.getPayStatus()) || ApplyPayStatus.SUCCESS_PIDNG.getCode().equals(applyPayInfoPO.getPayStatus())) {
                    bo.setNextStep("\u786e\u8ba4\u4ed8\u6b3e");
                    ArrayList<String> roleIds = new ArrayList<String>();
                    roleIds.addAll(supplierSettle);
                    roleIds.addAll(operSettle);
                    String nextStepName = this.queryUmcMemByRoleAndCompany(applyPayInfoPO.getReceiptCompany(), roleIds);
                    bo.setNextStepName(nextStepName);
                } else if (ApplyPayStatus.PAY_CONFIRMED.getCode().equals(applyPayInfoPO.getPayStatus())) {
                    bo.setNextStep("\u5df2\u5b8c\u6210");
                }
            }
            applyPayInfoBOS.add(bo);
        }
    }

    private String queryUmcMemByRoleAndCompany(Long companyId, List<String> roleIds) {
        UmcSelectMemByOrgAndRoleAbilityReqBO selectMemByOrgAndRoleAbilityReqBO = new UmcSelectMemByOrgAndRoleAbilityReqBO();
        selectMemByOrgAndRoleAbilityReqBO.setCompanyId(companyId);
        selectMemByOrgAndRoleAbilityReqBO.setAuthIdentities(roleIds);
        String nextStepName = "";
        log.info("\u67e5\u8be2\u4f1a\u5458\u89d2\u8272\u7528\u6237\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)selectMemByOrgAndRoleAbilityReqBO));
        UmcSelectMemByOrgAndRoleAbilityRspBO selectMemByOrgAndRoleAbilityRspBO = this.umcSelectMemByOrgAndRoleAbilityService.selectMemByOrgAndRole(selectMemByOrgAndRoleAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u89d2\u8272\u7528\u6237\u4fe1\u606f\u51fa\u53c2" + JSON.toJSONString((Object)selectMemByOrgAndRoleAbilityRspBO));
        if (!"0000".equals(selectMemByOrgAndRoleAbilityRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)selectMemByOrgAndRoleAbilityRspBO.getMemDetailInfos())) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u89d2\u8272\u7528\u6237\u4fe1\u606f\u5931\u8d25" + selectMemByOrgAndRoleAbilityRspBO.getRespDesc());
            return null;
        }
        List memDetailInfos = selectMemByOrgAndRoleAbilityRspBO.getMemDetailInfos();
        for (UmcMemDetailInfoAbilityBO memDetailInfo : memDetailInfos) {
            if (StringUtils.isEmpty((Object)nextStepName)) {
                nextStepName = memDetailInfo.getMemName2();
                continue;
            }
            nextStepName = nextStepName + "," + memDetailInfo.getMemName2();
        }
        return nextStepName;
    }
}

