/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.busi.vo.InvoiceInfoVO;
import com.tydic.pfscext.api.deal.QueryPayInvoiceService;
import com.tydic.pfscext.api.deal.bo.BusiPayInvoiceInfoReqBO;
import com.tydic.pfscext.api.deal.bo.BusiPayInvoiceInfoRspBO;
import com.tydic.pfscext.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.PayItemInfoBO;
import com.tydic.pfscext.api.notify.SendReceiptInvoiceService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscUocPebUpdateBillStatusExternalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryPayInvoiceService"})
public class QueryPayInvoiceByNotifiNoServiceImpl
implements QueryPayInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayInvoiceByNotifiNoServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SendReceiptInvoiceService sendReceiptInvoiceService;
    @Autowired
    private FscUocPebUpdateBillStatusExternalService fscUocPebUpdateBillStatusExternalService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"selectByNotifyNo"})
    public BusiPayInvoiceInfoRspBO selectByNotifyNo(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String notificationNo = busiPayInvoiceInfoReqBO.getNotificationNo();
        ArrayList<PayInvoiceInfoBO> boList = new ArrayList<PayInvoiceInfoBO>();
        List<PayInvoiceInfo> ls = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        if (null != ls && ls.size() > 0) {
            for (PayInvoiceInfo payInvoiceInfo : ls) {
                PayInvoiceInfoBO bo = new PayInvoiceInfoBO();
                BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)bo);
                boList.add(bo);
            }
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setPayInvoiceInfoBOs(boList);
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"deleteByPrimaryKey"})
    public BusiPayInvoiceInfoRspBO deleteByPrimaryKey(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getPayInvoiceInfoBO()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayInvoiceInfoBO payInvoiceInfoBO = busiPayInvoiceInfoReqBO.getPayInvoiceInfoBO();
        try {
            this.payInvoiceInfoMapper.deleteByPrimaryKey(payInvoiceInfoBO.getInvoiceCode(), payInvoiceInfoBO.getInvoiceNo(), payInvoiceInfoBO.getInvoiceDate());
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5220\u9664\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"selectByPrimaryKey"})
    public BusiPayInvoiceInfoRspBO selectByPrimaryKey(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getInvoiceInfoVO()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceInfoVO ivVo = busiPayInvoiceInfoReqBO.getInvoiceInfoVO();
        PayInvoiceInfoBO bo = null;
        PayInvoiceInfo payInvoiceInfo = this.payInvoiceInfoMapper.selectByPrimaryKey(ivVo.getInvoiceCode(), ivVo.getInvoiceNo(), ivVo.getInvoiceDate());
        if (payInvoiceInfo != null) {
            bo = new PayInvoiceInfoBO();
            BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)bo);
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setPayInvoiceInfoBO(bo);
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"batchInsert"})
    public BusiPayInvoiceInfoRspBO batchInsert(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getNewIvDetails()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List newIvDetails = busiPayInvoiceInfoReqBO.getNewIvDetails();
        final ArrayList<PayInvoiceInfo> list = new ArrayList<PayInvoiceInfo>();
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        try {
            List orderIds;
            if (null != newIvDetails && newIvDetails.size() > 0) {
                for (PayInvoiceInfoBO bo : newIvDetails) {
                    logger.error("bo" + bo);
                    PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                    BeanUtils.copyProperties((Object)bo, (Object)invoiceInfo);
                    logger.error("invoiceInfo" + invoiceInfo);
                    list.add(invoiceInfo);
                }
            }
            this.payInvoiceInfoMapper.batchInsert(list);
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(((PayInvoiceInfo)list.get(0)).getNotificationNo());
            if (!CollectionUtils.isEmpty(payPurchaseOrderInfos) && !CollectionUtils.isEmpty(orderIds = payPurchaseOrderInfos.stream().map(PayPurchaseOrderInfo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                UocPebUpdateBillStatusReqBO ubsreqBO = new UocPebUpdateBillStatusReqBO();
                ubsreqBO.setOrderIds(orderIds);
                ubsreqBO.setBillState(Integer.valueOf(OrderStatus.SEND_BILL.getCode()));
                this.fscUocPebUpdateBillStatusExternalService.updateBillStatus(ubsreqBO);
            }
            new Thread(){

                @Override
                public void run() {
                    FscRemindReqBO fscRemindReqBO = new FscRemindReqBO();
                    fscRemindReqBO.setNotificationNo(((PayInvoiceInfo)list.get(0)).getNotificationNo());
                    logger.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3,\u53d1\u7968\u7b7e\u6536\u901a\u77e5\u670d\u52a1,\u8fdb\u5165\u7ebf\u7a0b\u6210\u529f\u5f00\u7968\u7f16\u53f7\uff1a" + ((PayInvoiceInfo)list.get(0)).getNotificationNo());
                    QueryPayInvoiceByNotifiNoServiceImpl.this.sendReceiptInvoiceService.send(fscRemindReqBO);
                }
            }.start();
            busiPayInvoiceInfoRspBO.setRespCode("0000");
            busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u53d1\u7968\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"updateByPrimaryKeySelective"})
    public BusiPayInvoiceInfoRspBO updateByPrimaryKeySelective(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getPayItemInfoBO()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            PayItemInfo payItemInfo = new PayItemInfo();
            PayItemInfoBO payItemInfoBO = busiPayInvoiceInfoReqBO.getPayItemInfoBO();
            BeanUtils.copyProperties((Object)payItemInfoBO, (Object)payItemInfo);
            int cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfo);
            if (cnt < 0) {
                throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }
}

