/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.pfscext.api.deal.QueryToDoCountsService;
import com.tydic.pfscext.api.deal.bo.QueryToDoCountsReqBO;
import com.tydic.pfscext.api.deal.bo.QueryToDoCountsRspBO;
import com.tydic.pfscext.api.deal.bo.ToDoInfoBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.ToDoPageUrlMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.ToDoDetail;
import com.tydic.pfscext.dao.po.ToDoPageUrl;
import com.tydic.pfscext.dao.vo.BillApplyInfoTabVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.dao.vo.ToDoDetailMapper;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.Source;
import com.tydic.pfscext.enums.ToDoItem;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryToDoCountsService"})
public class QueryToDoCountsServiceImpl
implements QueryToDoCountsService {
    private static final Logger log = LoggerFactory.getLogger(QueryToDoCountsServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private ToDoPageUrlMapper toDoPageUrlMapper;
    @Autowired
    private ToDoDetailMapper toDoDetailMapper;
    @Autowired
    private ActQryActivitiesByConditionAbilityService actQryActivitiesByConditionAbilityService;
    private final String PURCHASER = "purchaser";
    private final String PURCHASE_SETTLE = "\u91c7\u8d2d\u5355\u4f4d\u7ed3\u7b97\u5458";
    private final String PURCHASE_BENEFIT = "\u91c7\u8d2d\u5355\u4f4d\u798f\u5229\u7ba1\u7406\u5458";

    @PostMapping(value={"queryToDoCounts"})
    public QueryToDoCountsRspBO queryToDoCounts(@RequestBody QueryToDoCountsReqBO reqBO) {
        log.info("\u67e5\u8be2\u7ed3\u7b97\u5f85\u529e\u4e8b\u9879\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        List roleAuthoritys = reqBO.getRoleAuthoritys();
        if (CollectionUtils.isEmpty((Collection)roleAuthoritys)) {
            throw new PfscExtBusinessException("0001", "\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedList<ToDoInfoBO> toDoInfoBOS = new LinkedList<ToDoInfoBO>();
        QueryToDoCountsRspBO rspBO = new QueryToDoCountsRspBO();
        boolean benefitFlag1 = false;
        boolean benefitFlag2 = false;
        ToDoDetail toDoDetail = new ToDoDetail();
        toDoDetail.setUnitCategory(reqBO.getIsProfessionalOrgExt());
        List<ToDoDetail> toDoDetails = this.toDoDetailMapper.getListByCondition(toDoDetail);
        if (CollectionUtils.isEmpty(toDoDetails)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u627e\u5230\u5bf9\u5e94\u5f85\u529e\u4e8b\u9879");
            return rspBO;
        }
        HashSet<String> toDoItemSet = new HashSet<String>();
        for (ToDoDetail doDetail : toDoDetails) {
            for (String roleAuthority : roleAuthoritys) {
                if (StringUtils.isEmpty((Object)doDetail.getRoleAuth()) || !doDetail.getRoleAuth().contains(roleAuthority)) continue;
                String toDoItem = doDetail.getToDoItem();
                if (toDoItem != null && toDoItem.contains(",")) {
                    List<String> toDoItemList = Arrays.asList(toDoItem.split(","));
                    toDoItemSet.addAll(toDoItemList);
                } else if (!StringUtils.isEmpty((Object)toDoItem)) {
                    toDoItemSet.add(toDoItem);
                }
                if ("\u91c7\u8d2d\u5355\u4f4d\u798f\u5229\u7ba1\u7406\u5458".equals(doDetail.getRoleName())) {
                    benefitFlag1 = true;
                }
                if (!"\u91c7\u8d2d\u5355\u4f4d\u7ed3\u7b97\u5458".equals(doDetail.getRoleName())) continue;
                benefitFlag2 = true;
            }
        }
        if (!CollectionUtils.isEmpty(toDoItemSet)) {
            if (benefitFlag1 && !benefitFlag2 && CollectionUtils.isEmpty((Collection)reqBO.getActivityIds())) {
                this.getActivityIds(reqBO);
            }
            this.queryTodoItem(toDoItemSet, reqBO, toDoInfoBOS);
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u7528\u6237\u6ca1\u6709\u9700\u8981\u67e5\u8be2\u7684\u5f85\u529e\u4e8b\u9879");
        }
        rspBO.setToDoCountsBOS(toDoInfoBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void queryTodoItem(Set<String> toDoItemSet, QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS) {
        log.info("\u8be5\u7528\u6237\u6700\u7ec8\u67e5\u8be2\u7684\u5f85\u529e\u4e8b\u9879\u4e3a\uff1a" + JSON.toJSONString(toDoItemSet));
        for (String toDoItemCode : toDoItemSet) {
            if (ToDoItem.MATCH_UP_NO_APPLY.getCode().equals(toDoItemCode)) {
                this.matchUpNoApply(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.TRADE_NO_APPLY.getCode().equals(toDoItemCode)) {
                this.tradeNoApply(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.BENEFIT_NO_APPLY.getCode().equals(toDoItemCode)) {
                this.benefitNoApply(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.REDUNDANCY_NO_APPLY.getCode().equals(toDoItemCode)) {
                this.redundancyNoApply(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.REDUNDANCY_APPLIED.getCode().equals(toDoItemCode)) {
                this.redundancyApplied(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.REDUNDANCY_CANCELING.getCode().equals(toDoItemCode)) {
                this.redundancyCanceling(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.MATCH_UP_SENDING_BILL.getCode().equals(toDoItemCode)) {
                this.matchUpSendingBill(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.TRADE_SENDING_BILL.getCode().equals(toDoItemCode)) {
                this.tradeSendingBill(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.BENEFIT_SENDING_BILL.getCode().equals(toDoItemCode)) {
                this.benefitSendingBill(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.REDUNDANCY_SENDING_BILL.getCode().equals(toDoItemCode)) {
                this.redundancySendingBill(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.UP_SUPPLIER_NO_APPLY.getCode().equals(toDoItemCode)) {
                this.upSupplierNoApply(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.DOWN_PURCHASE_APPLIED.getCode().equals(toDoItemCode)) {
                this.downPurchaseApplied(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.UP_SUPPLIER_SENDING_BILL.getCode().equals(toDoItemCode)) {
                this.upSupplierSendingBill(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.DOWN_PURCHASE_CANCELING.getCode().equals(toDoItemCode)) {
                this.downPurchaseCanceling(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (ToDoItem.SUPPLIER_APPLIED.getCode().equals(toDoItemCode)) {
                this.supplierApplied(reqBO, toDoInfoBOS, toDoItemCode);
                continue;
            }
            if (!ToDoItem.SUPPLIER_CANCELING.getCode().equals(toDoItemCode)) continue;
            this.supplierCanceling(reqBO, toDoInfoBOS, toDoItemCode);
        }
    }

    private void supplierCanceling(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.SUPPLIER_CANCELING.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.CANCELING.getCode());
        info.setSupplierNo(reqBO.getSupId());
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void supplierApplied(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.SUPPLIER_APPLIED.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        info.setSupplierNo(reqBO.getSupId());
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void downPurchaseCanceling(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.DOWN_PURCHASE_CANCELING.getDescr());
        BillApplyInfoTabVO vo = new BillApplyInfoTabVO();
        vo.setBillStatus(BillStatus.CANCELING.getCode());
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        int count = this.billApplyInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void upSupplierSendingBill(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.UP_SUPPLIER_SENDING_BILL.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
        info.setOperNo(reqBO.getCompanyId());
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void downPurchaseApplied(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.DOWN_PURCHASE_APPLIED.getDescr());
        BillApplyInfoTabVO vo = new BillApplyInfoTabVO();
        vo.setBillStatus(BillStatus.NO_APPLY.getCode());
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        int count = this.billApplyInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void upSupplierNoApply(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.UP_SUPPLIER_NO_APPLY.getDescr());
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setNoAgreeOrderCategory("1");
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        ArrayList<String> orderStatusCodes = new ArrayList<String>();
        orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
        orderStatusCodes.add(OrderStatus.SENDING.getCode());
        orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
        orderStatusCodes.add(OrderStatus.HANGING.getCode());
        vo.setOperUnitNo(reqBO.getCompanyId());
        vo.setExcludeOrg(reqBO.getCompanyId());
        vo.setOrderStatusCodes(orderStatusCodes);
        int count = this.payPurchaseOrderInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void redundancySendingBill(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.REDUNDANCY_SENDING_BILL.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
        info.setOperNo(reqBO.getCompanyId());
        info.setSource(Source.NORMAL_ELC.getCode());
        if ("purchaser".equals(reqBO.getSettleModel())) {
            info.setDrawerId(reqBO.getUserId());
        }
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void benefitSendingBill(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.BENEFIT_SENDING_BILL.getDescr());
        BillApplyInfoTabVO vo = new BillApplyInfoTabVO();
        ArrayList<String> billStatusSet = new ArrayList<String>();
        billStatusSet.add(BillStatus.SEND_BILL.getCode());
        billStatusSet.add(BillStatus.PART_BILL.getCode());
        vo.setBillStatusSet(billStatusSet);
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        vo.setPurchaseNo(reqBO.getCompanyId());
        vo.setActivityIds(reqBO.getActivityIds());
        int count = this.billApplyInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void tradeSendingBill(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.TRADE_SENDING_BILL.getDescr());
        BillApplyInfoTabVO vo = new BillApplyInfoTabVO();
        if ("purchaser".equals(reqBO.getSettleModel())) {
            vo.setUserId(reqBO.getUserId());
        }
        ArrayList<String> billStatusSet = new ArrayList<String>();
        billStatusSet.add(BillStatus.SEND_BILL.getCode());
        billStatusSet.add(BillStatus.PART_BILL.getCode());
        vo.setBillStatusSet(billStatusSet);
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        vo.setPurchaseNo(reqBO.getCompanyId());
        int count = this.billApplyInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void matchUpSendingBill(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.MATCH_UP_SENDING_BILL.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
        info.setOperNo(reqBO.getCompanyId());
        if ("purchaser".equals(reqBO.getSettleModel())) {
            info.setDrawerId(reqBO.getUserId());
        }
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void redundancyCanceling(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.REDUNDANCY_CANCELING.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.CANCELING.getCode());
        info.setSupplierNo(reqBO.getCompanyId());
        info.setSource(Source.NORMAL_ELC.getCode());
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void redundancyApplied(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.REDUNDANCY_APPLIED.getDescr());
        BillNotificationInfo info = new BillNotificationInfo();
        info.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        info.setSupplierNo(reqBO.getCompanyId());
        info.setSource(Source.NORMAL_ELC.getCode());
        int count = this.billNotificationInfoMapper.getCountByCondition(info);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void redundancyNoApply(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.REDUNDANCY_NO_APPLY.getDescr());
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        if ("purchaser".equals(reqBO.getSettleModel())) {
            vo.setPurchaserId(reqBO.getUserId());
        }
        vo.setPurchaseNo(reqBO.getCompanyId());
        vo.setSource(Source.NORMAL_ELC.getCode());
        vo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
        ArrayList<String> orderStatusCodes = new ArrayList<String>();
        orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
        orderStatusCodes.add(OrderStatus.SENDING.getCode());
        orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
        orderStatusCodes.add(OrderStatus.HANGING.getCode());
        vo.setOrderStatusCodes(orderStatusCodes);
        vo.setNoAgreeOrderCategory("0");
        int count = this.payPurchaseOrderInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void benefitNoApply(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.BENEFIT_NO_APPLY.getDescr());
        SaleOrderInfoVO vo = new SaleOrderInfoVO();
        vo.setActivityIds(reqBO.getActivityIds());
        vo.setPurchaseNo(reqBO.getCompanyId());
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        ArrayList<String> orderStatusList = new ArrayList<String>();
        orderStatusList.add(OrderStatus.NO_APPLY.getCode());
        orderStatusList.add(OrderStatus.SENDING.getCode());
        orderStatusList.add(OrderStatus.AUTO_HANG_UP.getCode());
        orderStatusList.add(OrderStatus.HANGING.getCode());
        vo.setOrderStatusList(orderStatusList);
        vo.setOrderCategory("1");
        int count = this.saleOrderInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void tradeNoApply(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.TRADE_NO_APPLY.getDescr());
        SaleOrderInfoVO vo = new SaleOrderInfoVO();
        if ("purchaser".equals(reqBO.getSettleModel())) {
            vo.setPurchaserId(reqBO.getUserId());
        }
        vo.setPurchaseNo(reqBO.getCompanyId());
        vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        vo.setOrderCategory("0");
        ArrayList<String> orderStatusList = new ArrayList<String>();
        orderStatusList.add(OrderStatus.NO_APPLY.getCode());
        orderStatusList.add(OrderStatus.SENDING.getCode());
        orderStatusList.add(OrderStatus.AUTO_HANG_UP.getCode());
        orderStatusList.add(OrderStatus.HANGING.getCode());
        vo.setOrderStatusList(orderStatusList);
        int count = this.saleOrderInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void matchUpNoApply(QueryToDoCountsReqBO reqBO, List<ToDoInfoBO> toDoInfoBOS, String toDoItemCode) {
        ToDoInfoBO bo = new ToDoInfoBO();
        bo.setToDoItem(ToDoItem.MATCH_UP_NO_APPLY.getDescr());
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setPurchaseNo(reqBO.getCompanyId());
        vo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
        vo.setNoAgreeOrderCategory("1");
        if ("purchaser".equals(reqBO.getSettleModel())) {
            vo.setPurchaserId(reqBO.getUserId());
        }
        ArrayList<String> orderStatusCodes = new ArrayList<String>();
        orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
        orderStatusCodes.add(OrderStatus.SENDING.getCode());
        orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
        orderStatusCodes.add(OrderStatus.HANGING.getCode());
        vo.setOrderStatusCodes(orderStatusCodes);
        int count = this.payPurchaseOrderInfoMapper.getCountByCondition(vo);
        bo.setCount(Integer.valueOf(count));
        ToDoPageUrl toDoPageUrl = new ToDoPageUrl();
        this.queryPageUrl(toDoItemCode, toDoPageUrl, bo);
        toDoInfoBOS.add(bo);
    }

    private void queryPageUrl(String toDoItemCode, ToDoPageUrl toDoPageUrl, ToDoInfoBO bo) {
        toDoPageUrl.setToDoItem(toDoItemCode);
        ToDoPageUrl toDoPageUrl2 = this.toDoPageUrlMapper.selectOneByCondition(toDoPageUrl);
        bo.setPageUrl(toDoPageUrl2.getPageUrl());
        Map map = (Map)JSONObject.parseObject((String)toDoPageUrl2.getPageParam(), Map.class);
        bo.setPageParam(map);
    }

    private void getActivityIds(QueryToDoCountsReqBO reqBO) {
        LinkedList<Long> activityIds = new LinkedList<Long>();
        ActQryActivitiesByConditionAbilityReqBO activitiesByConditionAbilityReqBO = new ActQryActivitiesByConditionAbilityReqBO();
        activitiesByConditionAbilityReqBO.setCreateLoginId(reqBO.getMemIdExt().toString());
        activitiesByConditionAbilityReqBO.setPageNo(Integer.valueOf(-1));
        activitiesByConditionAbilityReqBO.setPageSize(Integer.valueOf(-1));
        ActQryActivitiesByConditionAbilityRspBO activitiesByConditionAbilityRspBO = this.actQryActivitiesByConditionAbilityService.qryActivitiesByCondition(activitiesByConditionAbilityReqBO);
        if (activitiesByConditionAbilityRspBO != null && "0000".equals(activitiesByConditionAbilityRspBO.getRespCode())) {
            for (ActivitiesBO row : activitiesByConditionAbilityRspBO.getRows()) {
                activityIds.add(row.getActiveId());
            }
        }
        reqBO.setActivityIds(activityIds);
    }
}

