/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.deal.ReverseAmountCalculationService;
import com.tydic.pfscext.api.deal.bo.PrepaymentRefundAmountBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.ReverseAmountCalculationService"})
public class ReverseAmountCalculationServiceImpl
implements ReverseAmountCalculationService {
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    @PostMapping(value={"calculatePrepaymentRefundAmountA"})
    public PfscExtRspBaseBO calculatePrepaymentRefundAmountA(@RequestBody PrepaymentRefundAmountBO prepaymentRefundAmountBO) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            BigDecimal RefundAmount = prepaymentRefundAmountBO.getAfterSaleAmount().subtract(prepaymentRefundAmountBO.getPrepaymentAcceptanceAmount());
            this.updatePayableDetailPO(RefundAmount, prepaymentRefundAmountBO);
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        pfscExtRspBaseBO.setRespCode("0000");
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        return pfscExtRspBaseBO;
    }

    @PostMapping(value={"calculatePrepaymentRefundAmountB"})
    public BigDecimal[] calculatePrepaymentRefundAmountB(@RequestBody PrepaymentRefundAmountBO prepaymentRefundAmountBO) {
        BigDecimal downRefundAmount = prepaymentRefundAmountBO.getAfterSaleAmount().multiply(prepaymentRefundAmountBO.getDownPaymentRatio());
        BigDecimal prepaidRefundAmount = prepaymentRefundAmountBO.getAfterSaleAmount().multiply(prepaymentRefundAmountBO.getProportionAcceptance());
        BigDecimal totalRefundAmount = downRefundAmount.add(prepaidRefundAmount);
        BigDecimal[] RefundAmounts = new BigDecimal[]{downRefundAmount, prepaidRefundAmount, totalRefundAmount};
        return RefundAmounts;
    }

    @PostMapping(value={"calculatePrepaymentRefundAmountC"})
    public BigDecimal calculatePrepaymentRefundAmountC(@RequestBody PrepaymentRefundAmountBO prepaymentRefundAmountBO) {
        BigDecimal RefundAmount = prepaymentRefundAmountBO.getAfterSaleAmount().subtract(prepaymentRefundAmountBO.getArrivalUnpaidAmount()).subtract(prepaymentRefundAmountBO.getAcceptanceUnpaidAmount()).subtract(prepaymentRefundAmountBO.getAfterSaleAmount().multiply(prepaymentRefundAmountBO.getWarrantyRatio()));
        this.updatePayableDetailPO(RefundAmount, prepaymentRefundAmountBO);
        return RefundAmount;
    }

    public void updatePayableDetailPO(BigDecimal RefundAmount, PrepaymentRefundAmountBO prepaymentRefundAmountBO) {
        PayableDetailPO payableDetailPO = new PayableDetailPO();
        if (RefundAmount.compareTo(BigDecimal.ZERO) >= 0) {
            payableDetailPO.setPayableAmt(BigDecimal.ZERO);
            payableDetailPO.setPayableStatus(PayableStatus.TERMINATION.getCode());
            if (null != prepaymentRefundAmountBO.getPayableNo() && "" != prepaymentRefundAmountBO.getPayableNo()) {
                payableDetailPO.setPayableNo(prepaymentRefundAmountBO.getPayableNo());
                this.payableDetailMapper.updatePayableAmt(payableDetailPO);
            }
        } else {
            payableDetailPO.setPayableAmt(RefundAmount.abs());
            if (null != prepaymentRefundAmountBO.getPayableNo() && "" != prepaymentRefundAmountBO.getPayableNo()) {
                payableDetailPO.setPayableNo(prepaymentRefundAmountBO.getPayableNo());
                this.payableDetailMapper.updatePayableAmt(payableDetailPO);
            }
        }
    }
}

