/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.pfscext.api.notify.SendPayResultService;
import com.tydic.pfscext.api.pay.CreatePayOrderService;
import com.tydic.pfscext.api.pay.bo.CreatePayOrderReqBO;
import com.tydic.pfscext.api.pay.bo.CreatePayOrderRspBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.FscPaymentFlowInfoDetailMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.FscPaymentFlowInfoDetailPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.pay.api.FscPayProOrderAbilityService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.CreatePayOrderService"})
public class CreatePayOrderServiceImpl
implements CreatePayOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePayOrderServiceImpl.class);
    @Autowired
    private FscPayProOrderAbilityService fscPayProOrderAbilityService;
    @Resource(name="payOrderSeq")
    private OrderSequence payOrderSeq;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Value(value="${service_url}")
    private String service_url;
    @Value(value="${openUnitNo}")
    private Long openUnitNo;
    @Value(value="${PAY_RESULT_CALL_BACK_CQT:http://}")
    private String PAY_RESULT_CALL_BACK_CQT;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private FscPaymentFlowInfoDetailMapper fscPaymentFlowInfoDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private SendPayResultService sendPayResultService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    private static final Integer TRADE_MODEL = 0;
    private static final Integer INVOIC_PAYABLE_TYPE = 1;
    @Value(value="${professOfflineUrl:http://}")
    private String professOfflineUrl;
    @Value(value="${FSC_PAY_CENTER_CHINA_BANK_TRIGGER:1}")
    private String FSC_PAY_CENTER_CHINA_BANK_TRIGGER;

    @PostMapping(value={"createPayOrder"})
    public CreatePayOrderRspBO createPayOrder(@RequestBody CreatePayOrderReqBO reqBO) {
        logger.info("\u521b\u5efa\u7edf\u4e00\u8ba2\u5355\u5165\u53c2\u53c2\u6570\uff1a" + JSON.toJSONString((Object)reqBO));
        CreatePayOrderRspBO rspBO = new CreatePayOrderRspBO();
        if (null == reqBO.getId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMethod()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u96c6\u5408[pyMethod]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = reqBO.getId();
        try {
            String busiCode = "";
            Long merchantId = null;
            StringBuffer payOrderNo = new StringBuffer();
            String payAmt = "0";
            String detailName = "";
            BigDecimal payOrderAmt = BigDecimal.ZERO;
            OrgMerchantConfigPO orgMerchantConfigPO = new OrgMerchantConfigPO();
            Long purchaseNo = null;
            Long operUnitId = null;
            Long supplierId = null;
            Integer busiModel = null;
            String orderCode = "";
            String childOrderCode = "";
            String ordPurchaserId = "";
            if (reqBO.getPaymentOrderType().equals("0")) {
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(orderNo);
                payOrderNo.append("PAYMENT-").append(applyPayInfoPO.getPayno());
                if (null == applyPayInfoPO.getPayAmt()) {
                    rspBO.setRespDesc("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                    rspBO.setRespCode("18000");
                    return rspBO;
                }
                payOrderAmt = applyPayInfoPO.getPayAmt();
                BigDecimal payAmtB = applyPayInfoPO.getPayAmt().multiply(new BigDecimal(100));
                payAmt = payAmtB.setScale(0, 1).toString();
                List<PayableDetailPO> list = this.payableDetailMapper.getListByApplyNo(orderNo);
                if (CollectionUtils.isEmpty(list)) {
                    throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728!");
                }
                orderCode = list.get(0).getPurchaseOrderCode();
                childOrderCode = list.get(0).getChildPurchaseOrderCode();
                if (!PayableType.NOTIFICATION.getCodeAsInt().equals(list.get(0).getPayableType()) || !BusiModel.TRADE_MODEL.getCodeAsInt().equals(list.get(0).getBusiModel())) {
                    ordPurchaserId = list.get(0).getPurchaserId();
                }
                Long receiptOrgId = applyPayInfoPO.getSupplierId();
                if (TRADE_MODEL.equals(list.get(0).getBusiModel()) && !INVOIC_PAYABLE_TYPE.equals(list.get(0).getPayableType())) {
                    receiptOrgId = list.get(0).getOperatorId();
                }
                if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                    rspBO.setRespDesc("\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                    rspBO.setRespCode("18000");
                    return rspBO;
                }
                busiCode = orgMerchantConfigPO.getBusiCode();
                merchantId = orgMerchantConfigPO.getMerchantId();
                if (TRADE_MODEL.equals(list.get(0).getBusiModel()) && list.get(0).getPaymentType().equals("01")) {
                    if (null == orgMerchantConfigPO.getIntermendiateId()) {
                        rspBO.setRespDesc("\u8bf7\u5148\u914d\u7f6e\u4e8c\u6b21\u652f\u4ed8\u5546\u6237\u4fe1\u606f");
                        rspBO.setRespCode("18000");
                        return rspBO;
                    }
                    merchantId = orgMerchantConfigPO.getIntermendiateId();
                }
                detailName = "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e";
            } else {
                PayOrderInfoPO payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(Long.valueOf(orderNo));
                payOrderNo.append("SERVICE-FEE-").append(orderNo);
                if (null == payOrderInfoPO.getActualAmount()) {
                    rspBO.setRespDesc("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                    rspBO.setRespCode("18000");
                    return rspBO;
                }
                payOrderAmt = payOrderInfoPO.getActualAmount();
                BigDecimal payAmtC = payOrderInfoPO.getActualAmount().multiply(new BigDecimal(100));
                payAmt = payAmtC.setScale(0, 1).toString();
                orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(this.openUnitNo);
                if (null == orgMerchantConfigPO) {
                    rspBO.setRespDesc("\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                    rspBO.setRespCode("18000");
                    return rspBO;
                }
                busiCode = orgMerchantConfigPO.getBusiCode();
                merchantId = orgMerchantConfigPO.getMerchantId();
                detailName = "\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39";
                supplierId = payOrderInfoPO.getSupplierId();
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setPayOrderCode(payOrderInfoPO.getPayOrderCode());
                List<SaleOrderInfo> saleOrderInfoVOS = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                if (!CollectionUtils.isEmpty(saleOrderInfoVOS)) {
                    operUnitId = saleOrderInfoVOS.get(0).getOperUnitNo();
                }
            }
            PaymentFlowInfo paymentFlowInfoPO = this.paymentFlowInfoMapper.selectByOutOrderId(payOrderNo.toString());
            String notifyUrl = "";
            if (null != paymentFlowInfoPO && StringUtils.isBlank((CharSequence)paymentFlowInfoPO.getPaymentStatus())) {
                logger.info("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u91cd\u53d1");
                paymentFlowInfoPO.setCreateUserId(reqBO.getUserId());
                paymentFlowInfoPO.setCreateUserName(reqBO.getName());
                paymentFlowInfoPO.setPayChannel(reqBO.getPayChannel());
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfoPO);
                detailName = paymentFlowInfoPO.getOrderDesc();
                notifyUrl = paymentFlowInfoPO.getAsynUrl();
            }
            if (null != paymentFlowInfoPO && "SUCCESS".equals(paymentFlowInfoPO.getPaymentStatus())) {
                logger.error("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
                return rspBO;
            }
            PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
            payProOrderAbilityServiceReqBo.setOutOrderId(payOrderNo.toString());
            payProOrderAbilityServiceReqBo.setBusiCode(busiCode);
            payProOrderAbilityServiceReqBo.setMerchantId(String.valueOf(merchantId));
            payProOrderAbilityServiceReqBo.setTotalFee(payAmt);
            payProOrderAbilityServiceReqBo.setDetailName(detailName);
            payProOrderAbilityServiceReqBo.setRemark("");
            if (StringUtils.isEmpty((CharSequence)notifyUrl)) {
                payProOrderAbilityServiceReqBo.setNotifyUrl(this.service_url);
            } else {
                payProOrderAbilityServiceReqBo.setNotifyUrl(notifyUrl);
            }
            payProOrderAbilityServiceReqBo.setReqWay("1");
            payProOrderAbilityServiceReqBo.setCreateIpAddress(reqBO.getIpAddress());
            payProOrderAbilityServiceReqBo.setCreateOperId(String.valueOf(reqBO.getUserId()));
            payProOrderAbilityServiceReqBo.setCreateOperIdName(reqBO.getName());
            payProOrderAbilityServiceReqBo.setRedirectUrl(reqBO.getWebUrl());
            JSONObject busiReqJson = new JSONObject();
            busiReqJson.put("payMethods", (Object)reqBO.getPayMethod());
            busiReqJson.put("notifyAddress", (Object)this.PAY_RESULT_CALL_BACK_CQT);
            if (null != reqBO.getPurchaseCorpInfo()) {
                busiReqJson.put("corpIdTypeCore", (Object)"BUSINESS_LICENSE_SZ");
                busiReqJson.put("corpNameCore", (Object)reqBO.getPurchaseCorpInfo().getCorpName());
                busiReqJson.put("corpIdCodeCore", (Object)reqBO.getPurchaseCorpInfo().getCorpIdCode());
            }
            String offlineUlr = "";
            offlineUlr = this.professOfflineUrl + "?applyNo=" + reqBO.getId() + "&offlineWebUrl=" + reqBO.getOfflineWebUrl();
            busiReqJson.put("offlinePayUrl", (Object)offlineUlr);
            if (YesNo.YES.getCode().equals(this.FSC_PAY_CENTER_CHINA_BANK_TRIGGER)) {
                busiReqJson.put("payCenterTrigger", (Object)"1");
            } else {
                busiReqJson.put("payCenterTrigger", (Object)"1");
            }
            String busiReqData = busiReqJson.toJSONString();
            logger.error("busiReqDataStr\uff1a" + busiReqData);
            payProOrderAbilityServiceReqBo.setBusiReqData(busiReqData);
            logger.error("\u8bf7\u6c42\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.fscPayProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
            if (null == payProOrderAbilityServiceRspBo.getRespCode() || !payProOrderAbilityServiceRspBo.getRespCode().equals("0000")) {
                logger.error("\u521b\u5efa\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProOrderAbilityServiceRspBo.getRespDesc());
                this.savelog("CreatePayOrderService-197", JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                throw new PfscExtBusinessException("18000", payProOrderAbilityServiceRspBo.getRespDesc());
            }
            this.savelog("CreatePayOrderService-200", JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            logger.error("\u54cd\u5e94\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if ("0".equals(reqBO.getPaymentOrderType())) {
                List<PayableDetailPO> list = this.payableDetailMapper.getListByApplyNo(orderNo);
                purchaseNo = list.get(0).getPurchaseNo();
                operUnitId = list.get(0).getOperatorId();
                supplierId = list.get(0).getSupplierId();
                busiModel = list.get(0).getBusiModel();
            }
            if (null == paymentFlowInfoPO) {
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(payOrderNo.toString());
                paymentFlowInfo.setPaymentFlowId(payProOrderAbilityServiceRspBo.getOrderId());
                paymentFlowInfo.setMerchantId(merchantId);
                paymentFlowInfo.setOrgId(reqBO.getOrgId());
                if (null == payProOrderAbilityServiceRspBo.getPayFee() || "".equals(payProOrderAbilityServiceRspBo.getPayFee())) {
                    paymentFlowInfo.setOrderAmt(BigDecimal.ZERO);
                } else {
                    BigDecimal resultAmt = new BigDecimal(payProOrderAbilityServiceRspBo.getPayFee());
                    resultAmt = resultAmt.divide(new BigDecimal(100));
                    paymentFlowInfo.setOrderAmt(resultAmt);
                }
                paymentFlowInfo.setOrderAmt(payOrderAmt);
                paymentFlowInfo.setPayOrgNo(reqBO.getOrgId());
                paymentFlowInfo.setRecOrgNo(orgMerchantConfigPO.getOrgId());
                paymentFlowInfo.setOrderDesc(detailName);
                paymentFlowInfo.setPayChannel(reqBO.getPayChannel());
                paymentFlowInfo.setWebUrl(reqBO.getWebUrl());
                paymentFlowInfo.setAsynUrl(this.service_url);
                paymentFlowInfo.setClientIp(reqBO.getIpAddress());
                paymentFlowInfo.setOrderRemark(payProOrderAbilityServiceRspBo.getRemark());
                paymentFlowInfo.setOrderCode(orderCode);
                paymentFlowInfo.setChildOrderCode(childOrderCode);
                paymentFlowInfo.setOrdPurchaserId(ordPurchaserId);
                paymentFlowInfo.setCreateUserId(reqBO.getUserId());
                paymentFlowInfo.setCreateUserName(reqBO.getName());
                paymentFlowInfo.setBusiReqData(payProOrderAbilityServiceRspBo.getBusiRspData());
                paymentFlowInfo.setPayOrderId(payProOrderAbilityServiceRspBo.getPayOrderId());
                paymentFlowInfo.setBankUrl(payProOrderAbilityServiceRspBo.getUrl());
                paymentFlowInfo.setBankFlowId(payProOrderAbilityServiceRspBo.getPayNotifyTransId());
                if ("0".equals(reqBO.getPaymentOrderType())) {
                    String purcharseOrgName = this.organizationInfoService.queryOrgName(purchaseNo);
                    String supplierName = this.organizationInfoService.querySupplierName(supplierId);
                    if (TRADE_MODEL.equals(busiModel)) {
                        String operUnitName = this.organizationInfoService.queryOrgName(operUnitId);
                        paymentFlowInfo.setRecName(operUnitName);
                        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                            paymentFlowInfo.setPayName(operUnitName);
                            paymentFlowInfo.setRecName(supplierName);
                        } else {
                            paymentFlowInfo.setPayName(purcharseOrgName);
                            paymentFlowInfo.setRecName(operUnitName);
                        }
                    } else {
                        if (StringUtils.isBlank((CharSequence)supplierName)) {
                            supplierName = this.organizationInfoService.queryOrgName(supplierId);
                        }
                        paymentFlowInfo.setRecName(supplierName);
                        paymentFlowInfo.setPayName(purcharseOrgName);
                    }
                } else {
                    String supplierName = this.organizationInfoService.querySupplierName(supplierId);
                    if (StringUtils.isBlank((CharSequence)supplierName)) {
                        supplierName = this.organizationInfoService.queryOrgName(supplierId);
                    }
                    paymentFlowInfo.setPayName(supplierName);
                    String operUnitName = this.organizationInfoService.queryOrgName(operUnitId);
                    paymentFlowInfo.setRecName(operUnitName);
                }
                if (!StringUtils.isBlank((CharSequence)reqBO.getMemUserType())) {
                    paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getMemUserType()));
                }
                if (null != payProOrderAbilityServiceRspBo.getTradeTime()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = simpleDateFormat.parse(payProOrderAbilityServiceRspBo.getTradeTime());
                    paymentFlowInfo.setPayTime(date);
                }
                paymentFlowInfo.setCreateTime(new Date());
                paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_PAY.getCode());
                paymentFlowInfo.setBusiCode(busiCode);
                paymentFlowInfo.setOfflineWebUrl(reqBO.getOfflineWebUrl());
                long flowId = this.paymentFlowInfoMapper.insert(paymentFlowInfo);
                FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
                fscPaymentFlowInfoDetail.setFlowId(paymentFlowInfo.getSeq());
                fscPaymentFlowInfoDetail.setOutOrderId(paymentFlowInfo.getOutOrderId());
                fscPaymentFlowInfoDetail.setFlowFlag(paymentFlowInfo.getFlowFlag());
                fscPaymentFlowInfoDetail.setCreateDate(new Date());
                this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
            }
            String jsonStr2 = JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            logger.error("\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\uff1a" + jsonStr2);
            rspBO = (CreatePayOrderRspBO)JSON.parseObject((String)jsonStr2, CreatePayOrderRspBO.class);
            logger.error("\u652f\u4ed8\u6e20\u9053\u8fd4\u56de\u7ed3\u679c\uff1a" + rspBO.toString());
            if (reqBO.getPayMethod().equals(PayMethod.ICBC_E.getCode())) {
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr2);
                JSONObject busiRspData = jsonObject.getJSONObject("busiRspData");
                String webUrl = busiRspData.getString("webUrl");
                rspBO.setUrl(webUrl);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            this.savelog("CreatePayOrderService-248", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\uff1a", (Throwable)e);
            this.savelog("CreatePayOrderService-252", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25:" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

