/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.pec.ability.pay.UocPebUpdatePayStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdatePayStatusReqBO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.payment.pay.web.bo.req.QueryMerchRelBusiAndPaymWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryInfoMechartParaAttrRspBo;
import com.tydic.payment.pay.web.bo.rsp.QueryMerchRelBusiAndPaymWebPaymentRspBo;
import com.tydic.pfscext.api.busi.BusiAddCreditLineService;
import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.AddCreditLineFscReqBo;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateReqBO;
import com.tydic.pfscext.api.pay.PayReturnInfoService;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoReqBO;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoRspBO;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.DApplyPayInfoExtMapMapper;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.DApplyPayInfoExtMapPO;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.FscCreditBusiType;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.pay.api.FscPayProAbleQueryOrderStatusAbilityService;
import com.tydic.pfscext.external.pay.api.FscPayQueryMerchRelBusiAndPaymWebService;
import com.tydic.pfscext.external.pay.bo.FscPayQueryMerchRelBusiAndPaymWebRspBo;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import com.tydic.pfscext.service.atom.FscExtInterLogAtomService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogAtomReqBO;
import com.tydic.pfscext.service.busi.FscCreditRecordBusiService;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.PayReturnInfoService"})
public class PayReturnInfoServiceImpl
implements PayReturnInfoService {
    private static final Logger log = LoggerFactory.getLogger(PayReturnInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(PayReturnInfoServiceImpl.class);
    @Autowired
    private FscPayProAbleQueryOrderStatusAbilityService fscPayProAbleQueryOrderStatusAbilityService;
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BusiPayResultModifyService busiPayResultModifyService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private DApplyPayInfoExtMapMapper applyPayInfoExtMapMapper;
    @Autowired
    private UocPebUpdatePayStatusAbilityService uocPebUpdatePayStatusAbilityService;
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Autowired
    private FscOrderPayStatusUpdateService fscOrderPayStatusUpdateService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscExtInterLogAtomService fscExtInterLogAtomService;
    @Autowired
    private FscCreditRecordBusiService fscCreditRecordBusiService;
    @Autowired
    private FscPayQueryMerchRelBusiAndPaymWebService fscPayQueryMerchRelBusiAndPaymWebService;
    private static final Integer TRADE_MODEL = 0;
    private static final String SUCCESS = "SUCCESS";

    @PostMapping(value={"payReturnInfo"})
    public PayReturnInfoRspBO payReturnInfo(@RequestBody PayReturnInfoReqBO reqBO) {
        logger.info("\u652f\u4ed8\u4e2d\u5fc3\u4e8c\u6b21\u56de\u8c03\u5165\u53c2:" + reqBO.toString());
        PayReturnInfoRspBO rspBO = new PayReturnInfoRspBO();
        if (null == reqBO.getBusiCode()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7cfb\u7edf\u7f16\u7801[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContent()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u52a0\u5bc6\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String content = reqBO.getContent();
            String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
            logger.info("\u652f\u4ed8\u4e2d\u5fc3\u4e8c\u6b21\u56de\u8c03\u5165\u53c2\uff1a" + retStr);
            this.savelog("PayReturnInfoService", reqBO.toString(), retStr);
            JSONObject jsonObject = JSONObject.fromObject((Object)retStr);
            if (null != jsonObject) {
                String outOrderId = jsonObject.getString("outOrderId");
                String resultCode = jsonObject.getString("resultCode");
                String resultMsg = jsonObject.getString("resultMsg");
                String payMethod = jsonObject.getString("payMethod");
                String paymentInsId = jsonObject.getString("paymentInsId");
                String createUserId = jsonObject.getString("createOperId");
                String payNotifyTransId = jsonObject.getString("payNotifyTransId");
                if (PayMethod.ZHCQT_SF.getCode().equals(payMethod)) {
                    this.updatePayMethod(payMethod, outOrderId, paymentInsId);
                    return rspBO;
                }
                if (PayMethod.OFFLINE_PAY.getCode().equals(payMethod)) {
                    return rspBO;
                }
                this.addApplyPayInfoExt(outOrderId, paymentInsId, payMethod);
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(outOrderId);
                paymentFlowInfo.setPaymentStatus(resultCode);
                paymentFlowInfo.setOrderRemark(resultMsg);
                paymentFlowInfo.setResultJson(retStr);
                paymentFlowInfo.setPayType(payMethod);
                paymentFlowInfo.setPayTime(new Date());
                paymentFlowInfo.setPayChannel(paymentInsId);
                if (StrUtil.isNotBlank((CharSequence)payNotifyTransId)) {
                    paymentFlowInfo.setPaymentFlowId(payNotifyTransId);
                }
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                if (SUCCESS.equals(resultCode)) {
                    if (outOrderId.startsWith("SERVICE")) {
                        PayOrderInfoPO po = new PayOrderInfoPO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)po);
                        po.setPayOrderId(Long.valueOf(outOrderId.substring(12)));
                        po.setPayOrderStatus(PayOrderStatus.PAY_TO_CONFIRM.getCode());
                        if (!StringUtils.isEmpty((CharSequence)createUserId)) {
                            po.setPayRegisterUserId(Long.parseLong(createUserId));
                            po.setPayRegisterUserName(this.userInfoService.queryUserNameByUserId(Long.parseLong(createUserId)));
                            po.setPayRegisterTime(new Date());
                        }
                        logger.error("PayOrderInfoServiceImpl\u5165\u53c2\uff1a" + po.toString());
                        this.payOrderInfoMapper.updateByPrimaryKeySelective(po);
                    }
                    if (outOrderId.startsWith("PAYMENT")) {
                        String payno = outOrderId.substring(8);
                        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                        applyPayInfoPO.setPayno(payno);
                        applyPayInfoPO.setPayMathod(payMethod);
                        applyPayInfoPO.setPayChannel(paymentInsId);
                        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                        BusiPayResultModifyReqBO busiPayResultModifyReqBO = new BusiPayResultModifyReqBO();
                        ArrayList<String> pauNOs = new ArrayList<String>();
                        ArrayList<String> status = new ArrayList<String>();
                        pauNOs.add(payno);
                        status.add("01");
                        busiPayResultModifyReqBO.setPayNos(pauNOs);
                        busiPayResultModifyReqBO.setStatuss(status);
                        ArrayList<String> payableNos = new ArrayList<String>();
                        List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payno);
                        int size = details.size();
                        if (size == 0) {
                            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
                        }
                        for (ApplyDetail ApplyDetail2 : details) {
                            PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(ApplyDetail2.getPayableNo());
                            this.addCreditLine(reqBO, ApplyDetail2, payableDetailPO);
                            payableNos.add(payableDetailPO.getPayableNo());
                            PayableDetailPO forUpdate = new PayableDetailPO();
                            forUpdate.setPayableNo(ApplyDetail2.getPayableNo());
                            if (payableDetailPO.getPayableAmt().compareTo(payableDetailPO.getPendingAmt()) == 0) {
                                forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
                            } else {
                                forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
                            }
                            this.payableDetailMapper.updateAmount(forUpdate);
                        }
                        this.modifyResult(busiPayResultModifyReqBO, reqBO, payableNos);
                    }
                }
            }
            rspBO.setResultCode(SUCCESS);
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25,\uff1a" + e);
            this.savelog("PayReturnInfoService", reqBO.toString(), reqBO.getContent());
            throw new PfscExtBusinessException("18000", "\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25:" + e);
        }
        return rspBO;
    }

    private void addApplyPayInfoExt(String outOrderId, String paymentInsId, String payMethod) {
        if (StrUtil.isBlank((CharSequence)outOrderId) || StrUtil.isBlank((CharSequence)paymentInsId)) {
            log.error("\u6839\u636e\u652f\u4ed8\u5355\u6269\u5c55\u8868\u6570\u636e\u65b0\u589e\u5f02\u5e38.outOrderId:{}.paymentInsId:{}", (Object)outOrderId, (Object)paymentInsId);
            return;
        }
        PaymentFlowInfo info = this.paymentFlowInfoMapper.selectByOutOrderId(outOrderId);
        String applyNo = null;
        if (outOrderId.startsWith("PAYMENT")) {
            applyNo = outOrderId.substring(8);
        } else if (outOrderId.startsWith("SERVICE")) {
            applyNo = outOrderId.substring(12);
        }
        if (info == null || info.getMerchantId() == null || StrUtil.isBlank((CharSequence)applyNo)) {
            log.error("\u6839\u636e\u652f\u4ed8\u5355\u6269\u5c55\u8868\u6570\u636e\u65b0\u589e\u5f02\u5e38.outOrderId:{}.paymentInsId:{}.paymentInfo:{}.", new Object[]{outOrderId, paymentInsId, JSON.toJSONString((Object)info)});
            return;
        }
        QueryMerchRelBusiAndPaymWebReqBo paymentReqBo = new QueryMerchRelBusiAndPaymWebReqBo();
        paymentReqBo.setMerchantId(info.getMerchantId() + "");
        paymentReqBo.setPaymentInsId(Long.valueOf(paymentInsId));
        FscPayQueryMerchRelBusiAndPaymWebRspBo payRspBo = this.fscPayQueryMerchRelBusiAndPaymWebService.queryMerchantInfo(paymentReqBo);
        if (CollectionUtils.isEmpty((Collection)payRspBo.getPaymentInsList())) {
            log.error("\u6839\u636e\u5546\u6237id\u548c\u652f\u4ed8\u6e20\u9053\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a.outOrderId:{}.merchantId:{}.paymentInsId:{}", new Object[]{outOrderId, info.getMerchantId(), paymentInsId});
            return;
        }
        Map mapPaymentInsId = payRspBo.getPaymentInsList().stream().collect(Collectors.toMap(QueryMerchRelBusiAndPaymWebPaymentRspBo::getPaymentInsId, Function.identity(), (c, n) -> c));
        QueryMerchRelBusiAndPaymWebPaymentRspBo paymentInfo = (QueryMerchRelBusiAndPaymWebPaymentRspBo)mapPaymentInsId.get(paymentInsId);
        if (paymentInfo == null) {
            log.error("\u6839\u636e\u5546\u6237id\u548c\u652f\u4ed8\u6e20\u9053\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u652f\u4ed8\u6e20\u9053\u4fe1\u606f\u4e3a\u7a7a.outOrderId:{}.merchantId:{}.paymentInsId:{}", new Object[]{outOrderId, info.getMerchantId(), paymentInsId});
            return;
        }
        ArrayList<DApplyPayInfoExtMapPO> payInfoExtMapInsertList = new ArrayList<DApplyPayInfoExtMapPO>();
        DApplyPayInfoExtMapPO outOrderIdPo = new DApplyPayInfoExtMapPO();
        outOrderIdPo.setId(Sequence.getInstance().nextId());
        outOrderIdPo.setObjId(applyNo);
        outOrderIdPo.setObjType(1);
        outOrderIdPo.setCreateTime(new Date());
        outOrderIdPo.setFieldCode("outOrderId");
        outOrderIdPo.setFieldName("\u652f\u4ed8\u5355\u53f7");
        outOrderIdPo.setFieldValue(outOrderId);
        payInfoExtMapInsertList.add(outOrderIdPo);
        DApplyPayInfoExtMapPO paymentInsIdPo = new DApplyPayInfoExtMapPO();
        paymentInsIdPo.setId(Sequence.getInstance().nextId());
        paymentInsIdPo.setObjId(applyNo);
        paymentInsIdPo.setObjType(1);
        paymentInsIdPo.setCreateTime(new Date());
        paymentInsIdPo.setFieldCode("paymentInsId");
        paymentInsIdPo.setFieldName(paymentInfo.getPaymentInsName());
        paymentInsIdPo.setFieldValue(paymentInsId);
        payInfoExtMapInsertList.add(paymentInsIdPo);
        if (!CollectionUtils.isEmpty((Collection)paymentInfo.getPayParaList())) {
            for (QueryInfoMechartParaAttrRspBo payParaInfo : paymentInfo.getPayParaList()) {
                DApplyPayInfoExtMapPO payParaInfoPo = new DApplyPayInfoExtMapPO();
                payParaInfoPo.setId(Sequence.getInstance().nextId());
                payParaInfoPo.setObjId(applyNo);
                payParaInfoPo.setObjType(1);
                payParaInfoPo.setCreateTime(new Date());
                payParaInfoPo.setFieldCode(payParaInfo.getAttrCode());
                payParaInfoPo.setFieldName(payParaInfo.getAttrName());
                payParaInfoPo.setFieldValue(payParaInfo.getAttrValue());
                payInfoExtMapInsertList.add(payParaInfoPo);
            }
        }
        if (!CollectionUtils.isEmpty(payInfoExtMapInsertList)) {
            this.applyPayInfoExtMapMapper.insertBatch(payInfoExtMapInsertList);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private BusiPayResultModifyRspBO modifyResult(BusiPayResultModifyReqBO busiPayResultModifyReqBO, PayReturnInfoReqBO payReturnInfoReqBO, List<String> payableNos) {
        logger.info("\u4ed8\u6b3e\u67e5\u8be2-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001BO=" + busiPayResultModifyReqBO);
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        List payNos = busiPayResultModifyReqBO.getPayNos();
        if (payNos == null || payNos.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List statuss = busiPayResultModifyReqBO.getStatuss();
        for (String status : statuss) {
            PayResultStatus newStatus = PayResultStatus.getInstance(status);
            if (newStatus == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (newStatus == PayResultStatus.APPLYING) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\uff1a" + PayResultStatus.PAY_CONFIRMED.getDescr() + "\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u624d\u80fd\uff0c\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\uff1a" + newStatus.getDescr());
        }
        for (String payNo : payNos) {
            ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPay == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
            }
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
            applyPay.setPayStatus(PayResultStatus.SUCCESS.getCode());
            applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
            this.applyPayInfoMapper.updateStatus(applyPay);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payNo);
            applyDetail.setStatus(PayResultStatus.SUCCESS.getCode());
            this.applyDetailMapper.updateByApplyNo(applyDetail);
            ArrayList<String> nopId = new ArrayList<String>();
            for (ApplyDetail applyDetail1 : details) {
                String payableNo = applyDetail1.getPayableNo();
                PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(payableNo);
                ArrayList orderIds = new ArrayList();
                if (null != payableDetailPO) {
                    PebExtPayResultRspBO pebExtPayResultRspBO;
                    PebExtPayResultReqBO extPayResultReqBO;
                    UocPebUpdatePayStatusReqBO uocPebUpdatePayStatusReqBO;
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfoList;
                    if (!(!StrUtil.isNotBlank((CharSequence)payableDetailPO.getNotificationNo()) || CollectionUtils.isEmpty(payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPO.getNotificationNo())) || TRADE_MODEL.equals(payableDetailPO.getBusiModel()) && payableDetailPO.getPayableType().equals(1))) {
                        uocPebUpdatePayStatusReqBO = new UocPebUpdatePayStatusReqBO();
                        uocPebUpdatePayStatusReqBO.setPayMod(applyPay.getPayMathod());
                        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                            payPurchaseOrderInfo.setPayModel("01");
                            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo);
                            if (!nopId.contains(payPurchaseOrderInfo.getNotificationNo())) {
                                nopId.add(payPurchaseOrderInfo.getNotificationNo());
                            }
                            if (!"1".equals(payPurchaseOrderInfo.getBusiModel())) continue;
                            extPayResultReqBO = new PebExtPayResultReqBO();
                            extPayResultReqBO.setInspectionVoucherId(payPurchaseOrderInfo.getInspectionId());
                            extPayResultReqBO.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                            extPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                            extPayResultReqBO.setPaymentFinishTime(new Date());
                            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                            pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
                            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                            if (null != pebExtPayResultRspBO && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                            logger.error("\u8ba2\u5355ID\u4e3a" + payPurchaseOrderInfo.getOrderId() + "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25,,\u9519\u8bef\u4fe1\u606f:" + pebExtPayResultRspBO.getResultMsg());
                        }
                    }
                    if (StrUtil.isNotBlank((CharSequence)payableDetailPO.getApplyNo())) {
                        List<SaleOrderInfo> list = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(payableDetailPO.getApplyNo());
                        if (null != list && !list.isEmpty()) {
                            uocPebUpdatePayStatusReqBO = new UocPebUpdatePayStatusReqBO();
                            uocPebUpdatePayStatusReqBO.setPayMod(applyPay.getPayMathod());
                            for (SaleOrderInfo saleOrderInfo : list) {
                                extPayResultReqBO = new PebExtPayResultReqBO();
                                extPayResultReqBO.setInspectionVoucherId(saleOrderInfo.getInspectionId());
                                extPayResultReqBO.setOrderId(saleOrderInfo.getOrderId().toString());
                                extPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                                extPayResultReqBO.setPaymentFinishTime(new Date());
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                                pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                                if (null != pebExtPayResultRspBO && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                                logger.error("\u8ba2\u5355ID\u4e3a" + saleOrderInfo.getOrderId() + "\u8c03\u7528\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff0c,\u9519\u8bef\u4fe1\u606f:" + pebExtPayResultRspBO.getResultMsg());
                            }
                        }
                        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                        saleOrderInfo.setApplyNo(payableDetailPO.getApplyNo());
                        saleOrderInfo.setPayStatus(PayableStatus.SUCCESS.getCode());
                        this.saleOrderInfoMapper.updateByApplyNo(saleOrderInfo);
                    }
                    if (null != payableDetailPO && StringUtils.isBlank((CharSequence)payableDetailPO.getApplyNo()) && StringUtils.isBlank((CharSequence)payableDetailPO.getNotificationNo())) {
                        String content = payReturnInfoReqBO.getContent();
                        String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
                        PebExtPayResultReqBO extPayResultReqBO2 = (PebExtPayResultReqBO)JSON.parseObject((String)retStr, PebExtPayResultReqBO.class);
                        extPayResultReqBO2.setContent(content);
                        extPayResultReqBO2.setBusiCode(payReturnInfoReqBO.getBusiCode());
                        ArrayList<String> payablesNos = new ArrayList<String>();
                        payablesNos.add(payableNo);
                        extPayResultReqBO2.setPayableNos(payablesNos);
                        ArrayList<Long> orders = new ArrayList<Long>();
                        orders.add(payableDetailPO.getOrderId());
                        payableDetailPO.setOrderIdList(orders);
                        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
                        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
                        this.updateSaleOrderInfoPayStatus(payableDetailPO, null, null);
                        logger.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfo1);
                        extPayResultReqBO2.setTotalFee(payableDetailPOS.get(0).getPayableAmt().subtract(paymentFlowInfo1 == null ? BigDecimal.ZERO : paymentFlowInfo1.getOrderAmt()).toString());
                        extPayResultReqBO2.setOrderId(null != payableDetailPO.getOrderId() ? payableDetailPO.getOrderId().toString() : null);
                        extPayResultReqBO2.setInspectionVoucherId(payableDetailPO.getInspectionId());
                        extPayResultReqBO2.setPaymentFinishTime(new Date());
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO2);
                        PebExtPayResultRspBO pebExtPayResultRspBO2 = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO2);
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO2);
                        if (pebExtPayResultRspBO2 == null || !SUCCESS.equals(pebExtPayResultRspBO2.getResultCode())) {
                            logger.error("\u5e94\u4ed8\u5355[" + payableNo + "], \u8ba2\u5355[" + extPayResultReqBO2.getOrderId() + "]\u56de\u8c03\u8ba2\u5355\u9519\u8bef\uff0c,\u9519\u8bef\u4fe1\u606f:" + pebExtPayResultRspBO2.getResultMsg());
                        }
                    }
                }
                ArrayList<String> payAbleNos = new ArrayList<String>();
                payAbleNos.add(payableNo);
                String status = PayableStatus.PAYING.getCode();
                BigDecimal ingAmt = payableDetailPO.getPendingAmt();
                if (payableDetailPO.getPaidAmt() != null) {
                    ingAmt = payableDetailPO.getPaidAmt().add(payableDetailPO.getPendingAmt());
                }
                if (ingAmt.compareTo(payableDetailPO.getPayableAmt()) >= 0) {
                    status = PayableStatus.SUCCESS.getCode();
                }
                this.payableDetailMapper.updateAmtByNOs(payAbleNos, status);
            }
            if (nopId.isEmpty()) continue;
            this.billNotificationInfoMapper.updatePayStatus(nopId, 2);
        }
        return resp;
    }

    private void updateSaleOrderInfoPayStatus(PayableDetailPO payableDetailPO, Long orderId, Long parentOrderId) {
        if (payableDetailPO != null) {
            SaleOrderInfoVO orderInfo = new SaleOrderInfoVO();
            orderInfo.setOrderId(payableDetailPO.getOrderId());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(orderInfo);
            if (!CollectionUtils.isEmpty(saleOrderInfos)) {
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    FscOrderPayStatusUpdateReqBO fscOrderPayStatusUpdateReqBO = new FscOrderPayStatusUpdateReqBO();
                    fscOrderPayStatusUpdateReqBO.setOrderId(saleOrderInfo.getOrderId());
                    fscOrderPayStatusUpdateReqBO.setParentOrderId(saleOrderInfo.getParentOrderId());
                    this.fscOrderPayStatusUpdateService.updateOrderPayStatus(fscOrderPayStatusUpdateReqBO);
                }
            }
        } else if (orderId != null) {
            FscOrderPayStatusUpdateReqBO payStatusUpdateReqBO = new FscOrderPayStatusUpdateReqBO();
            payStatusUpdateReqBO.setOrderId(orderId);
            if (parentOrderId != null) {
                payStatusUpdateReqBO.setParentOrderId(parentOrderId);
            }
            this.fscOrderPayStatusUpdateService.updateOrderPayStatus(payStatusUpdateReqBO);
        }
    }

    private void addCreditLine(PayReturnInfoReqBO reqBO, ApplyDetail applyDetail, PayableDetailPO payableDetailPo) {
        PfscExtReqBaseBO reqBaseBo = FscRu.js(reqBO, PfscExtReqBaseBO.class);
        String payno = applyDetail.getApplyNo();
        if (payableDetailPo.getPayableType() != null) {
            if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString())) {
                if (payableDetailPo.getBusiModel() != null && BusiModel.MATCH_UP_MODEL.getCode().equals(payableDetailPo.getBusiModel().toString())) {
                    String notificationNo = payableDetailPo.getNotificationNo();
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                        FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                        BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                        creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                        creditRecordBusiReqBo.setPayApplyCode(payno);
                        creditRecordBusiReqBo.setOrderId(payPurchaseOrderInfo.getOrderId());
                        creditRecordBusiReqBo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                        if (org.springframework.util.StringUtils.hasText((String)payPurchaseOrderInfo.getBusiModel())) {
                            creditRecordBusiReqBo.setBusiModel(Integer.valueOf(payPurchaseOrderInfo.getBusiModel()));
                        }
                        if (payPurchaseOrderInfo.getActivityId() != null) {
                            creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                        } else {
                            creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                        }
                        creditRecordBusiReqBo.setRemark("\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                        creditRecordBusiReqBo.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                        creditRecordBusiReqBo.setBusiAmount(payPurchaseOrderInfo.getOrderAmt());
                        creditRecordBusiReqBo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
                        creditRecordBusiReqBo.setSupplierName(payPurchaseOrderInfo.getSupplierName());
                        FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                        fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                        fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                        fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                        int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                        if (checkBy < 1) {
                            this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u9000\u6388\u4fe1" + payableDetailPo.getPayableNo());
                            continue;
                        }
                        FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                        if (!FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) continue;
                        log.error("\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u901a\u77e5\u5e94\u4ed8,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u901a\u77e5\u5e94\u4ed8" + payableDetailPo.getPayableNo());
                        throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                    }
                }
            } else if (PayableType.APPLY.getCode().equals(payableDetailPo.getPayableType().toString())) {
                String applyNo = payableDetailPo.getApplyNo();
                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                    BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                    creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                    creditRecordBusiReqBo.setPayApplyCode(payno);
                    creditRecordBusiReqBo.setOrderId(saleOrderInfo.getOrderId());
                    creditRecordBusiReqBo.setOrderCode(saleOrderInfo.getSaleOrderCode());
                    if (org.springframework.util.StringUtils.hasText((String)saleOrderInfo.getBusiModel())) {
                        creditRecordBusiReqBo.setBusiModel(Integer.valueOf(saleOrderInfo.getBusiModel()));
                    }
                    creditRecordBusiReqBo.setBusiAmount(saleOrderInfo.getOrderAmt());
                    creditRecordBusiReqBo.setSupplierNo(saleOrderInfo.getSupplierNo());
                    creditRecordBusiReqBo.setSupplierName(saleOrderInfo.getSupplierName());
                    if (saleOrderInfo.getActivityId() != null) {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                    } else {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                    }
                    creditRecordBusiReqBo.setRemark("\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                    creditRecordBusiReqBo.setInspectionId(saleOrderInfo.getInspectionId());
                    FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                    fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                    fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                    fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                    int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                    if (checkBy < 1) {
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u9000\u6388\u4fe1" + payableDetailPo.getPayableNo());
                        continue;
                    }
                    FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                    if (!FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) continue;
                    log.error("\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                    this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8" + payableDetailPo.getPayableNo());
                    throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                }
            } else if (Arrays.asList(PayableType.AOG.getCode(), PayableType.INSPECTION.getCode(), PayableType.EXPIRE.getCode(), PayableType.YFYF.getCode(), PayableType.QUALITY_GUARANTEE_DEPOSIT.getCode()).contains(payableDetailPo.getPayableType().toString())) {
                List<SaleOrderInfo> saleOrders;
                FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                BigDecimal changeInfo = applyDetail.getAmt();
                if (!(payableDetailPo.getOverduePenalty() == null || payableDetailPo.getApproveResult() != null && YesOrNo.YES.getCode().equals(payableDetailPo.getApproveResult()))) {
                    changeInfo = changeInfo.subtract(payableDetailPo.getOverduePenalty());
                }
                creditRecordBusiReqBo.setBusiAmount(changeInfo);
                creditRecordBusiReqBo.setPayApplyCode(String.valueOf(payno));
                creditRecordBusiReqBo.setSupplierNo(payableDetailPo.getSupplierId());
                creditRecordBusiReqBo.setSupplierName(payableDetailPo.getSupplierName());
                creditRecordBusiReqBo.setBusiModel(payableDetailPo.getBusiModel());
                creditRecordBusiReqBo.setOrderId(payableDetailPo.getOrderId());
                creditRecordBusiReqBo.setOrderCode(payableDetailPo.getPurchaseOrderCode());
                if (payableDetailPo.getOrderId() != null && !CollectionUtils.isEmpty(saleOrders = this.saleOrderInfoMapper.getListSaleOrderInfoByOrderIds(Collections.singletonList(payableDetailPo.getOrderId())))) {
                    if (saleOrders.get(0).getActivityId() != null) {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                    } else {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                    }
                }
                creditRecordBusiReqBo.setRemark("\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                creditRecordBusiReqBo.setInspectionId(payableDetailPo.getInspectionId());
                FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                if (checkBy < 1) {
                    this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6838\u9500\u5931\u8d25\u4e0d\u6263\u6388\u4fe1" + payableDetailPo.getPayableNo());
                } else {
                    FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                    if (FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) {
                        log.error("\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u5230\u8d27\u5e94\u4ed8-\u9a8c\u6536\u5e94\u4ed8-\u8d26\u671f\u5e94\u4ed8-\u6838\u9178\u5931\u8d25,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u5728\u7ebf\u652f\u4ed8\u56de\u9000\u6388\u4fe1\u989d\u5ea6\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u5230\u8d27\u5e94\u4ed8-\u9a8c\u6536\u5e94\u4ed8-\u8d26\u671f\u5e94\u4ed8-\u6838\u9500\u5931\u8d25" + payableDetailPo.getPayableNo());
                        throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                    }
                }
            }
        }
    }

    private void saveLog(Long orderId, Long objId, String objCode, String createLoginId, String reqJson, String rspJson, String errDetail) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            FscExtInterLogAtomReqBO logAtomReqBo = new FscExtInterLogAtomReqBO();
            logAtomReqBo.setObjId(objId);
            logAtomReqBo.setObjCode(objCode);
            logAtomReqBo.setObjType(FscConstants.FscExtInterLogObjType.PAY_CREDIT);
            logAtomReqBo.setOrderId(orderId);
            logAtomReqBo.setInterSn("1");
            logAtomReqBo.setInterCode("dealOrderCreditRecord");
            logAtomReqBo.setFlowFlag(1);
            logAtomReqBo.setInContent(reqJson);
            logAtomReqBo.setOutContent(rspJson);
            logAtomReqBo.setCallCount(0);
            logAtomReqBo.setCallTime(new Date());
            logAtomReqBo.setRetTime(new Date());
            logAtomReqBo.setCallState("18000");
            logAtomReqBo.setErrCode("18000");
            logAtomReqBo.setErrDetail(errDetail);
            logAtomReqBo.setCreateTime(new Date());
            logAtomReqBo.setCreateLoginId(createLoginId);
            this.fscExtInterLogAtomService.dealFscExtInterLogAdd(logAtomReqBo);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Object)e.toString());
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void addCreditLine(PayableDetailPO payableDetailPO1, ApplyDetail applyDetail) {
        AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
        creditLineFscReqBo.setChangeType("3");
        BigDecimal changeInfo = applyDetail.getAmt();
        if (payableDetailPO1.getOverduePenalty() != null && !"1".equals(payableDetailPO1.getApproveResult())) {
            changeInfo = changeInfo.subtract(payableDetailPO1.getOverduePenalty());
        }
        creditLineFscReqBo.setChangeInfo(changeInfo);
        creditLineFscReqBo.setPayApplyCode(String.valueOf(applyDetail.getApplyNo()));
        if (payableDetailPO1.getPayableType() == 1 && "1".equals(payableDetailPO1.getBusiModel())) {
            String notificationNo = payableDetailPO1.getNotificationNo();
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                creditLineFscReqBo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)payPurchaseOrderInfo.getBusiModel())) {
                    creditLineFscReqBo.setBusiModel(Integer.valueOf(payPurchaseOrderInfo.getBusiModel()));
                }
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO1.getPayableType() == 6) {
            String applyNo = payableDetailPO1.getApplyNo();
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                creditLineFscReqBo.setSupplierNo(saleOrderInfo.getSupplierNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)saleOrderInfo.getBusiModel())) {
                    creditLineFscReqBo.setBusiModel(Integer.valueOf(saleOrderInfo.getBusiModel()));
                }
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO1.getPayableType() == 2 || payableDetailPO1.getPayableType() == 3 || payableDetailPO1.getPayableType() == 5) {
            creditLineFscReqBo.setOrderCode(payableDetailPO1.getPurchaseOrderCode());
            creditLineFscReqBo.setSupplierNo(payableDetailPO1.getSupplierId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)payableDetailPO1.getBusiModel())) {
                creditLineFscReqBo.setBusiModel(Integer.valueOf(payableDetailPO1.getBusiModel()));
            }
            this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
        }
        logger.error("##############################\uff1a" + creditLineFscReqBo.toString());
    }

    private void updatePayMethod(String PayMethod2, String outOrderId, String paymentInsId) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        String[] split = outOrderId.split("-");
        applyPayInfoPO.setPayno(split[1]);
        applyPayInfoPO.setPayMathod(PayMethod2);
        applyPayInfoPO.setPayChannel(paymentInsId);
        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setOutOrderId(outOrderId);
        paymentFlowInfo.setPayType(PayMethod2);
        paymentFlowInfo.setPayChannel(paymentInsId);
        this.paymentFlowInfoMapper.updateByExtJson(paymentFlowInfo);
    }
}

