/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityRspBo;
import com.tydic.pfscext.api.pay.QryPayResultService;
import com.tydic.pfscext.api.pay.bo.QryPayResultReqBO;
import com.tydic.pfscext.api.pay.bo.QryPayResultRspBO;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.pay.api.FscPayProAbleQueryOrderStatusAbilityService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.QryPayResultService"})
public class QryPayResultServiceImpl
implements QryPayResultService {
    private static final Logger logger = LoggerFactory.getLogger(QryPayResultServiceImpl.class);
    @Resource
    private FscPayProAbleQueryOrderStatusAbilityService fscPayProAbleQueryOrderStatusAbilityService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;

    @PostMapping(value={"qryPayResult"})
    public QryPayResultRspBO qryPayResult(@RequestBody QryPayResultReqBO reqBO) {
        QryPayResultRspBO rspBO = new QryPayResultRspBO();
        if (null == reqBO.getOriOrderId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[oriOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            PaymentFlowInfo paymentFlowInfoPO = this.paymentFlowInfoMapper.selectByOutOrderId(reqBO.getOriOrderId());
            if (null == paymentFlowInfoPO) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            PayProAbleQueryOrderStatusAbilityReqBo payProRelPayMethodQueryReqBo = new PayProAbleQueryOrderStatusAbilityReqBo();
            payProRelPayMethodQueryReqBo.setBusiCode(paymentFlowInfoPO.getBusiCode());
            payProRelPayMethodQueryReqBo.setOriOrderId(reqBO.getOriOrderId());
            logger.error("\u8bf7\u6c42\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProRelPayMethodQueryReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            PayProAbleQueryOrderStatusAbilityRspBo payProRelPayMethodQueryRspBo = this.fscPayProAbleQueryOrderStatusAbilityService.queryStatus(payProRelPayMethodQueryReqBo);
            if (null == payProRelPayMethodQueryRspBo.getRespCode() || !payProRelPayMethodQueryRspBo.getRespCode().equals("0000")) {
                logger.error("\u67e5\u8be2\u5546\u6237[" + paymentFlowInfoPO.getMerchantId() + "]\u652f\u4ed8\u7ed3\u679c\u4fe1\u606f\u5931\u8d25,\uff1a" + payProRelPayMethodQueryRspBo.getRespDesc());
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5546\u6237[" + paymentFlowInfoPO.getMerchantId() + "]\u652f\u4ed8\u7ed3\u679c\u4fe1\u606f\u5931\u8d25:");
            }
            logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)payProRelPayMethodQueryRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            paymentFlowInfo.setOutOrderId(reqBO.getOriOrderId());
            paymentFlowInfo.setPaymentStatus(payProRelPayMethodQueryRspBo.getPayStatus());
            paymentFlowInfo.setPaymentFlowId(payProRelPayMethodQueryRspBo.getPayNotifyTransId());
            paymentFlowInfo.setOrderRemark(payProRelPayMethodQueryRspBo.getPayStatusMsg());
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u4fe1\u606f\u5931\u8d25,\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u4fe1\u606f\u5931\u8d25:" + e);
        }
    }
}

