/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.pfscext.api.pay.ReturnPayOrderService;
import com.tydic.pfscext.api.pay.bo.ReturnPayOrderReqBO;
import com.tydic.pfscext.api.pay.bo.ReturnPayOrderRspBO;
import com.tydic.pfscext.dao.FscPaymentFlowInfoDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.FscPaymentFlowInfoDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.ReturnPayOrderService"})
public class ReturnPayOrderServiceImpl
implements ReturnPayOrderService {
    private static final Logger logger = LoggerFactory.getLogger(ReturnPayOrderServiceImpl.class);
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Value(value="${service_url}")
    private String service_url;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private FscPaymentFlowInfoDetailMapper fscPaymentFlowInfoDetailMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    @PostMapping(value={"returnPayOrder"})
    public ReturnPayOrderRspBO returnPayOrder(@RequestBody ReturnPayOrderReqBO reqBO) {
        ReturnPayOrderRspBO rspBO = new ReturnPayOrderRspBO();
        if (null == reqBO.getOriOrderId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[oriOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = reqBO.getOriOrderId();
        try {
            PaymentFlowInfo paymentFlowInfo = this.paymentFlowInfoMapper.selectByOutOrderId(orderNo);
            if (null == paymentFlowInfo) {
                logger.error("\u652f\u4ed8\u8ba2\u5355" + orderNo + "\u4e0d\u5b58\u5728");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u652f\u4ed8\u8ba2\u5355" + orderNo + "\u4e0d\u5b58\u5728");
                return rspBO;
            }
            PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
            payProRefundAbilityReqBo.setBusiCode(paymentFlowInfo.getBusiCode());
            payProRefundAbilityReqBo.setRefundFee(reqBO.getRefundFee());
            StringBuffer stringBuffer = new StringBuffer("RETURN-");
            stringBuffer.append(orderNo);
            payProRefundAbilityReqBo.setRefundOutOrderId(stringBuffer.toString());
            payProRefundAbilityReqBo.setOriOutOrderId(orderNo);
            payProRefundAbilityReqBo.setRefundReason(reqBO.getRefundReason());
            payProRefundAbilityReqBo.setNotifyUrl(this.service_url);
            JSONObject busiReqJson = new JSONObject();
            busiReqJson.put("payMemno", (Object)reqBO.getUserId());
            if (reqBO.getPayMethod().equals(PayMethod.ICBC_E.getCode())) {
                Random random = new Random();
                int rannum = (int)(random.nextDouble() * 90000.0) + 10000;
                JSONArray goodsInfos = new JSONArray();
                JSONObject goodsInfo = new JSONObject();
                goodsInfo.put("goodsSubId", (Object)rannum);
                goodsInfo.put("goodsName", (Object)"\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e");
                goodsInfo.put("goodsNumber", (Object)"1");
                goodsInfo.put("goodsUnit", (Object)"\u7b14");
                goodsInfo.put("goodsAmt", (Object)reqBO.getRefundFee());
                goodsInfos.add((Object)goodsInfo);
                busiReqJson.put("goodsInfos", (Object)goodsInfos);
                String busiReqData = busiReqJson.toJSONString();
                logger.error("busiReqDataStr\uff1a" + busiReqData);
                payProRefundAbilityReqBo.setBusiReqData(busiReqData);
            }
            logger.error("\u8bf7\u6c42\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
            if (null == payProRefundAbilityRspBo.getRespCode() || !payProRefundAbilityRspBo.getRespCode().equals("0000")) {
                logger.error("\u9000\u6b3e\u8ba2\u5355[" + stringBuffer.toString() + "]\u5931\u8d25,\uff1a" + payProRefundAbilityRspBo.getRespDesc());
                this.savelog("CreatePayOrderService-129", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                throw new PfscExtBusinessException("18000", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5931\u8d25" + payProRefundAbilityRspBo.getRespDesc());
            }
            logger.error("\u54cd\u5e94\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            PaymentFlowInfo paymentFlowInfo2 = new PaymentFlowInfo();
            BeanUtils.copyProperties((Object)paymentFlowInfo, (Object)paymentFlowInfo2);
            paymentFlowInfo2.setPayName(paymentFlowInfo.getRecName());
            paymentFlowInfo2.setRecName(paymentFlowInfo.getPayName());
            paymentFlowInfo2.setPayOrgNo(paymentFlowInfo.getRecOrgNo());
            paymentFlowInfo2.setRecOrgNo(paymentFlowInfo.getPayOrgNo());
            paymentFlowInfo2.setOutOrderId(stringBuffer.toString());
            paymentFlowInfo2.setReturnOutOrderId(orderNo);
            paymentFlowInfo2.setPaymentFlowId(payProRefundAbilityRspBo.getRefundTransId());
            paymentFlowInfo2.setMerchantId(paymentFlowInfo.getMerchantId());
            paymentFlowInfo2.setOrgId(reqBO.getOrgId());
            paymentFlowInfo2.setOrderAmt(new BigDecimal(reqBO.getRefundFee()));
            paymentFlowInfo2.setOrderDesc("");
            paymentFlowInfo2.setPayChannel(reqBO.getPayChannel());
            paymentFlowInfo2.setPayType(reqBO.getPayMethod());
            paymentFlowInfo2.setAsynUrl(this.service_url);
            paymentFlowInfo2.setClientIp(reqBO.getIpAddress());
            paymentFlowInfo2.setCreateUserId(reqBO.getUserId());
            paymentFlowInfo2.setCreateUserName(reqBO.getName());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (null != payProRefundAbilityRspBo.getTradeTime()) {
                Date date = simpleDateFormat.parse(payProRefundAbilityRspBo.getTradeTime());
                paymentFlowInfo2.setPayTime(date);
            }
            paymentFlowInfo2.setCreateTime(new Date());
            paymentFlowInfo2.setFlowFlag("01");
            long flowId = this.paymentFlowInfoMapper.insertSelective(paymentFlowInfo2);
            FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
            fscPaymentFlowInfoDetail.setFlowId(paymentFlowInfo2.getSeq());
            fscPaymentFlowInfoDetail.setOutOrderId(paymentFlowInfo2.getOutOrderId());
            fscPaymentFlowInfoDetail.setFlowFlag(paymentFlowInfo2.getFlowFlag());
            fscPaymentFlowInfoDetail.setCreateDate(new Date());
            this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
            String jsonStr2 = JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            logger.error("\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\uff1a" + jsonStr2);
            rspBO = (ReturnPayOrderRspBO)JSON.parseObject((String)jsonStr2, ReturnPayOrderRspBO.class);
            logger.error("\u652f\u4ed8\u6e20\u9053\u8fd4\u56de\u7ed3\u679c\uff1a" + rspBO.toString());
            if (reqBO.getPayMethod().equals(PayMethod.ICBC_E.getCode())) {
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr2);
                JSONObject busiRspData = jsonObject.getJSONObject("busiRspData");
                String string = busiRspData.getString("webUrl");
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            this.savelog("CreatePayOrderService-170", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\uff1a" + e);
            this.savelog("CreatePayOrderService-174", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

