/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.tydic.pfscext.api.trade.AutoReleaseBillService;
import com.tydic.pfscext.api.trade.bo.AutoReleaseBillReqBO;
import com.tydic.pfscext.api.trade.bo.AutoReleaseBillRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.AutoReleaseBillService"})
public class AutoReleaseBillServiceImpl
implements AutoReleaseBillService {
    private static final Logger log = LoggerFactory.getLogger(AutoReleaseBillServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"releaseExceptionBill"})
    public AutoReleaseBillRspBO releaseExceptionBill(@RequestBody AutoReleaseBillReqBO reqBO) {
        List<SaleOrderInfo> saleOrderInfoList;
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatTime = sdf.format(calendar.getTime());
        List<PayPurchaseOrderInfo> purchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getSendingTimeOutList(formatTime);
        if (!CollectionUtils.isEmpty(purchaseOrderInfoList)) {
            List<Long> inspectionIdList = purchaseOrderInfoList.stream().map(PayPurchaseOrderInfo::getInspectionId).collect(Collectors.toList());
            PayPurchaseOrderInfoVO orderInfoVO = new PayPurchaseOrderInfoVO();
            orderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            orderInfoVO.setInspectionIds(inspectionIdList);
            this.payPurchaseOrderInfoMapper.updateStatusBatchByOrderIds(orderInfoVO);
            log.debug("\u91ca\u653e\u4e86" + purchaseOrderInfoList.size() + "\u6761\u53d1\u8d77\u4e2d\u5f00\u7968\u901a\u77e5\u5355\u7533\u8bf7\u6570\u636e\u3002");
        }
        if (!CollectionUtils.isEmpty(saleOrderInfoList = this.saleOrderInfoMapper.getSendingTimeOutList(formatTime))) {
            List<Long> inspectionIdList = saleOrderInfoList.stream().map(SaleOrderInfo::getInspectionId).collect(Collectors.toList());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            saleOrderInfoVO.setInspectionIdList(inspectionIdList);
            this.saleOrderInfoMapper.updateStatusByInspectionIds(saleOrderInfoVO);
        }
        AutoReleaseBillRspBO rspBO = new AutoReleaseBillRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

