/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.pfscext.api.trade.ExpetionBillNoTficationService;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.CreateEntryInfoService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.busi.FscPayableDetailUpdateBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiRspBO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.ExpetionBillNoTficationService"})
public class ExpetionBillNoTficationServiceImpl
implements ExpetionBillNoTficationService {
    private static final Logger log = LoggerFactory.getLogger(ExpetionBillNoTficationServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ExpetionBillNoTficationServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayableService payableService;
    @Autowired
    private CreateEntryInfoService createEntryInfoService;
    @Autowired
    private FscPayableDetailUpdateBusiService fscPayableDetailUpdateBusiService;

    @PostMapping(value={"addExpetionBill"})
    public BusiNotificationRspBO addExpetionBill(@RequestBody BusiNotificationReqBO reqBO) {
        BusiNotificationRspBO busiNotificationRspBO = new BusiNotificationRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u7ed3\u7b97\u5f02\u5e38\u901a\u77e5\u5355\uff1a" + reqBO.toString());
        }
        if (reqBO == null) {
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return busiNotificationRspBO;
        }
        if (reqBO.getOrderCodes().size() == 0) {
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u6ca1\u6709\u9009\u62e9\u8ba2\u5355");
            return busiNotificationRspBO;
        }
        if (reqBO.getSource() == null) {
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u6765\u6e90\u4e0d\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
            return busiNotificationRspBO;
        }
        try {
            PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            payPurchaseOrderInfoVO.setOrderCodes(reqBO.getOrderCodes());
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExtException(payPurchaseOrderInfoVO);
            if (payPurchaseOrderInfoPOs != null && payPurchaseOrderInfoPOs.size() > 0) {
                List<PayableDetailPO> payLs;
                BigDecimal amt = new BigDecimal("0");
                int count = 0;
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoPOs) {
                    amt = amt.add(payPurchaseOrderInfo.getOrderAmt());
                    if (!"01".equals(payPurchaseOrderInfo.getPayType())) continue;
                    ++count;
                }
                if (count != 0 && count != payPurchaseOrderInfoPOs.size()) {
                    busiNotificationRspBO.setRespCode("18000");
                    busiNotificationRspBO.setRespDesc("\u8d26\u671f\u652f\u4ed8\u7684\u8ba2\u5355\u4e0d\u80fd\u548c\u5176\u4ed6\u4ed8\u6b3e\u65b9\u5f0f\u7684\u8ba2\u5355\u4e00\u8d77\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    return busiNotificationRspBO;
                }
                String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
                BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
                notifyInfo.setNotificationNo(notifyNo);
                notifyInfo.setAmt(amt);
                notifyInfo.setApplyDate(new Date());
                notifyInfo.setOperNo(payPurchaseOrderInfoPOs.get(0).getPurchaseNo());
                notifyInfo.setSource(String.valueOf(reqBO.getSource()));
                notifyInfo.setSupplierNo(payPurchaseOrderInfoPOs.get(0).getSupplierNo());
                notifyInfo.setSupplierName(payPurchaseOrderInfoPOs.get(0).getSupplierName());
                notifyInfo.setUserId(reqBO.getUserId());
                notifyInfo.setPurchaseSaleType(payPurchaseOrderInfoPOs.get(0).getPurchaseSaleType());
                notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
                notifyInfo.setIsPay(1);
                notifyInfo.setDrawerId(reqBO.getUserId());
                notifyInfo.setDrawerName(reqBO.getName());
                notifyInfo.setBillNotificationType(1);
                if (payPurchaseOrderInfoPOs.get(0).getPurchaseNo() != null) {
                    notifyInfo.setPurchaseNo(payPurchaseOrderInfoPOs.get(0).getPurchaseNo().toString());
                }
                notifyInfo.setPurchaseName(payPurchaseOrderInfoPOs.get(0).getPurchaseName());
                notifyInfo.setInvoiceStatus("03");
                if (payPurchaseOrderInfoPOs.get(0).getPurchaseNo() != null) {
                    notifyInfo.setPurchaseNo(payPurchaseOrderInfoPOs.get(0).getPurchaseNo().toString());
                }
                notifyInfo.setPurchaseName(payPurchaseOrderInfoPOs.get(0).getPurchaseName());
                int insert = this.billNotificationInfoMapper.insert(notifyInfo);
                if (insert > 0) {
                    PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
                    payOrderInfo.setNotificationNo(notifyNo);
                    payOrderInfo.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
                    payOrderInfo.setOrderCodes(reqBO.getOrderCodes());
                    this.payPurchaseOrderInfoMapper.updateBySaleCodes(payOrderInfo);
                    PayItemInfo item = new PayItemInfo();
                    item.setNotificationNo(notifyNo);
                    item.setOrderCodes(reqBO.getOrderCodes());
                    item.setItemStatus(OrderStatus.RECEIVE_BILL.getCode());
                    this.payItemInfoMapper.updateByOrderCodes(item);
                }
                String busiModel = "1";
                String payType = "";
                Long purchaseNo = 0L;
                logger.debug("\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355,\u901a\u77e5\u5355\u53f7=" + notifyNo);
                List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOs = this.payPurchaseOrderInfoMapper.getListByNo(notifyNo);
                if (payPurchaseOrderInfoDetailBOs != null && payPurchaseOrderInfoDetailBOs.size() > 0) {
                    busiModel = payPurchaseOrderInfoDetailBOs.get(0).getBusiModel();
                    payType = payPurchaseOrderInfoDetailBOs.get(0).getPayType();
                    purchaseNo = payPurchaseOrderInfoDetailBOs.get(0).getPurchaseNo();
                }
                BigDecimal writeOffAmt = BigDecimal.ZERO;
                Long companyId = reqBO.getCompanyId();
                if (busiModel.equals("1")) {
                    companyId = purchaseNo;
                }
                log.error("notifyNo:{}.busiModel:{}.payType:{}", new Object[]{notifyNo, busiModel, payType});
                if ("1".equals(busiModel) && SaleOrderPayType.BILL_RECEIVE.getCode().equals(payType) && (payLs = this.payableService.createPayableBill(notifyNo, companyId, reqBO.getIsProfessionalOrgExt(), busiModel)).size() > 0) {
                    writeOffAmt = payLs.get(0).getNeedAgainstAmt();
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notifyNo);
                    if (!CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
                        List<Long> inspectionIds = payPurchaseOrderInfos.stream().map(PayPurchaseOrderInfo::getInspectionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        this.updatePayableDetailOverduePenalty(payLs.get(0), inspectionIds);
                    }
                }
            }
            busiNotificationRspBO.setRespCode("0000");
            busiNotificationRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u751f\u4ea7\u5f00\u7968\u901a\u77e5\u5355\u5931\u8d25\uff1a", (Throwable)e);
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u751f\u4ea7\u5f00\u7968\u901a\u77e5\u5355\u5931\u8d25");
            return busiNotificationRspBO;
        }
        return busiNotificationRspBO;
    }

    private void updatePayableDetailOverduePenalty(PayableDetailPO payableDetailPo, List<Long> inspectionIds) {
        if (!CollectionUtils.isEmpty(inspectionIds)) {
            FscPayableDetailUpdateOverduePenaltyBusiReqBO reqBo = new FscPayableDetailUpdateOverduePenaltyBusiReqBO();
            reqBo.setPayableNo(payableDetailPo.getPayableNo());
            reqBo.setInspectionIds(inspectionIds);
            FscPayableDetailUpdateOverduePenaltyBusiRspBO rspBo = this.fscPayableDetailUpdateBusiService.dealOverduePenaltyUpdate(reqBo);
            log.debug("\u66f4\u65b0\u8fdd\u7ea6\u91d1\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBo), (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

