/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.ApplyPayBO;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.bo.CountTabVO;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoByIdReqBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoByIdRspBO;
import com.tydic.pfscext.api.busi.bo.QueryBenefitsPayableReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBenefitsPayableRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailNewRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableStatusReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableStatusRspBO;
import com.tydic.pfscext.api.busi.vo.ApplyDetailVO;
import com.tydic.pfscext.api.trade.PayableService;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.DApplyPayInfoExtMapMapper;
import com.tydic.pfscext.dao.PayableDetailChangeMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.DApplyPayInfoExtMapPO;
import com.tydic.pfscext.dao.po.PayableDetailChange;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.bo.ReceiveDetailBO;
import com.tydic.pfscext.service.atom.bo.SaleOrderBO;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import com.tydic.pfscext.utils.FscStringUtils;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgAbilityBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgAbilityReqPageBO;
import com.tydic.umc.ability.org.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.perf.common.UmcSupplierInfoBO;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoListAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.PayableService"})
public class PayableServiceImpl
implements PayableService {
    private static final Logger logger = LoggerFactory.getLogger(PayableServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private PayableDetailChangeMapper payableDetailChangeMapper;
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private DApplyPayInfoExtMapMapper applyPayInfoExtMapMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcQrySupplierInfoListAbilityService umcQrySupplierInfoListAbilityService;
    @Autowired
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @Value(value="${FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES:014,019,001}")
    private String FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES;
    @Value(value="${FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES:002}")
    private String FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"queryPayableListPage"})
    public QueryPayableDetailNewRspBO queryPayableListPage(@RequestBody QueryPayableDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        }
        if (null != reqBO.getIsShop() && 0 == reqBO.getIsShop()) {
            reqBO.setSource(OrderSource.PRICE_FRAME.getCode());
        }
        ArrayList<Integer> payableTypes = new ArrayList<Integer>();
        ArrayList<Integer> busiModels = new ArrayList<Integer>();
        ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
        if (reqBO.getSource() != null && !"".equals(reqBO.getSource())) {
            applyPayInfoVO.setSource(reqBO.getSource());
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setPurchaseNo(reqBO.getCompanyId());
            if (!CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
                BillApplyInfoVO vo = new BillApplyInfoVO();
                vo.setApplyNoList(reqBO.getApplyNoList());
                List<BillApplyInfo> list = this.billApplyInfoMapper.getList(vo);
                for (BillApplyInfo billApplyInfo : list) {
                    if (!BillStatus.SIGNED_IN.getCode().equals(billApplyInfo.getBillStatus())) continue;
                    throw new PfscExtBusinessException("18000", "\u8bf7\u52fe\u9009\u5df2\u6536\u7968\u7684\u6570\u636e");
                }
            }
            applyPayInfoVO.setPurchaseNo(reqBO.getCompanyId());
            if (this.checkPurchaserId(reqBO)) {
                applyPayInfoVO.setPurchaserId(reqBO.getUserId().toString());
            }
        }
        if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setSupplierId(reqBO.getSupId());
            busiModels.add(1);
            payableTypes.add(1);
            applyPayInfoVO.setSupplierId(reqBO.getSupId());
        }
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            busiModels.add(0);
            payableTypes.add(2);
            payableTypes.add(3);
            payableTypes.add(4);
            payableTypes.add(5);
            payableTypes.add(6);
            payableTypes.add(7);
            payableTypes.add(8);
            payableTypes.add(9);
            payableTypes.add(10);
            payableTypes.add(11);
            payableTypes.add(12);
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && this.checkPurchaserId(reqBO)) {
            reqBO.setPurchaserId(reqBO.getUserId().toString());
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPayableStatus()) && !StringUtils.isEmpty((CharSequence)reqBO.getTabId())) {
            ArrayList payStatusCodes = new ArrayList();
            ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(reqBO.getTabId()));
            Collections.addAll(payStatusCodes, confTabStatePO.getStatusCode().split(","));
            reqBO.setPayableStatusCodes(payStatusCodes);
        }
        QueryPayableDetailNewRspBO rspPageBO = new QueryPayableDetailNewRspBO();
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " CREATE_DATE desc";
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        logger.debug("\u4e0b\u5355\u4eba======" + reqBO.getPurchaserId());
        String purchaseOrderCodeLike = reqBO.getPurchaseOrderCodeLike();
        if (StringUtils.isNotBlank((CharSequence)purchaseOrderCodeLike)) {
            logger.error("\u591a\u4e2a\u8ba2\u5355\u67e5\u8be2\uff1a{}", (Object)purchaseOrderCodeLike);
            if (purchaseOrderCodeLike.contains(",") || purchaseOrderCodeLike.contains("\uff0c")) {
                reqBO.setPurchaseOrderCodeLike(null);
                String[] split = purchaseOrderCodeLike.split("[,\uff0c]");
                long count = Arrays.stream(split).filter(StringUtils::isNotBlank).distinct().count();
                if (count > 200L) {
                    throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6761\u4ef6\u8ba2\u5355\u7f16\u53f7\u62fc\u63a5\u65f6\u8bf7\u52ff\u8d85\u8fc7100\u4e2a\u8ba2\u5355");
                }
                String purchaseOrderCodeRegexp = Arrays.stream(split).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining("|"));
                logger.error("\u591a\u4e2a\u8ba2\u5355\u67e5\u8be2Regexp\uff1a{}", (Object)purchaseOrderCodeRegexp);
                reqBO.setPurchaseOrderCodeRegexp(purchaseOrderCodeRegexp);
            }
        }
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.getListPageByTerms(reqBO, (Page<Map<String, Object>>)page, orderBy);
        ArrayList<BusiTabNumbersQryBO> tabCountList = new ArrayList<BusiTabNumbersQryBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getSource())) {
                applyPayInfoVO.setSource("2");
            } else {
                applyPayInfoVO.setSource(reqBO.getSource());
            }
            List<CountTabVO> countTabVOList = this.applyPayInfoMapper.selectListPayableListToCount(applyPayInfoVO, payableTypes, busiModels);
            ConfTabStatePO po = new ConfTabStatePO();
            po.setTabIdList(reqBO.getTabIdList());
            po.setObjType(4);
            List<ConfTabStatePO> tabStatePOS = this.confTabStateMapper.getList(po);
            if (!CollectionUtils.isEmpty(tabStatePOS)) {
                for (ConfTabStatePO confTabStatePO : tabStatePOS) {
                    BusiTabNumbersQryBO bo = new BusiTabNumbersQryBO();
                    for (CountTabVO countTabVO : countTabVOList) {
                        if (!confTabStatePO.getStatusCode().contains(countTabVO.getPayStatus())) continue;
                        if (bo.getTabsCount() != null) {
                            bo.setTabsCount(Integer.valueOf(bo.getTabsCount() + countTabVO.getCountNum()));
                            continue;
                        }
                        bo.setTabsCount(countTabVO.getCountNum());
                    }
                    bo.setTabId(confTabStatePO.getTabId());
                    bo.setTabName(confTabStatePO.getTabName());
                    tabCountList.add(bo);
                }
            }
            if (reqBO.getTabIdList().contains("7777")) {
                BusiTabNumbersQryBO bo = new BusiTabNumbersQryBO();
                bo.setTabName("\u5f85\u4ed8\u6b3e");
                bo.setTabId("7777");
                bo.setTabsCount(Integer.valueOf(page.getTotalCount()));
                tabCountList.add(bo);
            }
        }
        rspPageBO.setTabCountList(tabCountList);
        LinkedList<PayableDetailBO> payableDetailBOs = new LinkedList<PayableDetailBO>();
        if (!CollectionUtils.isEmpty(payableDetailPOs)) {
            HashSet<String> orderCodeSet = new HashSet<String>();
            HashSet<Long> supplierNos = new HashSet<Long>();
            ArrayList<Long> purchaseNos = new ArrayList<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                if (!StringUtils.isEmpty((CharSequence)payableDetailPO.getPurchaseOrderCode())) {
                    orderCodeSet.add(payableDetailPO.getPurchaseOrderCode());
                }
                if (payableDetailPO.getSupplierId() != null) {
                    supplierNos.add(payableDetailPO.getSupplierId());
                }
                if (payableDetailPO.getPurchaseNo() == null) continue;
                purchaseNos.add(payableDetailPO.getPurchaseNo());
            }
            HashMap<Long, String> hashMap = new HashMap<Long, String>();
            UmcQrySupplierInfoListAbilityReqBO umcQrySupplierInfoListAbilityReqBO = new UmcQrySupplierInfoListAbilityReqBO();
            umcQrySupplierInfoListAbilityReqBO.setPageNo(Integer.valueOf(-1));
            umcQrySupplierInfoListAbilityReqBO.setPageSize(Integer.valueOf(-1));
            umcQrySupplierInfoListAbilityReqBO.setSupplierIds(new ArrayList(supplierNos));
            UmcQrySupplierInfoListAbilityRspBO umcQrySupplierInfoListAbilityRspBO = this.umcQrySupplierInfoListAbilityService.qrySupplierInfoList(umcQrySupplierInfoListAbilityReqBO);
            if (umcQrySupplierInfoListAbilityRspBO != null && !CollectionUtils.isEmpty((Collection)umcQrySupplierInfoListAbilityRspBO.getRows())) {
                for (UmcSupplierInfoBO umcSupplierInfoBO : umcQrySupplierInfoListAbilityRspBO.getRows()) {
                    hashMap.put(umcSupplierInfoBO.getSupplierId(), umcSupplierInfoBO.getSupplierName());
                }
            }
            HashMap hashMap2 = new HashMap();
            if (!CollectionUtils.isEmpty(purchaseNos)) {
                UmcEnterpriseOrgAbilityReqPageBO orgAbilityReqPageBO = new UmcEnterpriseOrgAbilityReqPageBO();
                orgAbilityReqPageBO.setOrgIds(purchaseNos);
                orgAbilityReqPageBO.setQueryType("02");
                orgAbilityReqPageBO.setPageSize(Integer.valueOf(purchaseNos.size()));
                UmcRspListBO orgAbilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgList(orgAbilityReqPageBO);
                if (orgAbilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)orgAbilityRspBO.getRows())) {
                    Map<Long, String> map = orgAbilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgAbilityBO::getOrgId, UmcEnterpriseOrgAbilityBO::getOrgName));
                }
            }
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                void var18_26;
                PayableDetailBO singleDetail = new PayableDetailBO();
                BeanUtils.copyProperties((Object)payableDetailPO, (Object)singleDetail);
                singleDetail.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
                if (singleDetail.getPayableType() != null) {
                    singleDetail.setPayableTypeStr(PayableType.getInstance(payableDetailPO.getPayableType().toString()).getDescr());
                }
                logger.debug("getPayableStatus\uff1a" + payableDetailPO.getPayableStatus());
                PayableStatus payableEnum = PayableStatus.getInstance(payableDetailPO.getPayableStatus());
                singleDetail.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
                logger.debug("getPayableStatusStr\uff1a" + singleDetail.getPayableStatusStr());
                OrderSource orderSourceEnum = OrderSource.getInstance((String)singleDetail.getSource());
                singleDetail.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String orgNameStr = this.organizationInfoService.queryOrgName(singleDetail.getOperatorId());
                singleDetail.setOperatorStr(orgNameStr);
                PayablePayType payTypeEnum = PayablePayType.getInstance(singleDetail.getPayType());
                singleDetail.setPayTypeStr(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setPayTypeName(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setOrderAmt(payableDetailPO.getOrderAmt());
                if (payableDetailPO.getPayableAmt() != null && payableDetailPO.getPaidAmt() != null) {
                    singleDetail.setToPayAmt(payableDetailPO.getPayableAmt().subtract(payableDetailPO.getPaidAmt()));
                }
                if (null != payableDetailPO.getOrderId()) {
                    SaleOrderInfoVO saleOrderInfo = new SaleOrderInfoVO();
                    saleOrderInfo.setOrderId(payableDetailPO.getOrderId());
                    List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(saleOrderInfo);
                    if (saleOrderInfos != null && saleOrderInfos.size() > 0) {
                        singleDetail.setPurchaseOrderId(saleOrderInfos.get(0).getPurchaseOrderId());
                    }
                }
                singleDetail.setAllInPaying("N");
                if (PayableStatus.SUCCESS.getCode().equals(singleDetail.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(singleDetail.getPayableStatus()) || singleDetail.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    singleDetail.setAllInPaying("Y");
                } else {
                    ApplyDetail applyDetail = this.applyDetailMapper.selectAmtByPayableNo(singleDetail.getPayableNo());
                    if (singleDetail.getPayableAmt().subtract(applyDetail != null ? applyDetail.getAmt() : BigDecimal.ZERO).subtract(singleDetail.getPaidAmt()).compareTo(BigDecimal.ZERO) == 0) {
                        singleDetail.setAllInPaying("Y");
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)payableDetailPO.getSupplierName())) {
                    singleDetail.setSupplierStr(payableDetailPO.getSupplierName());
                } else if (hashMap.containsKey(payableDetailPO.getSupplierId())) {
                    singleDetail.setSupplierStr((String)hashMap.get(payableDetailPO));
                }
                PayableDetailChange change = new PayableDetailChange();
                change.setPayableNo(payableDetailPO.getPayableNo());
                change.setChangeType("2");
                List<PayableDetailChange> changeList = this.payableDetailChangeMapper.getList(change);
                if (!CollectionUtils.isEmpty(changeList)) {
                    singleDetail.setShowChangeFlag("1");
                } else {
                    singleDetail.setShowChangeFlag("0");
                }
                if (var18_26.get(singleDetail.getPurchaseNo()) != null) {
                    singleDetail.setPurchaseName((String)var18_26.get(singleDetail.getPurchaseNo()));
                }
                singleDetail.setExportApplyAndNotiNo((singleDetail.getApplyNo() == null ? "" : singleDetail.getApplyNo()) + (singleDetail.getNotificationNo() == null ? "" : singleDetail.getNotificationNo()));
                payableDetailBOs.add(singleDetail);
            }
        }
        rspPageBO.setRows(payableDetailBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    private boolean checkPurchaserId(QueryPayableDetailReqBO reqBo) {
        List roleIds;
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPermission()) && !CollectionUtils.isEmpty(roleIds = reqBo.getPermission().stream().map(AuthorityInfo::getKey).distinct().collect(Collectors.toList()))) {
            if (StrUtil.isBlank((CharSequence)this.FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES)) {
                return false;
            }
            List purchaserRoles = Arrays.stream(this.FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES.split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
            if (roleIds.stream().anyMatch(purchaserRoles::contains)) {
                if (StrUtil.isBlank((CharSequence)this.FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES)) {
                    return true;
                }
                List companyRoles = Arrays.stream(this.FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES.split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
                return roleIds.stream().noneMatch(companyRoles::contains);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"submitApplyPay"})
    public BusiApplyPayServiceRspBO submitApplyPay(@RequestBody BusiApplyPayServiceReqBO reqBO) {
        void var13_26;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!org.springframework.util.StringUtils.hasText((String)reqBO.getReceiptAcctNo())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!org.springframework.util.StringUtils.hasText((String)reqBO.getRecAcctName())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!org.springframework.util.StringUtils.hasText((String)reqBO.getPayChannel()) && "1" == reqBO.getPayChannel() && !org.springframework.util.StringUtils.hasText((String)reqBO.getPayVoucher())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> payableNoList = new ArrayList<String>();
        ArrayList<String> sourceList = new ArrayList<String>();
        ArrayList<Integer> payableTypeList = new ArrayList<Integer>();
        List applyPayBOList = reqBO.getApplyPayBOList();
        for (Object applyPayBO : applyPayBOList) {
            if (!org.springframework.util.StringUtils.hasText((String)applyPayBO.getPayableNo())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!org.springframework.util.StringUtils.hasText((String)applyPayBO.getSource())) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            payableNoList.add(applyPayBO.getPayableNo());
            sourceList.add(applyPayBO.getSource());
            payableTypeList.add(applyPayBO.getPayableType());
        }
        String firstSource = (String)sourceList.get(0);
        for (String string : sourceList) {
            if (firstSource.compareTo(string) == 0) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u6765\u6e90\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b");
        }
        Integer firstPaybaleType = (Integer)payableTypeList.get(0);
        for (Integer payableType : payableTypeList) {
            if (firstPaybaleType.compareTo(payableType) == 0) continue;
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u7c7b\u884c\u4e0d\u540c\u4e0d\u80fd\u4e00\u8d77\u4ed8\u6b3e");
        }
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        payableDetailVO.setPayableNos(payableNoList);
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
        Long branchCompany = null;
        Long supplierId = null;
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            if (supplierId == null) {
                supplierId = payableDetailPO.getSupplierId();
            } else if (!supplierId.equals(payableDetailPO.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u4ed8\u6b3e");
            }
            if (!reqBO.getCompanyId().equals(payableDetailPO.getOperatorId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
            }
            if (branchCompany != null) continue;
            branchCompany = payableDetailPO.getBranchCompany();
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.CONSULT_PRICE.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
            HashSet<Long> orders = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                orders.add(payableDetailPO.getOrderId());
            }
            if (orders.size() > 1) {
                if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
                    Object var13_19 = null;
                    for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                        void var13_20;
                        if (!org.springframework.util.StringUtils.hasText((String)payableDetailPO.getPlaAgreementCode())) {
                            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u7684\u5e94\u4ed8\u8bb0\u5f55\u4e0a\u6ca1\u6709\u8bb0\u5f55\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\uff0c\u4e0d\u80fd\u4ed8\u6b3e");
                        }
                        if (var13_20 == null) {
                            String string = payableDetailPO.getPlaAgreementCode();
                            continue;
                        }
                        if (var13_20.equals(payableDetailPO.getPlaAgreementCode())) continue;
                        throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\u4e0d\u540c\u7684\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u4ed8\u6b3e");
                    }
                }
                ArrayList<Long> arrayList = new ArrayList<Long>(orders);
                PayableDetailVO payableDetailVO2 = new PayableDetailVO();
                payableDetailVO2.setOrderIdList(arrayList);
                payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO2);
                for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                    String payType = payableDetailPO.getPayType();
                    if (!PayablePayType.PREPAY.getCode().equals(payType)) continue;
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u6709" + PayablePayType.getInstance(payType).getDescr() + "\uff0c\u4e0d\u80fd\u548c\u5176\u4ed6\u8ba2\u5355\u5408\u5e76\u4ed8\u6b3e");
                }
            }
        }
        String payno = this.getPayInfoId();
        logger.info("\u6d41\u6c34\u53f7\uff1a" + payno);
        BigDecimal bigDecimal = new BigDecimal(0);
        for (ApplyPayBO applyPayBO : applyPayBOList) {
            BigDecimal bigDecimal2 = applyPayBO.getPayAmt().add((BigDecimal)var13_26);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payno);
            applyDetail.setPayableNo(applyPayBO.getPayableNo());
            applyDetail.setOperatorId(reqBO.getUserId());
            applyDetail.setSource(applyPayBO.getSource());
            applyDetail.setSupplierId(reqBO.getSupplierId());
            applyDetail.setStatus(ApplyPayStatus.PAY_CONFIRMED.getCode());
            applyDetail.setAmt(applyPayBO.getPayAmt());
            applyDetail.setCompanyId(reqBO.getCompanyId());
            this.applyDetailMapper.insert(applyDetail);
            this.doAction(applyPayBO.getPayableNo(), applyPayBO.getPayAmt(), 2);
        }
        Date date = new Date();
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)applyPayInfoPO);
        applyPayInfoPO.setPayAmt((BigDecimal)var13_26);
        applyPayInfoPO.setPayno(payno);
        applyPayInfoPO.setSource(firstSource);
        applyPayInfoPO.setApplyDate(date);
        applyPayInfoPO.setOperatorId(reqBO.getUserId());
        if (reqBO.getUserId() != null) {
            applyPayInfoPO.setOperatorName(this.organizationInfoService.querySupplierName(reqBO.getUserId()));
        }
        applyPayInfoPO.setPayStatus(ApplyPayStatus.PAY_CONFIRMED.getCode());
        applyPayInfoPO.setBranchCompany(branchCompany);
        applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
        applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
        if (applyPayInfoPO.getSupplierName() == null && applyPayInfoPO.getSupplierId() != null) {
            applyPayInfoPO.setSupplierName(this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId()));
        }
        this.applyPayInfoMapper.insert(applyPayInfoPO);
        BusiApplyPayServiceRspBO rspBO = new BusiApplyPayServiceRspBO();
        return rspBO;
    }

    @PostMapping(value={"qryApplyPayDetail"})
    public QueryApplyPayInfoByIdRspBO qryApplyPayDetail(@RequestBody QueryApplyPayInfoByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getId() == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryApplyPayInfoByIdRspBO queryApplyPayInfoByIdRspBO = new QueryApplyPayInfoByIdRspBO();
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(reqBO.getId());
        if (applyPayInfoPO == null) {
            throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
        BeanUtils.copyProperties((Object)applyPayInfoPO, (Object)applyPayInfoBO);
        logger.debug("-----\u4ed8\u6b3e\u6e20\u9053-----" + applyPayInfoPO.getPayChannel());
        if (applyPayInfoPO.getPayChannel() != null && !"".equals(applyPayInfoPO.getPayChannel())) {
            applyPayInfoBO.setPayChannel(Integer.valueOf(Integer.parseInt(applyPayInfoPO.getPayChannel())));
            applyPayInfoBO.setPayChannelStr(PayChannel.getInstance(applyPayInfoPO.getPayChannel()).getDescr());
            logger.debug("-----\u4ed8\u6b3e\u6e20\u9053-----" + applyPayInfoBO.getPayChannel());
        }
        PayResultStatus payResultEnum = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
        applyPayInfoBO.setPayStatusStr(this.enumsService.getDescr(payResultEnum));
        OrderSource orderSourceEnum = OrderSource.getInstance((String)applyPayInfoBO.getSource());
        applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
        String supplierStr = this.organizationInfoService.querySupplierName(applyPayInfoBO.getSupplierId());
        applyPayInfoBO.setSupplierStr(supplierStr);
        applyPayInfoBO.setSupplierName(supplierStr);
        PayablePayType psPayTypeEnum = PayablePayType.getInstance(applyPayInfoBO.getPayMathod());
        applyPayInfoBO.setPayMathodStr(this.enumsService.getDescr(psPayTypeEnum));
        logger.debug("\u4ed8\u6b3e\u6e20\u9053----" + applyPayInfoBO.getPayChannelStr());
        if (applyPayInfoBO.getPayChannel() != null && StrUtil.isNotBlank((CharSequence)applyPayInfoBO.getPayno())) {
            Map<String, String> mapCodeValue;
            if (PayChannel.WECHAT.getCode().equals(applyPayInfoBO.getPayChannel().toString()) || PayChannel.ZFB.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                applyPayInfoBO.setRecAcctName(applyPayInfoBO.getSupplierName());
                applyPayInfoBO.setOpenBankName(null);
                applyPayInfoBO.setReceiptAcctNo(null);
            } else if (PayChannel.GYLJR.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno());
                if (!mapCodeValue.isEmpty()) {
                    applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("corpNameAccept")).orElse(""));
                    applyPayInfoBO.setOpenBankName(null);
                    applyPayInfoBO.setReceiptAcctNo(null);
                }
            } else if (PayChannel.ZGYH.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno());
                if (!mapCodeValue.isEmpty()) {
                    applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("chinaBankAccountName")).orElse(""));
                    applyPayInfoBO.setOpenBankName(null);
                    applyPayInfoBO.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("chinaBankAccountNo")).orElse(""));
                }
            } else if (PayChannel.ZGGSYH.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno());
                if (!mapCodeValue.isEmpty()) {
                    applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("accountName")).orElse(""));
                    applyPayInfoBO.setOpenBankName(Optional.ofNullable(mapCodeValue.get("icbcBankName")).orElse(""));
                    applyPayInfoBO.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("accountNo")).orElse(""));
                }
            } else if (PayChannel.ZHCQT.getCode().equals(applyPayInfoBO.getPayChannel().toString()) && !(mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno())).isEmpty()) {
                applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("cnncPayeeAcctName")).orElse(""));
                applyPayInfoBO.setOpenBankName(Optional.ofNullable(mapCodeValue.get("cnncRemitBankName")).orElse(""));
                applyPayInfoBO.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("cnncPayeeAcctNo")).orElse(""));
            }
        }
        queryApplyPayInfoByIdRspBO.setApplyPayInfoBO(applyPayInfoBO);
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(reqBO.getId());
        if (CollectionUtils.isEmpty(applyDetails)) {
            throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        LinkedList<ApplyDetailVO> rows = new LinkedList<ApplyDetailVO>();
        for (ApplyDetail singleDetail : applyDetails) {
            PayableDetailPO singlePayable = this.payableDetailMapper.getModelById(singleDetail.getPayableNo());
            if (singlePayable == null) {
                throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            String payType = singlePayable.getPayType();
            ApplyDetailVO payableDetailBO = new ApplyDetailVO();
            BeanUtils.copyProperties((Object)singleDetail, (Object)payableDetailBO);
            BeanUtils.copyProperties((Object)singlePayable, (Object)payableDetailBO);
            if (payableDetailBO.getPayableType() != null) {
                payableDetailBO.setPayableTypeStr(PayableType.getInstance(payableDetailBO.getPayableType().toString()).getDescr());
            }
            PayResultStatus payResultStatus = PayResultStatus.getInstance(payableDetailBO.getStatus());
            payableDetailBO.setPayResultStatusStr(this.enumsService.getDescr(payResultStatus));
            OrderSource orderSourceEnum2 = OrderSource.getInstance((String)payableDetailBO.getSource());
            payableDetailBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum2));
            String supplierStr2 = this.organizationInfoService.querySupplierName(payableDetailBO.getSupplierId());
            payableDetailBO.setSupplierStr(supplierStr2);
            String orgNameStr = this.organizationInfoService.queryOrgName(payableDetailBO.getOperatorId());
            payableDetailBO.setOperatorStr(orgNameStr);
            SaleOrderBO saleOrderBO = this.orderService.obtainSaleOrder(singlePayable.getOrderId());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setSource(singlePayable.getSource());
            saleOrderInfoVO.setOrderId(saleOrderBO.getSaleOrderId());
            saleOrderInfoVO.setSaleOrderCode(saleOrderBO.getSaleOrderCode());
            Map<String, ReceiveDetailBO> receiveDetail = this.orderService.obtainReceiveDetail(saleOrderInfoVO);
            rows.add(payableDetailBO);
        }
        queryApplyPayInfoByIdRspBO.setRows(rows);
        return queryApplyPayInfoByIdRspBO;
    }

    private Map<String, String> mapApplyPayInfoCodeValue(String payno) {
        DApplyPayInfoExtMapPO applyPayInfoExtMapQry = new DApplyPayInfoExtMapPO();
        applyPayInfoExtMapQry.setObjId(payno);
        applyPayInfoExtMapQry.setObjType(1);
        List<DApplyPayInfoExtMapPO> payInfoExtMapList = this.applyPayInfoExtMapMapper.getList(applyPayInfoExtMapQry);
        HashMap<String, String> mapCodeValue = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(payInfoExtMapList)) {
            mapCodeValue.putAll(payInfoExtMapList.stream().collect(Collectors.toMap(DApplyPayInfoExtMapPO::getFieldCode, DApplyPayInfoExtMapPO::getFieldValue, (c, n) -> c)));
        }
        return mapCodeValue;
    }

    @PostMapping(value={"updateApplyPay"})
    public PfscExtRspBaseBO updateApplyPay(@RequestBody BusiApplyPayServiceReqBO reqBO) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            applyPayInfoPO.setPayno(reqBO.getPayNo());
            applyPayInfoPO.setPayStatus(reqBO.getPayStatus().toString());
            this.applyPayInfoMapper.updateStatusBatch(applyPayInfoPO);
            pfscExtRspBaseBO.setRespCode("0000");
            pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u4fee\u6539\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }

    @PostMapping(value={"queryPayableListPageByPayNo"})
    public PfscExtRspPageBaseBO<PayableDetailBO> queryPayableListPageByPayNo(@RequestBody QueryPayableDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6839\u636e\u4ed8\u6b3e\u5355\u53f7\u67e5\u8be2\u5e94\u4ed8\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null != reqBO.getIsShop() && 0 == reqBO.getIsShop()) {
            reqBO.setSource(OrderSource.PRICE_FRAME.getCode());
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setPurchaseNo(reqBO.getCompanyId());
        }
        if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setSupplierId(reqBO.getSupId());
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && this.checkPurchaserId(reqBO)) {
            reqBO.setPurchaserId(reqBO.getUserId().toString());
        }
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " CREATE_DATE desc";
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        logger.debug("\u4e0b\u5355\u4eba======" + reqBO.getPurchaserId());
        List<ApplyDetail> applyDetailList = this.applyDetailMapper.selectByApplyNo(reqBO.getPayNo());
        if (CollectionUtils.isEmpty(applyDetailList)) {
            return rspPageBO;
        }
        ArrayList<String> payableNos = new ArrayList<String>();
        for (ApplyDetail applyDetail : applyDetailList) {
            payableNos.add(applyDetail.getPayableNo());
        }
        reqBO.setPayableNos(payableNos);
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.getListPageByTerms(reqBO, (Page<Map<String, Object>>)page, orderBy);
        LinkedList<PayableDetailBO> payableDetailBOs = new LinkedList<PayableDetailBO>();
        if (!CollectionUtils.isEmpty(payableDetailPOs)) {
            HashSet<String> orderCodeSet = new HashSet<String>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                if (StringUtils.isEmpty((CharSequence)payableDetailPO.getPurchaseOrderCode())) continue;
                orderCodeSet.add(payableDetailPO.getPurchaseOrderCode());
            }
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                PayableDetailBO singleDetail = new PayableDetailBO();
                BeanUtils.copyProperties((Object)payableDetailPO, (Object)singleDetail);
                singleDetail.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
                if (singleDetail.getPayableType() != null) {
                    singleDetail.setPayableTypeStr(PayableType.getInstance(payableDetailPO.getPayableType().toString()).getDescr());
                }
                logger.debug("getPayableStatus\uff1a" + payableDetailPO.getPayableStatus());
                PayableStatus payableEnum = PayableStatus.getInstance(payableDetailPO.getPayableStatus());
                singleDetail.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
                logger.debug("getPayableStatusStr\uff1a" + singleDetail.getPayableStatusStr());
                OrderSource orderSourceEnum = OrderSource.getInstance((String)singleDetail.getSource());
                singleDetail.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String orgNameStr = this.organizationInfoService.queryOrgName(singleDetail.getOperatorId());
                singleDetail.setOperatorStr(orgNameStr);
                PayablePayType payTypeEnum = PayablePayType.getInstance(singleDetail.getPayType());
                singleDetail.setPayTypeStr(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setPayTypeName(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(singleDetail.getProfessionalDepartId()));
                singleDetail.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(singleDetail.getServiceDepartId()));
                singleDetail.setBranchCompanyName(this.organizationInfoService.queryOrgName(payableDetailPO.getBranchCompany()));
                singleDetail.setOrderAmt(payableDetailPO.getOrderAmt());
                if (payableDetailPO.getPayableAmt() != null && payableDetailPO.getPaidAmt() != null) {
                    singleDetail.setToPayAmt(payableDetailPO.getPayableAmt().subtract(payableDetailPO.getPaidAmt()));
                }
                if (null != payableDetailPO.getOrderId()) {
                    SaleOrderInfoVO saleOrderInfo = new SaleOrderInfoVO();
                    saleOrderInfo.setOrderId(payableDetailPO.getOrderId());
                    List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(saleOrderInfo);
                    if (saleOrderInfos != null && saleOrderInfos.size() > 0) {
                        singleDetail.setPurchaseOrderId(saleOrderInfos.get(0).getPurchaseOrderId());
                    }
                }
                singleDetail.setAllInPaying("N");
                if (PayableStatus.SUCCESS.getCode().equals(singleDetail.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(singleDetail.getPayableStatus()) || singleDetail.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    singleDetail.setAllInPaying("Y");
                } else {
                    ApplyDetail applyDetail = this.applyDetailMapper.selectAmtByPayableNo(singleDetail.getPayableNo());
                    if (singleDetail.getPayableAmt().subtract(applyDetail != null ? applyDetail.getAmt() : BigDecimal.ZERO).subtract(singleDetail.getPaidAmt()).compareTo(BigDecimal.ZERO) == 0) {
                        singleDetail.setAllInPaying("Y");
                    }
                }
                payableDetailBOs.add(singleDetail);
            }
        }
        rspPageBO.setRows(payableDetailBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    @PostMapping(value={"QueryBenefitsPayable"})
    public QueryBenefitsPayableRspBO QueryBenefitsPayable(@RequestBody QueryBenefitsPayableReqBO reqBO) {
        logger.info("\u5458\u5de5\u798f\u5229\u5e94\u4ed8\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryBenefitsPayableRspBO rspBO = new QueryBenefitsPayableRspBO();
        String orderBy = " CREATE_DATE desc";
        QueryPayableDetailReqBO queryPayableDetailReqBO = new QueryPayableDetailReqBO();
        queryPayableDetailReqBO.setApplyNoList(reqBO.getApplyNoList());
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListPageByTerms(queryPayableDetailReqBO, (Page<Map<String, Object>>)new Page(-1, -1), orderBy);
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u4e3a\u7a7a");
        }
        LinkedList<PayableDetailBO> payableDetailBOS = new LinkedList<PayableDetailBO>();
        LinkedList<ApplyDetailVO> applyDetailVOS = new LinkedList<ApplyDetailVO>();
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            ApplyDetail applyDetail;
            PayableDetailBO singleDetail = new PayableDetailBO();
            BeanUtil.copyProperties((Object)payableDetailPO, (Object)singleDetail, (String[])new String[0]);
            singleDetail.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
            if (singleDetail.getPayableType() != null) {
                singleDetail.setPayableTypeStr(PayableType.getInstance(payableDetailPO.getPayableType().toString()).getDescr());
            }
            logger.debug("getPayableStatus\uff1a" + payableDetailPO.getPayableStatus());
            PayableStatus payableEnum = PayableStatus.getInstance(payableDetailPO.getPayableStatus());
            singleDetail.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
            logger.debug("getPayableStatusStr\uff1a" + singleDetail.getPayableStatusStr());
            OrderSource orderSourceEnum = OrderSource.getInstance((String)singleDetail.getSource());
            singleDetail.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
            String orgNameStr = this.organizationInfoService.queryOrgName(singleDetail.getOperatorId());
            singleDetail.setOperatorStr(orgNameStr);
            PayablePayType payTypeEnum = PayablePayType.getInstance(singleDetail.getPayType());
            singleDetail.setPayTypeStr(this.enumsService.getDescr(payTypeEnum));
            singleDetail.setPayTypeName(this.enumsService.getDescr(payTypeEnum));
            singleDetail.setOrderAmt(payableDetailPO.getOrderAmt());
            if (null != payableDetailPO.getOrderId()) {
                SaleOrderInfoVO saleOrderInfo = new SaleOrderInfoVO();
                saleOrderInfo.setOrderId(payableDetailPO.getOrderId());
                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(saleOrderInfo);
                if (saleOrderInfos != null && saleOrderInfos.size() > 0) {
                    singleDetail.setPurchaseOrderId(saleOrderInfos.get(0).getPurchaseOrderId());
                }
            }
            singleDetail.setAllInPaying("N");
            if (PayableStatus.SUCCESS.getCode().equals(singleDetail.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(singleDetail.getPayableStatus()) || singleDetail.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                singleDetail.setAllInPaying("Y");
            } else {
                applyDetail = this.applyDetailMapper.selectAmtByPayableNo(singleDetail.getPayableNo());
                if (singleDetail.getPayableAmt().subtract(applyDetail != null ? applyDetail.getAmt() : BigDecimal.ZERO).subtract(singleDetail.getPaidAmt()).compareTo(BigDecimal.ZERO) == 0) {
                    singleDetail.setAllInPaying("Y");
                }
            }
            payableDetailBOS.add(singleDetail);
            applyDetail = this.applyDetailMapper.selectByPayableNo(payableDetailPO.getPayableNo());
            if (applyDetail == null || !ApplyPayStatus.APPLYING.getCode().equals(applyDetail.getStatus()) && !ApplyPayStatus.PIDNG_DEALING.getCode().equals(applyDetail.getStatus())) continue;
            ApplyDetailVO applyDetailVO = new ApplyDetailVO();
            BeanUtil.copyProperties((Object)applyDetail, (Object)applyDetailVO, (String[])new String[0]);
            applyDetailVO.setPayableTypeStr(ApplyPayStatus.getInstance(applyDetail.getStatus()).getCodeDescr());
            applyDetailVOS.add(applyDetailVO);
        }
        if (!CollectionUtils.isEmpty(applyDetailVOS)) {
            rspBO.setPayingFlag("1");
        }
        rspBO.setPayableDetailBOS(payableDetailBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"queryPayableStatus"})
    public QueryPayableStatusRspBO queryPayableStatus(@RequestBody QueryPayableStatusReqBO reqBO) {
        if (reqBO == null | StringUtils.isEmpty((CharSequence)reqBO.getOrderCode())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayableStatusRspBO rspBO = new QueryPayableStatusRspBO();
        PayableDetailPO po = new PayableDetailPO();
        po.setPurchaseOrderCode(reqBO.getOrderCode());
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getList(po);
        if (!CollectionUtils.isEmpty(payableDetailPOS)) {
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                if (!ApplyPayStatus.PIDNG_DEALING.getCode().equals(payableDetailPO.getApplyStatus()) && !ApplyPayStatus.SUCCESS_PIDNG.getCode().equals(payableDetailPO.getApplyStatus())) continue;
                ApplyDetailVO vo = new ApplyDetailVO();
                vo.setApplyNo(Long.valueOf(payableDetailPO.getPayNo()));
                vo.setPayableNo(payableDetailPO.getPayableNo());
                rspBO.setApplyDetailVO(vo);
                rspBO.setContinueFlag("0");
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u8ba2\u5355\u6b63\u5728\u8fdb\u884c\u4ed8\u6b3e\uff0c\u8bf7\u5728\u652f\u4ed8\u5b8c\u6210\u540e\u5728\u8fdb\u884c\u9000\u8d27\u64cd\u4f5c");
                return rspBO;
            }
        }
        rspBO.setContinueFlag("1");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8be5\u8ba2\u5355\u672a\u4ea7\u751f\u5e94\u4ed8\u5355\u6216\u5c1a\u672a\u53d1\u8d77\u4ed8\u6b3e");
        return rspBO;
    }

    private String getPayInfoId() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        String prefix = "CGFK";
        String maxNum = this.applyPayInfoMapper.selectMaxPayNoNum(prefix + dateL);
        String num = "0001";
        if (maxNum != null && !"".equals(maxNum)) {
            num = String.format("%06d", Integer.parseInt(maxNum) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(dateL).append(num);
        return sb.toString();
    }

    private void doAction(String payableNo, BigDecimal amount, int actType) {
        logger.debug("---\u51c6\u5907\u5904\u7406\u5e94\u4ed8\u5355\u7684\u76f8\u5173\u91d1\u989d\u64cd\u4f5c,\u5e94\u4ed8\u5355\u53f7=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",actType=" + actType);
        PayableDetailPO payable = this.checkParamter(payableNo, amount);
        if (payable.getPendingAmt() == null) {
            logger.debug("\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u4e2d\u91d1\u989d(pendingAmt)\u4e3anull,\u5e94\u4ed8\u5355\u53f7=" + payableNo);
            throw new PfscExtBusinessException("18000", "\u6b64\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u4e2d\u91d1\u989d\u6570\u636e\u5f02\u5e38");
        }
        if (payable.getPayableAmt() == null) {
            logger.debug("\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u91d1\u989d(payableAmt)\u4e3anull,\u5e94\u4ed8\u5355\u53f7=" + payableNo);
            throw new PfscExtBusinessException("18000", "\u6b64\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
        }
        PayableDetailPO forUpdate = new PayableDetailPO();
        forUpdate.setPayableAmt(payable.getPendingAmt());
        if (actType == 1) {
            if (payable.getPayableAmt().compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u603b\u91d1\u989d=" + payable.getPayableAmt());
                throw new PfscExtBusinessException("18000", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u5e94\u4ed8\u5355\u53f7\u7684\u603b\u91d1\u989d" + payable.getPayableAmt());
            }
            BigDecimal remainAmt = payable.getPayableAmt().subtract(payable.getPaidAmt()).subtract(payable.getPendingAmt());
            if (remainAmt.compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u8d85\u51fa\u5269\u4f59\u91d1\u989d,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u5269\u4f59\u91d1\u989d=" + remainAmt);
                throw new PfscExtBusinessException("18000", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u9700\u652f\u4ed8\u7684\u91d1\u989d" + remainAmt);
            }
            forUpdate.setPendingAmt(amount);
            forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
        } else {
            BigDecimal pendingAmt = payable.getPendingAmt();
            BigDecimal paidAmt = payable.getPaidAmt();
            if (pendingAmt.compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u8d85\u51fa\u4ed8\u6b3e\u4e2d\u91d1\u989d,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u4ed8\u6b3e\u4e2d\u91d1\u989d=" + payable.getPendingAmt());
                throw new PfscExtBusinessException("18000", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d" + payable.getPendingAmt());
            }
            if (actType == 3) {
                if ((paidAmt = paidAmt.add(amount)).compareTo(payable.getPayableAmt()) == 0) {
                    forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
                }
                forUpdate.setPaidAmt(amount);
            }
            forUpdate.setPendingAmt(amount.negate());
            pendingAmt = pendingAmt.subtract(amount);
            if (pendingAmt.compareTo(BigDecimal.ZERO) == 0 && paidAmt.compareTo(BigDecimal.ZERO) == 0) {
                forUpdate.setPayableStatus(PayableStatus.PENDING.getCode());
            }
        }
        forUpdate.setPayableNo(payableNo);
        logger.debug("\u51c6\u5907\u4fee\u6539\u5e94\u4ed8\u5355\u7684\u76f8\u5173\u91d1\u989d,act=" + actType + ",\u53c2\u6570=" + forUpdate);
        int cnt = this.payableDetailMapper.updateAmount(forUpdate);
        if (cnt != 1) {
            logger.error("\u5e94\u4ed8\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u91d1\u989d\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo + ",\u91d1\u989d=" + amount + ",\u66f4\u65b0\u6570=" + cnt);
            throw new PfscExtBusinessException("18006", "\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25,\u6b64\u9884\u4ed8\u5355\u53d1\u751f\u4e86\u53d8\u5316,\u8bf7\u91cd\u65b0\u64cd\u4f5c.");
        }
    }

    private PayableDetailPO checkParamter(String payableNo, BigDecimal amount) {
        if (!org.springframework.util.StringUtils.hasText((String)payableNo)) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u6d89\u53ca\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        PayableDetailPO payable = null;
        try {
            payable = this.payableDetailMapper.getModelById(payableNo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo, (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25" + e.getMessage());
        }
        if (payable == null) {
            logger.debug("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728,\u5e94\u4ed8\u5355=" + payableNo);
            throw new PfscExtBusinessException("18001", "\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        return payable;
    }
}

