/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.ActQryActiveListAbilityService;
import com.tydic.active.app.ability.bo.ActQryActiveListAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActiveListAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.order.extend.ability.inspection.UocInspectionOrderInfoQryAbilityService;
import com.tydic.order.extend.bo.inspection.ability.UocInspectionOrderInfoQryAbilityReqBO;
import com.tydic.order.extend.bo.inspection.ability.UocInspectionOrderInfoQryAbilityRspBO;
import com.tydic.order.extend.bo.inspection.ability.UocInspectionOrderInfoQryInfoBO;
import com.tydic.pfscext.api.trade.PaymentFlowService;
import com.tydic.pfscext.api.trade.bo.FscPaymentFlowInfoAbilityReqBO;
import com.tydic.pfscext.api.trade.bo.FscPaymentFlowInfoAbilityRspBO;
import com.tydic.pfscext.api.trade.bo.FscPaymentFlowInfoBO;
import com.tydic.pfscext.api.trade.bo.PaymentFlowInfoBO;
import com.tydic.pfscext.api.trade.bo.PaymentFlowInfoReqBO;
import com.tydic.pfscext.api.trade.bo.PaymentFlowInfoRspBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.FscPaymentFlowInfoDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.FscPaymentFlowInfoDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.FlowType;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.enums.ProfessionalOrg;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.PaymentFlowService"})
public class PaymentFlowServiceImpl
implements PaymentFlowService {
    private static final Logger log = LoggerFactory.getLogger(PaymentFlowServiceImpl.class);
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private FscPaymentFlowInfoDetailMapper fscPaymentFlowInfoDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private ActQryActiveListAbilityService actQryActiveListAbilityService;
    @Autowired
    private UocInspectionOrderInfoQryAbilityService uocInspectionOrderInfoQryAbilityService;
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";
    @Value(value="${FSC_AUTH_SYSTEM_MANAGE:auth:system:manage}")
    private String FSC_AUTH_SYSTEM_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_BUYER:002}")
    private String FSC_AUTH_PUR_COMPANY_BUYER;
    @Value(value="${FSC_AUTH_PUR_ENTERPRISE_FINANCIAL_PAYMENT_POSITION:019}")
    private String FSC_AUTH_PUR_ENTERPRISE_FINANCIAL_PAYMENT_POSITION;
    @Value(value="${FSC_AUTH_ORG_MANAGER:auth:org:manage}")
    private String FSC_AUTH_ORG_MANAGER;
    @Value(value="${FSC_AUTH_PRO_SETTLEMENT_POSITION:107}")
    private String FSC_AUTH_PRO_SETTLEMENT_POSITION;
    @Value(value="${FSC_AUTH_PRO_CUSTOMER_SERVICE_OPERATION_POSITION:117}")
    private String FSC_AUTH_PRO_CUSTOMER_SERVICE_OPERATION_POSITION;
    @Value(value="${FSC_BILL_SYSTEM_PAYMENT_INFO_URL:https://180.167.158.28:10080/home/payableManage/paymentOrder?auth=true&id=}")
    private String FSC_BILL_SYSTEM_PAYMENT_INFO_URL;

    @PostMapping(value={"addPaymentFlow"})
    public PfscExtRspBaseBO addPaymentFlow(@RequestBody PaymentFlowInfoBO paymentFlowInfoBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u589e\u7ed3\u7b97\u6d41\u6c34\uff1a" + paymentFlowInfoBO);
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        BeanUtils.copyProperties((Object)paymentFlowInfoBO, (Object)paymentFlowInfo);
        paymentFlowInfo.setCreateTime(new Date());
        long flowId = this.paymentFlowInfoMapper.insert(paymentFlowInfo);
        FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
        fscPaymentFlowInfoDetail.setFlowId(paymentFlowInfo.getSeq());
        fscPaymentFlowInfoDetail.setOutOrderId(paymentFlowInfo.getOutOrderId());
        fscPaymentFlowInfoDetail.setFlowFlag(paymentFlowInfo.getFlowFlag());
        fscPaymentFlowInfoDetail.setCreateDate(new Date());
        this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
        pfscExtRspBaseBO.setRespCode("0000");
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        return pfscExtRspBaseBO;
    }

    @PostMapping(value={"queryListPage"})
    public PfscExtRspPageBaseBO<PaymentFlowInfoRspBO> queryListPage(@RequestBody PaymentFlowInfoReqBO paymentFlowInfoReqBO) {
        Page page;
        List<PaymentFlowInfo> paymentFlowInfos;
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u7ed3\u7b97\u6d41\u6c34\uff1a" + paymentFlowInfoReqBO);
        }
        PfscExtRspPageBaseBO rspBO = new PfscExtRspPageBaseBO();
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        BeanUtils.copyProperties((Object)paymentFlowInfoReqBO, (Object)paymentFlowInfo);
        paymentFlowInfo.setOrgId(null);
        if (StrUtil.isNotBlank((CharSequence)paymentFlowInfoReqBO.getFlowFlag())) {
            paymentFlowInfo.setFlowFlag(null);
            paymentFlowInfo.setFlowFlagQuery(paymentFlowInfoReqBO.getFlowFlag());
        }
        if (ProfessionalOrg.PURCHASE.getCode().equals(paymentFlowInfoReqBO.getIsProfessionalOrgExt())) {
            paymentFlowInfo.setSelectOrgId(paymentFlowInfoReqBO.getCompanyId());
        }
        if (ProfessionalOrg.SUPPLIER.getCode().equals(paymentFlowInfoReqBO.getIsProfessionalOrgExt())) {
            paymentFlowInfo.setSelectOrgId(paymentFlowInfoReqBO.getSupId());
        }
        if ("1".equals(paymentFlowInfoReqBO.getMemUserType())) {
            paymentFlowInfo.setCreateUserId(paymentFlowInfoReqBO.getUserId());
        }
        if (StrUtil.isNotBlank((CharSequence)paymentFlowInfoReqBO.getOrderCodeOrChildOrderCode())) {
            paymentFlowInfo.setOrderCodeOrChildOrderCodeLike(paymentFlowInfoReqBO.getOrderCodeOrChildOrderCode());
        }
        if ((paymentFlowInfos = this.paymentFlowInfoMapper.qryPaymentFlowList(paymentFlowInfo, (Page<Map<String, Object>>)(page = new Page(paymentFlowInfoReqBO.getPageNo().intValue(), paymentFlowInfoReqBO.getPageSize().intValue())))) != null && paymentFlowInfos.size() > 0) {
            List<SaleOrderInfo> saleOrderInfos;
            ArrayList<String> orderCodes = new ArrayList<String>();
            for (PaymentFlowInfo paymentFlowInfoPO : paymentFlowInfos) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)paymentFlowInfoPO.getOrderCode())) continue;
                orderCodes.add(paymentFlowInfoPO.getOrderCode());
            }
            HashMap<String, SaleOrderInfo> maps = new HashMap<String, SaleOrderInfo>();
            if (orderCodes.size() > 0 && (saleOrderInfos = this.saleOrderInfoMapper.getListBySaleCode(orderCodes)) != null && saleOrderInfos.size() > 0) {
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    maps.put(saleOrderInfo.getSaleOrderCode(), saleOrderInfo);
                }
            }
            ArrayList<PaymentFlowInfoRspBO> payFlows = new ArrayList<PaymentFlowInfoRspBO>();
            for (PaymentFlowInfo paymentFlowInfoPO : paymentFlowInfos) {
                String applyNo;
                PaymentFlowInfoRspBO paymentFlowInfoRspBO = new PaymentFlowInfoRspBO();
                BeanUtils.copyProperties((Object)paymentFlowInfoPO, (Object)paymentFlowInfoRspBO);
                paymentFlowInfoRspBO.setOrderApplyNo(paymentFlowInfoPO.getApplyNo());
                if (paymentFlowInfoPO.getFlowFlag() != null && !"".equals(paymentFlowInfoPO.getPayType())) {
                    paymentFlowInfoRspBO.setFlowFlagStr(FlowFlag.getInstance(paymentFlowInfoPO.getFlowFlag()).getDescr());
                }
                if (paymentFlowInfoPO.getFlowType() != null) {
                    paymentFlowInfoRspBO.setFlowTypeStr(FlowType.getInstance(paymentFlowInfoPO.getFlowType().toString()).getDescr());
                }
                if (paymentFlowInfoPO.getPayType() != null && !"".equals(paymentFlowInfoPO.getPayType())) {
                    paymentFlowInfoRspBO.setPayTypeStr(PayFlowPayType.getInstance(paymentFlowInfoPO.getPayType()).getDescr());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)paymentFlowInfoPO.getPayChannel()) && null != PayChannel.getInstance(paymentFlowInfoPO.getPayChannel())) {
                    paymentFlowInfoRspBO.setPayChannelStr(PayChannel.getInstance(paymentFlowInfoPO.getPayChannel()).getDescr());
                    if (PayChannel.PAY_OFFLINE.getCode().equals(paymentFlowInfoPO.getPayChannel()) || PayChannel.OFFLINE.getCode().equals(paymentFlowInfoPO.getPayChannel())) {
                        paymentFlowInfoRspBO.setPayTypeStr(PayChannel.PAY_OFFLINE.getDescr());
                    }
                }
                if (null != paymentFlowInfoPO.getReturnOutOrderId()) {
                    if (null != paymentFlowInfoPO.getPaymentStatus() && paymentFlowInfoPO.getPaymentStatus().equals(SUCCESS)) {
                        paymentFlowInfoRspBO.setRefundStatusStr("\u9000\u6b3e\u6210\u529f");
                    }
                    if (null != paymentFlowInfoPO.getPaymentStatus() && paymentFlowInfoPO.getPaymentStatus().equals(FAIL)) {
                        paymentFlowInfoRspBO.setRefundStatusStr("\u9000\u6b3e\u5931\u8d25");
                    }
                }
                if (paymentFlowInfoPO.getOrderCode() != null && maps.get(paymentFlowInfoPO.getOrderCode()) != null) {
                    paymentFlowInfoRspBO.setOrderId(((SaleOrderInfo)maps.get(paymentFlowInfoPO.getOrderCode())).getOrderId());
                    paymentFlowInfoRspBO.setPurchaseOrderId(((SaleOrderInfo)maps.get(paymentFlowInfoPO.getOrderCode())).getPurchaseOrderId());
                }
                if (FlowFlag.ORDER_PAY.getCode().equals(paymentFlowInfoPO.getFlowFlag()) || FlowFlag.PAYABLE_PAY.getCode().equals(paymentFlowInfoPO.getFlowFlag())) {
                    String outOrderId = paymentFlowInfoPO.getOutOrderId();
                    applyNo = outOrderId.substring(outOrderId.indexOf("-") + 1, outOrderId.length());
                    paymentFlowInfoRspBO.setApplyNo(applyNo);
                } else if (FlowFlag.ERP_PAY.getCode().equals(paymentFlowInfoPO.getFlowFlag())) {
                    paymentFlowInfoRspBO.setApplyNo(paymentFlowInfoPO.getOutOrderId());
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)paymentFlowInfoPO.getReturnOutOrderId())) {
                    String returnOutOrderId = paymentFlowInfoPO.getReturnOutOrderId();
                    applyNo = returnOutOrderId.substring(returnOutOrderId.indexOf("-") + 1, returnOutOrderId.length());
                    if (applyNo.startsWith("CG")) {
                        ApplyDetail applyDetail = this.applyDetailMapper.selectByPayableNo(applyNo);
                        if (applyDetail != null) {
                            paymentFlowInfoRspBO.setApplyNo(applyDetail.getApplyNo());
                        }
                    } else {
                        paymentFlowInfoRspBO.setApplyNo(applyNo);
                    }
                }
                String notificationNo = paymentFlowInfoRspBO.getNotificationNo();
                String orderApplyNo = paymentFlowInfoRspBO.getOrderApplyNo();
                paymentFlowInfoRspBO.setExportApplyAndNotiNo((StringUtils.hasText((String)notificationNo) ? notificationNo : "") + (StringUtils.hasText((String)orderApplyNo) ? orderApplyNo : ""));
                paymentFlowInfoRspBO.setExportOrderCode(this.dealSubExportOrderCode(paymentFlowInfoRspBO.getOrderCode()));
                paymentFlowInfoRspBO.setExportChildOrderCode(this.dealSubExportOrderCode(paymentFlowInfoRspBO.getChildOrderCode()));
                payFlows.add(paymentFlowInfoRspBO);
            }
            rspBO.setRows(payFlows);
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"listPagePaymentFlowInfo"})
    public FscPaymentFlowInfoAbilityRspBO listPagePaymentFlowInfo(@RequestBody FscPaymentFlowInfoAbilityReqBO reqBo) {
        FscPaymentFlowInfoAbilityRspBO rspBo = FscRu.success(FscPaymentFlowInfoAbilityRspBO.class);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setTotal(Integer.valueOf(0));
        rspBo.setRows(new ArrayList());
        List permission = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(permission)) {
            rspBo.setRespDesc("\u89d2\u8272\u4e3a\u7a7a");
            return rspBo;
        }
        Long selectOrgId = null;
        if (StrUtil.isBlank((CharSequence)reqBo.getIsProfessionalOrgExt())) {
            rspBo.setRespDesc("\u5f53\u524d\u767b\u9646\u8d26\u53f7\u673a\u6784\u5f52\u5c5e\u4e3a\u7a7a");
            return rspBo;
        }
        if (ProfessionalOrg.SUPPLIER.getCode().equals(reqBo.getIsProfessionalOrgExt())) {
            if (reqBo.getSupId() == null) {
                rspBo.setRespDesc("\u5f53\u524d\u767b\u9646\u8d26\u53f7\u4f9b\u5e94\u5546ID\u4e3a\u7a7a");
                return rspBo;
            }
            selectOrgId = reqBo.getSupId();
        } else if (ProfessionalOrg.PURCHASE.getCode().equals(reqBo.getIsProfessionalOrgExt())) {
            selectOrgId = reqBo.getCompanyId();
        }
        PaymentFlowInfo paymentFlowInfoQry = new PaymentFlowInfo();
        paymentFlowInfoQry.setFlowFlagQuery(reqBo.getFlowFlag());
        paymentFlowInfoQry.setOrderCodeOrChildOrderCodeLike(reqBo.getOrderCodeOrChildOrderCode());
        paymentFlowInfoQry.setApplyNoLike(reqBo.getApplyNo());
        paymentFlowInfoQry.setNotificationNoLike(reqBo.getNotificationNo());
        paymentFlowInfoQry.setPayApplyNoLike(reqBo.getOutOrderId());
        paymentFlowInfoQry.setPayNameLike(reqBo.getPayName());
        paymentFlowInfoQry.setRecNameLike(reqBo.getRecName());
        paymentFlowInfoQry.setPaymentFlowId(reqBo.getPaymentFlowId());
        paymentFlowInfoQry.setCreateUserName(reqBo.getCreateUserName());
        if (FlowFlag.ORDER_PAY.getCode().equals(reqBo.getFlowFlag())) {
            paymentFlowInfoQry.setFlowFlagListQuery(Stream.of(FlowFlag.ORDER_PAY.getCode(), FlowFlag.CNERP_PAY.getCode()).collect(Collectors.toList()));
        } else if (FlowFlag.ORDER_REIMBURSE.getCode().equals(reqBo.getFlowFlag())) {
            paymentFlowInfoQry.setFlowFlagListQuery(Stream.of(FlowFlag.ORDER_REIMBURSE.getCode(), FlowFlag.CNERP_REFUND.getCode()).collect(Collectors.toList()));
        } else {
            paymentFlowInfoQry.setFlowFlagQuery(reqBo.getFlowFlag());
        }
        paymentFlowInfoQry.setPayChannel(reqBo.getPayChannel());
        paymentFlowInfoQry.setFlowType(reqBo.getFlowType());
        List<String> proRoles = Arrays.asList(this.FSC_AUTH_SYSTEM_MANAGE, this.FSC_AUTH_PRO_SETTLEMENT_POSITION, this.FSC_AUTH_PRO_CUSTOMER_SERVICE_OPERATION_POSITION);
        List<String> purRoles = Arrays.asList(this.FSC_AUTH_ORG_MANAGER, this.FSC_AUTH_PUR_ENTERPRISE_FINANCIAL_PAYMENT_POSITION);
        List<String> userRoles = Collections.singletonList(this.FSC_AUTH_PUR_COMPANY_BUYER);
        if (permission.stream().anyMatch(proRoles::contains)) {
            log.info("\u7cfb\u7edf\u7ba1\u7406\u5458\u3001\u4e2d\u6838\u8fd0\u8425\u673a\u6784\u8fd0\u8425\u7ed3\u7b97\u5c97\u3001\u4e2d\u6838\u8fd0\u8425\u673a\u6784\u5ba2\u670d\u8fd0\u8425\u5c97\u770b\u5168\u90e8");
        } else if (permission.stream().anyMatch(purRoles::contains)) {
            paymentFlowInfoQry.setSelectOrgId(selectOrgId);
            paymentFlowInfoQry.setSelectOrdPurOrgId(reqBo.getCompanyId());
        } else if (permission.stream().anyMatch(userRoles::contains)) {
            paymentFlowInfoQry.setOrdPurchaserIdQuery(Optional.ofNullable(reqBo.getUserId()).map(String::valueOf).orElse(null));
        } else if (ProfessionalOrg.SUPPLIER.getCode().equals(reqBo.getIsProfessionalOrgExt())) {
            paymentFlowInfoQry.setSelectOrgId(reqBo.getSupId());
        } else {
            rspBo.setRespDesc("\u6ca1\u6709\u67e5\u770b\u6743\u9650");
            return rspBo;
        }
        if ("1".equals(reqBo.getMemUserType())) {
            paymentFlowInfoQry.setOrdPurchaserIdQuery(Optional.ofNullable(reqBo.getUserId()).map(String::valueOf).orElse(null));
        }
        paymentFlowInfoQry.setOrderBy(" CREATE_TIME desc ");
        log.info("\u5206\u9875\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)JSON.toJSONString((Object)paymentFlowInfoQry));
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<PaymentFlowInfo> paymentFlowInfos = this.paymentFlowInfoMapper.getListPage(paymentFlowInfoQry, (Page<PaymentFlowInfo>)page);
        if (CollectionUtils.isEmpty(paymentFlowInfos)) {
            rspBo.setRespDesc("\u67e5\u8be2\u4e3a\u7a7a");
            return rspBo;
        }
        ArrayList<FscPaymentFlowInfoBO> rowList = new ArrayList<FscPaymentFlowInfoBO>();
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBo.setRows(rowList);
        Map<Long, String> mapFlowFlagStr = this.buildFlowFlagDescriptionMap(paymentFlowInfos);
        Map<Long, ActivitiesBO> mapActivity = this.buildCnerpActivityMap(paymentFlowInfos);
        Map<Long, UocInspectionOrderInfoQryInfoBO> mapInspectionOrder = this.buildInspectionOrderMap(paymentFlowInfos);
        for (PaymentFlowInfo paymentFlowInfo : paymentFlowInfos) {
            FscPaymentFlowInfoBO row = FscRu.js(paymentFlowInfo, FscPaymentFlowInfoBO.class);
            row.setOrderApplyNo(paymentFlowInfo.getApplyNo());
            row.setFlowFlagStr(Optional.ofNullable(mapFlowFlagStr.get(paymentFlowInfo.getSeq())).orElse(FlowFlag.desc(paymentFlowInfo.getFlowFlag())));
            row.setFlowTypeStr(Optional.ofNullable(paymentFlowInfo.getFlowType()).map(String::valueOf).map(FlowType::desc).orElse(""));
            row.setPayTypeStr(PayFlowPayType.desc(paymentFlowInfo.getPayType()));
            row.setPayChannelStr(PayChannel.desc(paymentFlowInfo.getPayChannel()));
            if (Arrays.asList(PayChannel.PAY_OFFLINE.getCode(), PayChannel.OFFLINE.getCode()).contains(paymentFlowInfo.getPayChannel())) {
                row.setPayTypeStr(PayChannel.PAY_OFFLINE.getDescr());
            }
            row.setRefundStatusStr(this.setRefundStatusStr(paymentFlowInfo));
            String notificationNo = paymentFlowInfo.getNotificationNo();
            String orderApplyNo = paymentFlowInfo.getApplyNo();
            row.setExportApplyAndNotiNo((StrUtil.isNotBlank((CharSequence)notificationNo) ? notificationNo : "") + (StrUtil.isNotBlank((CharSequence)orderApplyNo) ? orderApplyNo : ""));
            row.setExportOrderCode(this.dealSubExportOrderCode(paymentFlowInfo.getOrderCode()));
            row.setExportChildOrderCode(this.dealSubExportOrderCode(paymentFlowInfo.getChildOrderCode()));
            if (paymentFlowInfo.getActivityId() != null && mapActivity.containsKey(paymentFlowInfo.getActivityId())) {
                row.setActivityId(paymentFlowInfo.getActivityId());
                row.setActivityNo(mapActivity.get(paymentFlowInfo.getActivityId()).getActiveCode());
                row.setActivityName(mapActivity.get(paymentFlowInfo.getActivityId()).getAccountName());
            }
            if (paymentFlowInfo.getInspectionId() != null && mapInspectionOrder.containsKey(paymentFlowInfo.getInspectionId())) {
                UocInspectionOrderInfoQryInfoBO infoBo = mapInspectionOrder.get(paymentFlowInfo.getInspectionId());
                row.setActivityNo(infoBo.getCouponGranter());
                row.setActivityName(infoBo.getCouponName());
                row.setInspectionCode(infoBo.getInspectionVoucherCode());
            }
            row.setPayDetailFlag("3");
            if (Arrays.asList(FlowFlag.BILL_SYS_PAY.getCode(), FlowFlag.BILL_SYS_REFUND.getCode()).contains(paymentFlowInfo.getFlowFlag())) {
                String billSysUrl = this.FSC_BILL_SYSTEM_PAYMENT_INFO_URL + row.getPayApplyNo();
                row.setPayDetailFlag("1");
                row.setPayDetailUrl(billSysUrl);
            } else if (Arrays.asList(FlowFlag.CNERP_PAY.getCode(), FlowFlag.CNERP_REFUND.getCode()).contains(paymentFlowInfo.getFlowFlag())) {
                row.setPayDetailFlag("3");
            } else if (FlowFlag.ERP_PAY.getCode().equals(paymentFlowInfo.getFlowFlag())) {
                row.setPayDetailFlag("3");
            } else {
                row.setPayDetailFlag("2");
            }
            rowList.add(row);
        }
        return rspBo;
    }

    private Map<Long, UocInspectionOrderInfoQryInfoBO> buildInspectionOrderMap(List<PaymentFlowInfo> paymentFlowInfos) {
        HashMap<Long, UocInspectionOrderInfoQryInfoBO> mapInspectionOrder = new HashMap<Long, UocInspectionOrderInfoQryInfoBO>();
        if (CollectionUtils.isEmpty(paymentFlowInfos)) {
            return mapInspectionOrder;
        }
        List inspectionIds = paymentFlowInfos.stream().map(PaymentFlowInfo::getInspectionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inspectionIds)) {
            return mapInspectionOrder;
        }
        for (List subIds : ListUtil.batchList(inspectionIds)) {
            if (CollectionUtils.isEmpty((Collection)subIds)) continue;
            UocInspectionOrderInfoQryAbilityReqBO uocReqBo = new UocInspectionOrderInfoQryAbilityReqBO();
            uocReqBo.setInspectionVoucherIdList(subIds);
            UocInspectionOrderInfoQryAbilityRspBO uocRspBo = this.uocInspectionOrderInfoQryAbilityService.listInspectionOrderInfo(uocReqBo);
            log.debug("\u8ba2\u5355\u67e5\u8be2\u7ed3\u679c:code:{}.message:{}", (Object)uocRspBo.getRespCode(), (Object)uocRspBo.getRespDesc());
            if (CollectionUtils.isEmpty((Collection)uocRspBo.getInspectionOrderInfoList())) continue;
            log.debug("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf:{}", (Object)uocRspBo.getInspectionOrderInfoList().size());
            mapInspectionOrder.putAll(uocRspBo.getInspectionOrderInfoList().stream().collect(Collectors.toMap(UocInspectionOrderInfoQryInfoBO::getInspectionVoucherId, Function.identity(), (c, n) -> c)));
        }
        return mapInspectionOrder;
    }

    private Map<Long, ActivitiesBO> buildCnerpActivityMap(List<PaymentFlowInfo> paymentFlowInfos) {
        HashMap<Long, ActivitiesBO> mapActivity = new HashMap<Long, ActivitiesBO>();
        if (CollectionUtils.isEmpty(paymentFlowInfos)) {
            return mapActivity;
        }
        List activityIdList = paymentFlowInfos.stream().filter(i -> Arrays.asList(FlowFlag.CNERP_PAY.getCode(), FlowFlag.CNERP_REFUND.getCode()).contains(i.getFlowFlag()) && i.getActivityId() != null).map(PaymentFlowInfo::getActivityId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityIdList)) {
            return mapActivity;
        }
        HashMap mapAct = new HashMap();
        for (List subActIds : ListUtil.batchList(activityIdList)) {
            if (CollectionUtils.isEmpty((Collection)subActIds)) continue;
            ActQryActiveListAbilityReqBO actReqBo = new ActQryActiveListAbilityReqBO();
            actReqBo.setActiveIds(subActIds);
            log.debug("\u6d3b\u52a8\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)actReqBo));
            ActQryActiveListAbilityRspBO actRspBo = this.actQryActiveListAbilityService.qryActiveList(actReqBo);
            log.debug("\u6d3b\u52a8\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)actRspBo));
            if (FscRu.isFailed(actRspBo.getRespCode()).booleanValue()) {
                return mapActivity;
            }
            List activitiesBOList = actRspBo.getRows();
            if (CollectionUtils.isEmpty((Collection)activitiesBOList)) continue;
            mapAct.putAll(activitiesBOList.stream().collect(Collectors.toMap(ActivitiesBO::getActiveId, Function.identity(), (c, n) -> c)));
        }
        for (PaymentFlowInfo paymentFlowInfo : paymentFlowInfos) {
            if (paymentFlowInfo.getActivityId() == null || !mapAct.containsKey(paymentFlowInfo.getActivityId())) continue;
            mapActivity.put(paymentFlowInfo.getSeq(), (ActivitiesBO)mapAct.get(paymentFlowInfo.getActivityId()));
        }
        return mapActivity;
    }

    private Map<Long, String> buildFlowFlagDescriptionMap(List<PaymentFlowInfo> paymentFlowInfos) {
        HashMap<Long, String> mapFlowFlagStr = new HashMap<Long, String>();
        if (CollectionUtils.isEmpty(paymentFlowInfos)) {
            return mapFlowFlagStr;
        }
        ArrayList<FscPaymentFlowInfoDetailPO> detailList = new ArrayList<FscPaymentFlowInfoDetailPO>();
        List flowIdList = paymentFlowInfos.stream().map(PaymentFlowInfo::getSeq).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        for (List subIdList : ListUtil.batchList(flowIdList)) {
            if (CollectionUtils.isEmpty((Collection)subIdList)) continue;
            FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetailQry = new FscPaymentFlowInfoDetailPO();
            fscPaymentFlowInfoDetailQry.setFlowIdIn(subIdList);
            List<FscPaymentFlowInfoDetailPO> subList = this.fscPaymentFlowInfoDetailMapper.getList(fscPaymentFlowInfoDetailQry);
            if (CollectionUtils.isEmpty(subList)) continue;
            detailList.addAll(subList);
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            mapFlowFlagStr.putAll(detailList.stream().filter(i -> i.getFlowId() != null && StrUtil.isNotBlank((CharSequence)FlowFlag.desc(i.getFlowFlag()))).collect(Collectors.groupingBy(FscPaymentFlowInfoDetailPO::getFlowId, Collectors.mapping(detail -> FlowFlag.desc(detail.getFlowFlag()), Collectors.collectingAndThen(Collectors.toSet(), item -> String.join((CharSequence)",", item))))));
        }
        return mapFlowFlagStr;
    }

    private String setRefundStatusStr(PaymentFlowInfo paymentFlowInfo) {
        String paymentStatus = paymentFlowInfo.getPaymentStatus();
        if (paymentFlowInfo.getReturnOutOrderId() != null) {
            if (SUCCESS.equals(paymentStatus)) {
                return "\u9000\u6b3e\u6210\u529f";
            }
            if (FAIL.equals(paymentStatus)) {
                return "\u9000\u6b3e\u5931\u8d25";
            }
        }
        return null;
    }

    private String dealSubExportOrderCode(String orderCode) {
        String exportOrderCode = "";
        int EXCEL_MAX_LENGTH = 32000;
        if (StringUtils.hasText((String)orderCode)) {
            String[] split = orderCode.split(",");
            StringJoiner joiner = new StringJoiner(",");
            for (String code : split) {
                if (joiner.length() > EXCEL_MAX_LENGTH) {
                    joiner.add("\u7b49\u5171").add(split.length + "").add("\u4e2a\u8ba2\u5355");
                    break;
                }
                if (!StringUtils.hasText((String)code)) continue;
                joiner.add(code.trim());
            }
            exportOrderCode = joiner.toString();
        }
        return exportOrderCode;
    }
}

