/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.trade.QueryOrderDetailService;
import com.tydic.pfscext.api.trade.bo.InvoiceNameUrlVO;
import com.tydic.pfscext.api.trade.bo.OrderInvoiceVO;
import com.tydic.pfscext.api.trade.bo.QueryOrderDetailReqBO;
import com.tydic.pfscext.api.trade.bo.QueryOrderDetailRspBO;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.BusiModelNew;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.QueryOrderDetailService"})
public class QueryOrderDetailServiceImpl
implements QueryOrderDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryOrderDetailServiceImpl.class);
    @Resource
    PayableDetailMapper payableDetailMapper;
    @Resource
    PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Resource
    PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    @PostMapping(value={"getFscOrderDetail"})
    public QueryOrderDetailRspBO getFscOrderDetail(@RequestBody QueryOrderDetailReqBO reqBO) {
        QueryOrderDetailRspBO rspBO = new QueryOrderDetailRspBO();
        logger.info("\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getIsOtherOrder())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getBusiModel())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8ba2\u5355\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        ArrayList<OrderInvoiceVO> orderInvoiceList = new ArrayList<OrderInvoiceVO>();
        if (BusiModel.MATCH_UP_MODEL.getCode().equals(reqBO.getBusiModel())) {
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByOrderId(Long.valueOf(reqBO.getOrderId()));
            if (CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u65e0\u6b64\u8ba2\u5355");
            }
            rspBO.setOrderCode(payPurchaseOrderInfoList.get(0).getPurchaseOrderCode());
            rspBO.setBusiModel(payPurchaseOrderInfoList.get(0).getBusiModel());
            rspBO.setBusiModelStr(BusiModelNew.getInstance((String)rspBO.getBusiModel()).getDescr());
            if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
                for (PayPurchaseOrderInfo orderInfo : payPurchaseOrderInfoList) {
                    OrderInvoiceVO vo = new OrderInvoiceVO();
                    BeanUtils.copyProperties((Object)orderInfo, (Object)vo);
                    vo.setOrderCode(orderInfo.getPurchaseOrderCode());
                    vo.setOrderStatusStr(OrderStatus.getInstance(orderInfo.getOrderStatus()).getDescr());
                    vo.setReconciliationStatusStr(ReconciliationStatus.getInstance(orderInfo.getReconciliationStatus()).getDescr());
                    if (!StringUtils.isEmpty((Object)orderInfo.getNotificationNo())) {
                        vo.setNotificationNo(orderInfo.getNotificationNo());
                        List<InvoiceNameUrlVO> invoiceList = this.payInvoiceInfoMapper.getInvoiceInfoByNotificationNo(orderInfo.getNotificationNo());
                        if (!CollectionUtils.isEmpty(invoiceList)) {
                            vo.setInvoiceList(invoiceList);
                        }
                    }
                    orderInvoiceList.add(vo);
                }
            }
        } else {
            SaleOrderInfoVO vo1 = new SaleOrderInfoVO();
            vo1.setOrderId(Long.valueOf(reqBO.getOrderId()));
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(vo1);
            if (CollectionUtils.isEmpty(saleOrderInfoList)) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u65e0\u6b64\u8ba2\u5355");
            }
            rspBO.setOrderCode(saleOrderInfoList.get(0).getSaleOrderCode());
            rspBO.setBusiModel(saleOrderInfoList.get(0).getBusiModel());
            rspBO.setBusiModelStr(BusiModelNew.getInstance((String)rspBO.getBusiModel()).getDescr());
            for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                OrderInvoiceVO vo = new OrderInvoiceVO();
                BeanUtils.copyProperties((Object)orderInfo, (Object)vo);
                vo.setOrderCode(orderInfo.getSaleOrderCode());
                vo.setOrderStatusStr(OrderStatus.getInstance(orderInfo.getOrderStatus()).getDescr());
                vo.setReconciliationStatusStr(ReconciliationStatus.getInstance(orderInfo.getReconciliationStatus()).getDescr());
                if (!StringUtils.isEmpty((Object)orderInfo.getApplyNo())) {
                    vo.setApplyNo(orderInfo.getApplyNo());
                    List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectByApplyNo(orderInfo.getApplyNo());
                    if (!CollectionUtils.isEmpty(saleInvoiceInfos)) {
                        ArrayList<InvoiceNameUrlVO> invoiceNameUrlVOS = new ArrayList<InvoiceNameUrlVO>();
                        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                            InvoiceNameUrlVO invoiceNameUrlVO = new InvoiceNameUrlVO();
                            invoiceNameUrlVO.setInvoiceName(saleInvoiceInfo.getElectronicInvoiceName());
                            invoiceNameUrlVO.setInvoiceUrl(saleInvoiceInfo.getElectronicInvoiceUrl());
                            invoiceNameUrlVOS.add(invoiceNameUrlVO);
                        }
                        vo.setInvoiceList(invoiceNameUrlVOS);
                    }
                }
                orderInvoiceList.add(vo);
            }
        }
        if (!CollectionUtils.isEmpty(orderInvoiceList)) {
            rspBO.setOrderInvoiceList(orderInvoiceList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        return rspBO;
    }
}

