/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import cn.hutool.core.util.StrUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.trade.UpdateOverduePenaltyService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.ListUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.UpdateOverduePenaltyService"})
public class UpdateOverduePenaltyServiceImpl
implements UpdateOverduePenaltyService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateOverduePenaltyServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    @PostMapping(value={"updateDetails"})
    public PfscExtRspBaseBO updateDetails(@RequestBody QueryPayableDetailReqBO querypayableDetailReqBO) {
        logger.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u5ba1\u6838\u5165\u53c2\uff1a" + JSON.toJSONString((Object)querypayableDetailReqBO));
        if (querypayableDetailReqBO.getPayableNos() == null || querypayableDetailReqBO.getPayableNos().size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5e94\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (querypayableDetailReqBO.getApproveStatus() == null) {
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
        }
        PfscExtRspBaseBO repBO = new PfscExtRspBaseBO();
        try {
            if (!"1".equals(querypayableDetailReqBO.getIsProfessionalOrgExt())) {
                PayableDetailPO detail = new PayableDetailPO();
                detail.setPayableNos(querypayableDetailReqBO.getPayableNos());
                List<PayableDetailPO> overdueList = this.payableDetailMapper.getOverdueListPage(detail, (Page<Map<String, Object>>)new Page(), null);
                if (CollectionUtils.isEmpty(overdueList)) {
                    repBO.setRespCode("18000");
                    repBO.setRespDesc("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
                    return repBO;
                }
                for (PayableDetailPO payableDetailPO : overdueList) {
                    if (payableDetailPO == null || "0".equals(payableDetailPO.getApproveStatus().toString())) continue;
                    logger.error(payableDetailPO.getPayableNo() + "\u5e94\u4ed8\u5355\u5ba1\u6838\u72b6\u6001\u9519\u8bef");
                    throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u5ba1\u6838\u72b6\u6001\u9519\u8bef");
                }
            } else {
                List payableNos = querypayableDetailReqBO.getPayableNos().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(payableNos)) {
                    throw new PfscExtBusinessException("18000", "\u7533\u8bf7\u51cf\u514d\u903e\u671f\u8fdd\u7ea6\u91d1\u5931\u8d25,\u5e94\u4ed8\u5355\u53f7\u5168\u4e3a\u7a7a");
                }
                for (List subList : ListUtil.batchList(payableNos)) {
                    List<PayableDetailPO> payableDetailPos;
                    if (CollectionUtils.isEmpty((Collection)subList) || CollectionUtils.isEmpty(payableDetailPos = this.payableDetailMapper.getListByIds(subList))) continue;
                    for (PayableDetailPO payableDetailPo : payableDetailPos) {
                        if (payableDetailPo.getOverduePenalty() == null || BigDecimal.ZERO.compareTo(payableDetailPo.getOverduePenalty()) >= 0) {
                            throw new PfscExtBusinessException("18000", StrUtil.format((CharSequence)"\u7533\u8bf7\u51cf\u514d\u903e\u671f\u8fdd\u7ea6\u91d1\u5931\u8d25,\u5e94\u4ed8\u5355[{}]\u8fdd\u7ea6\u91d1\u9700\u5927\u4e8e0", (Object[])new Object[]{payableDetailPo.getPayableNo()}));
                        }
                        Integer payableType = payableDetailPo.getPayableType();
                        if (payableType == null) {
                            throw new PfscExtBusinessException("18000", StrUtil.format((CharSequence)"\u7533\u8bf7\u51cf\u514d\u903e\u671f\u8fdd\u7ea6\u91d1\u5931\u8d25,\u5e94\u4ed8\u5355[{}]\u5e94\u4ed8\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[]{payableDetailPo.getPayableNo()}));
                        }
                        if (Arrays.asList(PayableType.APPLY.getCode(), PayableType.EXPIRE.getCode()).contains(payableDetailPo.getPayableType().toString())) continue;
                        throw new PfscExtBusinessException("18000", StrUtil.format((CharSequence)"\u7533\u8bf7\u51cf\u514d\u903e\u671f\u8fdd\u7ea6\u91d1\u5931\u8d25,\u5e94\u4ed8\u5355[{}]\u7684\u5e94\u4ed8\u7c7b\u578b\u4e0d\u4e3a[\u8d26\u671f\u652f\u4ed8]\u548c[\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8],\u4e0d\u53ef\u7533\u8bf7\u51cf\u514d\u903e\u671f\u8fdd\u7ea6\u91d1", (Object[])new Object[]{payableDetailPo.getPayableNo()}));
                    }
                }
            }
            PayableDetailVO payableDetailPO = new PayableDetailVO();
            BeanUtils.copyProperties((Object)querypayableDetailReqBO, (Object)payableDetailPO);
            if (querypayableDetailReqBO.getApproveStatus() == 0) {
                payableDetailPO.setOverduePersonId(querypayableDetailReqBO.getUserId());
                payableDetailPO.setOverduePersonName(querypayableDetailReqBO.getName());
                payableDetailPO.setOverdueTime(new Date());
            } else if (querypayableDetailReqBO.getApproveStatus() == 1) {
                payableDetailPO.setApproveTime(new Date());
                payableDetailPO.setApproveUserId(querypayableDetailReqBO.getUserId() + "");
                payableDetailPO.setApproveUserName(querypayableDetailReqBO.getName());
            }
            this.payableDetailMapper.updateByNOsBatch(querypayableDetailReqBO.getPayableNos(), payableDetailPO);
            repBO.setRespCode("0000");
            repBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u903e\u671f\u91d1\u989d\u5ba1\u6279\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        return repBO;
    }
}

