/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.github.pagehelper.util.StringUtil;
import com.ohaotian.authority.user.service.SelectByOrgAndRoleWebService;
import com.tydic.pfscext.api.zm.ChangeOfReceiptInitiateService;
import com.tydic.pfscext.api.zm.bo.ChangOfReceiptItemBO;
import com.tydic.pfscext.api.zm.bo.ChangeOfReceiptInitiateBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.AfterSaleDetailMapper;
import com.tydic.pfscext.dao.AfterSaleMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderItemInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.ChangeOrderInfoPO;
import com.tydic.pfscext.dao.po.ChangeOrderItemInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.SequenceNoService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ChangeOfReceiptInitiateService"})
public class ChangeOfReceiptInitiateServiceImpl
implements ChangeOfReceiptInitiateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeOfReceiptInitiateServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private AfterSaleMapper afterSaleMapper;
    @Autowired
    private SequenceNoService publicSeqNoService;
    @Autowired
    private AfterSaleDetailMapper afterSaleDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private ChangeOrderInfoMapper changeOrderInfoMapper;
    @Autowired
    private ChangeOrderItemInfoMapper changeOrderItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SelectByOrgAndRoleWebService selectByOrgAndRoleWebService;

    @Transactional
    @PostMapping(value={"changeOfReceipt"})
    public PfscExtRspBaseBO changeOfReceipt(@RequestBody ChangeOfReceiptInitiateBO changeOfReceiptInitiateBO) {
        LOGGER.debug("\u5f02\u5e38\u8ba2\u5355\u53d8\u66f4\u5165\u53c2\uff1a" + changeOfReceiptInitiateBO.toString());
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setSaleOrderCode(changeOfReceiptInitiateBO.getOrderCode());
            saleOrderInfo.setInspectionIds(changeOfReceiptInitiateBO.getInspectionIds());
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getModelByOrderCode(saleOrderInfo);
            if (!CollectionUtils.isEmpty(saleOrderInfoList)) {
                for (SaleOrderInfo saleOrderInfo1 : saleOrderInfoList) {
                    PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                    payPurchaseOrderInfo.setPurchaseOrderCode(changeOfReceiptInitiateBO.getOrderCode());
                    payPurchaseOrderInfo.setInspectionId(saleOrderInfo1.getInspectionId());
                    PayPurchaseOrderInfo payPurchaseOrderInfo1 = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
                    ChangeOrderInfoPO changeOrderInfoPO = new ChangeOrderInfoPO();
                    BeanUtils.copyProperties((Object)changeOfReceiptInitiateBO, (Object)changeOrderInfoPO);
                    changeOrderInfoPO.setSaleOrderCode(saleOrderInfo1.getSaleOrderCode());
                    changeOrderInfoPO.setChangeDate(new Date());
                    changeOrderInfoPO.setUpdateType("0");
                    this.changeOrderInfoMapper.insertSelective(changeOrderInfoPO);
                    List changOfReceiptItemBOS = changeOfReceiptInitiateBO.getChangOfReceiptItemBOS();
                    if (changOfReceiptItemBOS != null && changOfReceiptItemBOS.size() > 0) {
                        for (ChangOfReceiptItemBO cib : changOfReceiptItemBOS) {
                            ChangeOrderItemInfoPO changeOrderItemInfoPO = new ChangeOrderItemInfoPO();
                            BeanUtils.copyProperties((Object)cib, (Object)changeOrderItemInfoPO);
                            changeOrderItemInfoPO.setInspectionId(saleOrderInfo1.getInspectionId());
                            changeOrderItemInfoPO.setOrderId(saleOrderInfo1.getOrderId());
                            if (StringUtil.isNotEmpty((String)cib.getSaleOrderItemNo())) {
                                changeOrderItemInfoPO.setItemNo(Long.parseLong(cib.getSaleOrderItemNo()));
                            }
                            this.changeOrderItemInfoMapper.insertSelective(changeOrderItemInfoPO);
                        }
                    }
                    if (changeOfReceiptInitiateBO.getIsFlag().equals("0")) {
                        this.updateBillApplyInfo(changeOfReceiptInitiateBO, saleOrderInfo1);
                        if (payPurchaseOrderInfo1 == null) continue;
                        this.updateBillNotificationInfo(changeOfReceiptInitiateBO, payPurchaseOrderInfo1);
                        continue;
                    }
                    this.updateBillApplyInfoRevert(changeOfReceiptInitiateBO, saleOrderInfo1);
                    if (payPurchaseOrderInfo1 == null) continue;
                    this.updateBillNotificationInfoRevert(changeOfReceiptInitiateBO, payPurchaseOrderInfo1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pfscExtRspBaseBO.setRespDesc(e.getMessage());
            pfscExtRspBaseBO.setRespCode("18000");
            return pfscExtRspBaseBO;
        }
        pfscExtRspBaseBO.setRespDesc("\u5f02\u5e38\u8ba2\u5355\u4e0a\u4e0b\u6e38\u53d8\u66f4\u6210\u529f");
        pfscExtRspBaseBO.setRespCode("0000");
        return pfscExtRspBaseBO;
    }

    private void updateBillApplyInfo(ChangeOfReceiptInitiateBO changeOfReceiptBO, SaleOrderInfo saleOrderInfo) {
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleOrderInfo.getApplyNo());
        if (BusiModel.TRADE_MODEL.getCode().equals(changeOfReceiptBO.getBusiModel())) {
            if (billApplyInfo == null && OrderStatus.NO_APPLY.getCode().equals(saleOrderInfo.getOrderStatus())) {
                SaleOrderInfo sif = new SaleOrderInfo();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)sif);
                sif.setOrderStatus(OrderStatus.AFTER_SALE.getCode());
                this.saleOrderInfoMapper.updateByPrimaryKeySelective(sif);
            } else if (null != billApplyInfo) {
                throw new PfscExtBusinessException("18000", "\u8be5\u7b14\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\uff0c\u6682\u4e0d\u652f\u6301\u53d1\u8d77\u5f02\u5e38\u53d8\u66f4\uff01");
            }
        } else if (changeOfReceiptBO.getPayType().equals("03")) {
            // empty if block
        }
    }

    private void updateBillApplyInfoRevert(ChangeOfReceiptInitiateBO changeOfReceiptBO, SaleOrderInfo saleOrderInfo) {
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleOrderInfo.getApplyNo());
        if (BusiModel.TRADE_MODEL.getCode().equals(changeOfReceiptBO.getBusiModel())) {
            if (billApplyInfo == null && OrderStatus.AFTER_SALE.getCode().equals(saleOrderInfo.getOrderStatus())) {
                SaleOrderInfo sif = new SaleOrderInfo();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)sif);
                sif.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.updateByPrimaryKeySelective(sif);
            } else {
                String oldBillStatus = billApplyInfo.getOldBillStatus();
                BillApplyInfo bif = new BillApplyInfo();
                bif.setApplyNo(saleOrderInfo.getApplyNo());
                bif.setRemark("");
                bif.setRedMarkRefund(0);
                bif.setBillStatus(oldBillStatus);
                this.billApplyInfoMapper.updateByPrimaryKeySelective(bif);
            }
        } else if (changeOfReceiptBO.getPayType().equals("03")) {
            // empty if block
        }
    }

    private void updateBillNotificationInfo(ChangeOfReceiptInitiateBO changeOfReceiptBO, PayPurchaseOrderInfo payPurchaseOrderInfo) {
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(payPurchaseOrderInfo.getNotificationNo());
        if (BusiModel.TRADE_MODEL.getCode().equals(changeOfReceiptBO.getBusiModel())) {
            if (billNotificationInfo == null || OrderStatus.NO_APPLY.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
                PayPurchaseOrderInfo payPurchaseOrderInfo1 = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo1.setOrderStatus(OrderStatus.HANGING.getCode());
                payPurchaseOrderInfo1.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo1);
            } else if (null != billNotificationInfo) {
                throw new PfscExtBusinessException("18000", "\u8be5\u7b14\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\uff0c\u6682\u4e0d\u652f\u6301\u53d1\u8d77\u5f02\u5e38\u53d8\u66f4\uff01");
            }
        } else if (billNotificationInfo == null || OrderStatus.NO_APPLY.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
            PayPurchaseOrderInfo payPurchaseOrderInfo1 = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo1.setOrderStatus(OrderStatus.HANGING.getCode());
            payPurchaseOrderInfo1.setInspectionId(payPurchaseOrderInfo.getInspectionId());
            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo1);
        } else if (null != billNotificationInfo) {
            throw new PfscExtBusinessException("18000", "\u8be5\u7b14\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\uff0c\u6682\u4e0d\u652f\u6301\u53d1\u8d77\u5f02\u5e38\u53d8\u66f4\uff01");
        }
    }

    private void updateBillNotificationInfoRevert(ChangeOfReceiptInitiateBO changeOfReceiptBO, PayPurchaseOrderInfo payPurchaseOrderInfo) {
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(payPurchaseOrderInfo.getNotificationNo());
        String oldInvoiceStatus = billNotificationInfo.getOldInvoiceStatus();
        if (billNotificationInfo != null && OrderStatus.HANGING.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
            PayPurchaseOrderInfo payPurchaseOrderInfo1 = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo1.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            payPurchaseOrderInfo1.setInspectionId(payPurchaseOrderInfo.getInspectionId());
            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo1);
        } else {
            BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
            billNotificationInfo1.setInvoiceStatus(oldInvoiceStatus);
            billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
            billNotificationInfo1.setRedMarkRefund(0);
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
        }
    }
}

