/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class PayHcxUtil {
    private static final Logger log = LoggerFactory.getLogger(PayHcxUtil.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CacheClient cacheClient;
    private static final String GRANTTYPE = "client_credentials";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES_IN = "expires_in";
    private static final String HCX_TOKEN = "hcx_token";

    public String getToken(String tokenUrl, String clientId, String clientSecret) {
        log.info("\u8fdb\u5165\u83b7\u53d6getToken\u65b9\u6cd5");
        String token = (String)this.cacheClient.get(HCX_TOKEN);
        if (!StringUtils.isEmpty((Object)token)) {
            return token;
        }
        String body = this.requestToken(tokenUrl, clientId, clientSecret);
        log.info("\u83b7\u53d6\u6838\u8d22\u4fe1token\u8fd4\u56de\u503c\uff1a" + body);
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        token = jsonObject.getString(ACCESS_TOKEN);
        if (token == null) {
            return null;
        }
        String expir = jsonObject.getString(EXPIRES_IN);
        int time = 0;
        try {
            time = Integer.parseInt(expir);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6expires_in\u503c\u5931\u8d25\uff01");
            return null;
        }
        this.cacheClient.set(HCX_TOKEN, (Object)token, time);
        return token;
    }

    public String requestToken(String tokenUrl, String clientId, String clientSecret) {
        log.info("\u8c03\u7528\u5916\u90e8\u670d\u52a1\uff0c\u83b7\u53d6\u6838\u8d22\u4fe1token, clientId:{} ----------- clientSecret:{}", (Object)clientId, (Object)clientSecret);
        String url = tokenUrl + "?grant_type=" + GRANTTYPE;
        HttpHeaders requestHeaders = new HttpHeaders();
        try {
            requestHeaders.add("Authorization", "Basic " + Base64.encodeBase64String((byte[])(clientId + ":" + URLDecoder.decode(clientSecret, "utf-8")).getBytes()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)requestHeaders);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }
}

