/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import com.ohaotian.plugin.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    @Autowired
    private CacheClient cacheClient;

    public boolean getLock(String key, int seconds) {
        try {
            Long count = this.cacheClient.incr(key);
            log.info("redis\u52a0\u9501key:{}.count:{}.seconds{}", new Object[]{key, count, seconds});
            if (count == null) {
                log.error("redis\u52a0\u9501\u5931\u8d25!!!!key:{}.count:{}.seconds{}", new Object[]{key, count, seconds});
                return false;
            }
            long time = this.cacheClient.getExpireTimeByKey(key);
            log.info("redis\u52a0\u9501key:{}.count:{}.time:{}.seconds:{}", new Object[]{count, key, time, seconds});
            if (time == -1L) {
                this.cacheClient.expire(key, seconds);
            }
            return count != 1L;
        }
        catch (Exception e) {
            log.error("redis\u52a0\u9501\u5f02\u5e38" + e.getMessage());
            log.error("redis\u52a0\u9501\u5f02\u5e38", (Throwable)e);
            this.cacheClient.delete(key);
            return false;
        }
    }

    public boolean unLock(String key) {
        try {
            this.cacheClient.delete(key);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u89e3\u9501\u5f02\u5e38" + e.getMessage());
            log.error("redis\u89e3\u9501\u5f02\u5e38", (Throwable)e);
            this.cacheClient.delete(key);
            return false;
        }
    }

    public long getExpireTime(String key) {
        return this.cacheClient.getExpireTimeByKey(key);
    }

    public static class KeyPrefix {
        public static final String FSC_TASK_OUT_PERSON_AUTO_BILL_LOCK = "FSC_TASK_OUT_PERSON_AUTO_BILL_LOCK";
        public static final String FSC_NOTIFICATION_AUTO_SIGN_LOCK = "FSC_NOTIFICATION_AUTO_SIGN_LOCK";
        public static final String FSC_APPLY_AUTO_SIGN_LOCK = "FSC_APPLY_AUTO_SIGN_LOCK";
        public static final String FSC_APPLY_ACT_AUTO_SIGN_LOCK = "FSC_APPLY_ACT_AUTO_SIGN_LOCK";
        public static final String FSC_BILL_SYSTEM_PAYMENT_FLOW_LOCK_PREFIX = "FSC_BILL_SYSTEM_PAYMENT_FLOW_LOCK_PREFIX_";
        public static final String FSC_CNERP_PAYMENT_FLOW_LOCK_PREFIX = "FSC_CNERP_PAYMENT_FLOW_LOCK_PREFIX_";
        public static final String FSC_PAY_CONFIG_EXT_ORG_IMPORT_LOCK_PREFIX = "FSC_PAY_CONFIG_EXT_ORG_IMPORT_LOCK_PREFIX_";
        public static final String FSC_PAY_IMPORT_EXCEPTION_LOCK_PREFIX = "FSC_PAY_IMPORT_EXCEPTION_LOCK_PREFIX_";
    }
}

