/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiSubAcctManageService;
import com.tydic.pfscext.external.api.bo.BusiSubAcctManageReqBO;
import com.tydic.pfscext.external.api.bo.BusiSubAcctManageRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class BusiSubAcctManageServiceImpl
implements BusiSubAcctManageService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSubAcctManageServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private Environment prop;

    @Override
    public BusiSubAcctManageRspBO subAcctManage(BusiSubAcctManageReqBO busiSubAcctManageReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\uff1a" + busiSubAcctManageReqBO.toString());
        }
        if (null == busiSubAcctManageReqBO.getZhuzhanghao()) {
            throw new PfscExternalBusinessException("0001", "\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1-\u4e3b\u8d26\u6237[zhuzhanghao]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String reqStr = this.initReqStr(busiSubAcctManageReqBO);
            String manageSubAcctUrl = this.prop.getProperty("FSC_MANAGE_SUB_ACCT_URL");
            logger.debug(manageSubAcctUrl);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(manageSubAcctUrl), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new PfscExternalBusinessException(null, "\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + manageSubAcctUrl + "]");
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new PfscExternalBusinessException("18001", "\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            }
            BusiSubAcctManageRspBO busiSubAcctManageRspBO = this.resolveRspMsg(returnString);
            return busiSubAcctManageRspBO;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528\u5e73\u5b89-\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((CharSequence)((PfscExternalBusinessException)e).getMsgCode()) ? "18000" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u5e73\u5b89-\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u8c03\u7528\u5e73\u5b89-\u5b50\u8d26\u6237\u7ef4\u62a4\u670d\u52a1\u5931\u8d25");
        }
    }

    private String initReqStr(BusiSubAcctManageReqBO busiSubAcctManageReqBO) {
        try {
            Date now = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String ctime = formatter.format(now);
            StringBuffer reqSb = new StringBuffer();
            reqSb.append("{").append("\"zhuzhanghao\":").append("\"" + busiSubAcctManageReqBO.getZhuzhanghao() + "\"").append(",").append("\"shoukgnm\":").append("\"" + busiSubAcctManageReqBO.getShoukgnm() + "\"").append(",").append("\"zizhsxh\":").append("\"" + busiSubAcctManageReqBO.getZizhsxh() + "\"").append(",").append("\"zizhanghao\":").append("\"" + busiSubAcctManageReqBO.getZizhanghao() + "\"").append(",").append("\"zizhmc\":").append("\"" + busiSubAcctManageReqBO.getZizhmc() + "\"").append(",").append("\"jixibj\":").append("\"" + busiSubAcctManageReqBO.getJixibj() + "\"").append(",").append("\"jixizq\":").append("\"" + busiSubAcctManageReqBO.getJixizq() + "\"").append(",").append("\"jixilv\":").append("\"" + busiSubAcctManageReqBO.getJixilv() + "\"").append(",").append("\"touzhibz\":").append("\"" + busiSubAcctManageReqBO.getTouzhibz() + "\"").append(",").append("\"TRAN_DATE\":").append("\"" + ctime.split("-")[0] + "\"").append(",").append("\"TRAN_TIMESTAMP\":").append("\"" + ctime.split("-")[1] + "\"").append(",").append("\"CONSUMER_SEQ_NO\":").append("\"" + busiSubAcctManageReqBO.getConsumerSeqNo() + "\"").append(",").append("\"beizhu1\":").append("\"" + busiSubAcctManageReqBO.getBeizhu1() + "\"").append(",").append("\"beizhu2\":").append("\"" + busiSubAcctManageReqBO.getBeizhu2() + "\"").append(",").append("\"beizhu3\":").append("\"" + busiSubAcctManageReqBO.getBeizhu3() + "\"").append(",").append("\"beizhu4\":").append("\"" + busiSubAcctManageReqBO.getBeizhu4() + "\"").append(",").append("\"beizhu5\":").append("\"" + busiSubAcctManageReqBO.getBeizhu5() + "\"").append(",").append("\"beizhu6\":").append("\"" + busiSubAcctManageReqBO.getBeizhu6() + "\"").append("}");
            return reqSb.toString();
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u8bf7\u6c42\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u8bf7\u6c42\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
    }

    private BusiSubAcctManageRspBO resolveRspMsg(String returnString) {
        BusiSubAcctManageRspBO rspBO;
        block7: {
            rspBO = new BusiSubAcctManageRspBO();
            rspBO.setRespCode("000002");
            rspBO.setRespDesc("\u672a\u77e5\u9519\u8bef");
            try {
                JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
                JSONObject headJsObj = JSONObject.parseObject((String)rspJsonObject.getString("sys_head"));
                if (headJsObj == null) {
                    rspBO.setRespCode("000001");
                    rspBO.setRespDesc("\u54cd\u5e94\u62a5\u6587\u7ed3\u6784sys_head\u9519\u8bef");
                } else {
                    String retStatus = headJsObj.getString("ret_status");
                    JSONObject headErrJsObj = JSONObject.parseObject((String)headJsObj.getString("ret")).getJSONObject("struct");
                    if (headErrJsObj == null) {
                        rspBO.setRespCode("000001");
                        rspBO.setRespDesc("\u54cd\u5e94\u62a5\u6587\u7ed3\u6784ret-struct\u9519\u8bef");
                    } else {
                        JSONObject bodyJsObj;
                        rspBO.setRespCode(headErrJsObj.getString("ret_code"));
                        rspBO.setRespDesc(headErrJsObj.getString("ret_msg"));
                        if ("S".equals(retStatus) && (bodyJsObj = JSONObject.parseObject((String)rspJsonObject.getString("body"))) != null) {
                            rspBO.setBizhong(bodyJsObj.getString("bizhong"));
                            rspBO.setDanweidm(bodyJsObj.getString("danweidm"));
                            rspBO.setGengxinrq(bodyJsObj.getString("gengxinrq"));
                            rspBO.setJianlirq(bodyJsObj.getString("jianlirq"));
                            rspBO.setJixibz(bodyJsObj.getString("jixibz"));
                            rspBO.setJixlv(bodyJsObj.getString("jixlv"));
                            rspBO.setShoukgnm(bodyJsObj.getString("shoukgnm"));
                            rspBO.setTouzhibz(bodyJsObj.getString("touzhibz"));
                            rspBO.setZhanghumc(bodyJsObj.getString("zhanghumc"));
                            rspBO.setZhujfhdm(bodyJsObj.getString("zhujfhdm"));
                            rspBO.setZhujfhxx(bodyJsObj.getString("zhujfhxx"));
                            rspBO.setZhujfhzt(bodyJsObj.getString("zhujfhzt"));
                            rspBO.setZhuzhanghao(bodyJsObj.getString("zhuzhanghao"));
                            rspBO.setZizhanghao(bodyJsObj.getString("zizhanghao"));
                            rspBO.setZizhanghmc(bodyJsObj.getString("zizhanghmc"));
                            rspBO.setZizhanghzt(bodyJsObj.getString("zizhanghzt"));
                            rspBO.setZizhsxh(bodyJsObj.getString("zizhsxh"));
                        }
                    }
                }
            }
            catch (Exception e) {
                rspBO.setRespCode("000001");
                rspBO.setRespDesc(e.getMessage());
                e.printStackTrace();
                if (!this.isDebugEnabled) break block7;
                logger.debug("\u8c03\u7528\u5e73\u5b89\u5b50\u8d26\u6237\u5212\u8d26\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        return rspBO;
    }
}

