/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.aisino.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.aisino.api.BillDownloadExternalService;
import com.tydic.pfscext.external.aisino.api.bo.BillDownloadExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.BillDownloadExtRspBO;
import com.tydic.pfscext.external.utils.JsonUtils;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BillDownloadExternalServiceImpl
implements BillDownloadExternalService {
    private static final Logger log = LoggerFactory.getLogger(BillDownloadExternalServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BillDownloadExtRspBO billDownloadExternal(BillDownloadExtReqBO reqBO) {
        BillDownloadExtRspBO extRspBO = new BillDownloadExtRspBO();
        String reqEsbStr = this.initReqStr(reqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_BILL_DOWNLOAD_EXTERNAL_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_BILL_DOWNLOAD_EXTERNAL_URL") + "]" + reqEsbStr);
                extRspBO.setRespCode("8888");
                extRspBO.setRespDesc("\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            } else {
                String returnString = httpRetBean.getStr();
                log.error("\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
                this.resolveRspMsg(returnString);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + e);
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return extRspBO;
        }
        return extRspBO;
    }

    private String initReqStr(BillDownloadExtReqBO reqBO) {
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        return reqStr;
    }

    private BillDownloadExtRspBO resolveRspMsg(String returnString) {
        BillDownloadExtRspBO extRspBO = new BillDownloadExtRspBO();
        if (StringUtils.isEmpty((Object)returnString)) {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return extRspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if ("0000".equals((String)jsonObject.get((Object)"returnCode"))) {
            JSONObject rFObject = (JSONObject)jsonObject.get((Object)"REQUEST_FPKJXX_FPJGXX_NEW");
            extRspBO.setDDH(rFObject.getString("DDH"));
            extRspBO.setFPQQLSH(rFObject.getString("FPQQLSH"));
            extRspBO.setKPLSH(rFObject.getString("KPLSH"));
            extRspBO.setFWM(rFObject.getString("FWM"));
            extRspBO.setEWM(rFObject.getString("EWM"));
            extRspBO.setFPZL_DM(rFObject.getString("FPZL_DM"));
            extRspBO.setFP_HM(rFObject.getString("FP_HM"));
            extRspBO.setKPRQ(rFObject.getDate("KPRQ"));
            extRspBO.setKPLX(rFObject.getInteger("KPLX"));
            extRspBO.setHJBHSJE(rFObject.getDouble("HJBHSJE"));
            extRspBO.setKPHJSE(rFObject.getDouble("KPHJSE"));
            extRspBO.setWJLX(rFObject.getString("WJLX"));
            extRspBO.setCZDM(rFObject.getString("CZDM"));
            extRspBO.setPDF_URL(rFObject.getString("PDF_URL"));
            extRspBO.setPDF_FILE(rFObject.getString("PDF_FILE"));
            extRspBO.setRespCode("0000");
            extRspBO.setRespDesc("\u6210\u529f");
            return extRspBO;
        }
        extRspBO.setRespCode((String)jsonObject.get((Object)"returnCode"));
        extRspBO.setRespDesc((String)jsonObject.get((Object)"returnMessage"));
        return extRspBO;
    }
}

