/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.aisino.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.aisino.api.SajtIssueInvoiceExternalService;
import com.tydic.pfscext.external.aisino.api.bo.BuisSajtIssueInvoiceBO;
import com.tydic.pfscext.external.aisino.api.bo.BuisSajtIssueInvoiceDetailsBO;
import com.tydic.pfscext.external.aisino.api.bo.SajtIssueInvoiceExternalReqBO;
import com.tydic.pfscext.external.aisino.api.bo.SajtIssueInvoiceExternalRspBO;
import com.tydic.pfscext.external.utils.JsonUtils;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SajtIssueInvoiceExternalServiceImpl
implements SajtIssueInvoiceExternalService {
    private static final Logger log = LoggerFactory.getLogger(SajtIssueInvoiceExternalServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public SajtIssueInvoiceExternalRspBO sajtIssueInvoiceExternal(SajtIssueInvoiceExternalReqBO sajtIssueInvoiceExternalReqBO) {
        SajtIssueInvoiceExternalRspBO extRspBO = new SajtIssueInvoiceExternalRspBO();
        String reqEsbStr = this.initReqStr(sajtIssueInvoiceExternalReqBO);
        log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + reqEsbStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_PAPER_INVOICE_ISSUE_EXTERNAL_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_PAPER_INVOICE_ISSUE_EXTERNAL_URL") + "]" + reqEsbStr);
                extRspBO.setRespCode("8888");
                extRspBO.setRespDesc("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            } else {
                String returnString = httpRetBean.getStr();
                log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
                BuisSajtIssueInvoiceBO billDownloadExtRspBO = this.resolveRspMsg(returnString);
                if (billDownloadExtRspBO != null) {
                    extRspBO.setRespCode(billDownloadExtRspBO.getRespCode());
                    extRspBO.setRespDesc(billDownloadExtRspBO.getRespDesc());
                    BeanUtils.copyProperties((Object)billDownloadExtRspBO, (Object)extRspBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u8c03\u7528\u5931\u8d25", (Throwable)e);
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return extRspBO;
        }
        return extRspBO;
    }

    private String initReqStr(SajtIssueInvoiceExternalReqBO reqBO) {
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        return reqStr;
    }

    private BuisSajtIssueInvoiceBO resolveRspMsg(String returnString) {
        BuisSajtIssueInvoiceBO extRspBO = new BuisSajtIssueInvoiceBO();
        if (StringUtils.isEmpty((Object)returnString)) {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return extRspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if ("0000".equals((String)jsonObject.get((Object)"returnCode"))) {
            JSONObject rFObject = (JSONObject)jsonObject.get((Object)"content");
            log.error("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25" + rFObject.toString());
            extRspBO.setInvType(Integer.valueOf(rFObject.getString("invType")));
            extRspBO.setCode(rFObject.getString("code"));
            extRspBO.setNr(rFObject.getString("nr"));
            extRspBO.setDocumentNr(rFObject.getString("documentNr"));
            extRspBO.setIssueDate(rFObject.getString("issueDate"));
            if (rFObject.getString("isCanceled") != null) {
                extRspBO.setIsCanceled(Integer.valueOf(rFObject.getString("isCanceled")));
            }
            extRspBO.setEquipmentCode(rFObject.getString("equipmentCode"));
            extRspBO.setTaxCode(rFObject.getString("taxCode"));
            extRspBO.setBranchNr(rFObject.getString("branchNr"));
            extRspBO.setCustomerName(rFObject.getString("customerName"));
            extRspBO.setCustomerTaxNr(rFObject.getString("customerTaxNr"));
            extRspBO.setCustomerAddressTel(rFObject.getString("customerAddressTel"));
            extRspBO.setCustomerBankAccount(rFObject.getString("customerBankAccount"));
            extRspBO.setMemo(rFObject.getString("memo"));
            extRspBO.setSellerAddressTel(rFObject.getString("sellerAddressTel"));
            extRspBO.setSellerBankAccount(rFObject.getString("sellerBankAccount"));
            extRspBO.setIssuer(rFObject.getString("issuer"));
            extRspBO.setChecker(rFObject.getString("checker"));
            if (rFObject.getString("taxDeduction") != null) {
                extRspBO.setTaxDeduction(BigDecimal.valueOf(Long.valueOf(rFObject.getString("taxDeduction"))));
            }
            extRspBO.setGoodsListName(rFObject.getString("goodsListName"));
            ArrayList<BuisSajtIssueInvoiceDetailsBO> items = new ArrayList<BuisSajtIssueInvoiceDetailsBO>();
            JSONArray items1 = (JSONArray)rFObject.get((Object)"items");
            if (items1 != null) {
                for (Object obj : items1) {
                    BuisSajtIssueInvoiceDetailsBO buisSajtIssueInvoiceDetailsBO = new BuisSajtIssueInvoiceDetailsBO();
                    JSONObject fpmxxzXmxx = (JSONObject)obj;
                    if (fpmxxzXmxx.getString("lineType") != null) {
                        buisSajtIssueInvoiceDetailsBO.setLineType(Integer.valueOf(fpmxxzXmxx.getString("lineType")));
                    }
                    buisSajtIssueInvoiceDetailsBO.setProductName(fpmxxzXmxx.getString("productName"));
                    buisSajtIssueInvoiceDetailsBO.setSpec(fpmxxzXmxx.getString("spec"));
                    buisSajtIssueInvoiceDetailsBO.setUnit(fpmxxzXmxx.getString("unit"));
                    if (fpmxxzXmxx.getString("quantity") != null) {
                        buisSajtIssueInvoiceDetailsBO.setQuantity(BigDecimal.valueOf(fpmxxzXmxx.getDouble("quantity")));
                    }
                    if (fpmxxzXmxx.getString("price") != null) {
                        buisSajtIssueInvoiceDetailsBO.setPrice(BigDecimal.valueOf(fpmxxzXmxx.getDouble("price")));
                    }
                    if (fpmxxzXmxx.getString("value") != null) {
                        buisSajtIssueInvoiceDetailsBO.setValue(BigDecimal.valueOf(fpmxxzXmxx.getDouble("value")));
                    }
                    if (fpmxxzXmxx.getString("tax") != null) {
                        buisSajtIssueInvoiceDetailsBO.setTax(BigDecimal.valueOf(fpmxxzXmxx.getDouble("tax")));
                    }
                    if (fpmxxzXmxx.getString("taxRate") != null) {
                        buisSajtIssueInvoiceDetailsBO.setTaxRate(BigDecimal.valueOf(fpmxxzXmxx.getDouble("taxRate")));
                    }
                    buisSajtIssueInvoiceDetailsBO.setGoodsNoVer(fpmxxzXmxx.getString("goodsNoVer"));
                    buisSajtIssueInvoiceDetailsBO.setGoodsTaxNo(fpmxxzXmxx.getString("goodsTaxNo"));
                    buisSajtIssueInvoiceDetailsBO.setTaxPre(fpmxxzXmxx.getString("taxPre"));
                    buisSajtIssueInvoiceDetailsBO.setTaxPreCon(fpmxxzXmxx.getString("taxPreCon"));
                    buisSajtIssueInvoiceDetailsBO.setZeroTax(fpmxxzXmxx.getString("zeroTax"));
                    buisSajtIssueInvoiceDetailsBO.setGoodsNo(fpmxxzXmxx.getString("goodsNo"));
                    items.add(buisSajtIssueInvoiceDetailsBO);
                }
            }
            extRspBO.setItems(items);
            extRspBO.setRespCode("0000");
            extRspBO.setRespDesc((String)jsonObject.get((Object)"message"));
            return extRspBO;
        }
        extRspBO.setRespCode((String)jsonObject.get((Object)"returnCode"));
        extRspBO.setRespDesc((String)jsonObject.get((Object)"message"));
        return extRspBO;
    }
}

