/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiSubAcctTransService;
import com.tydic.pfscext.external.api.bo.BusiSubAcctTransReqBO;
import com.tydic.pfscext.external.api.bo.BusiSubAcctTransRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class BusiSubAcctTransServiceImpl
implements BusiSubAcctTransService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSubAcctTransServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private Environment prop;

    @Override
    public BusiSubAcctTransRspBO subAcctTransfer(BusiSubAcctTransReqBO busiSubAcctTransReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u5165\u53c2\uff1a" + busiSubAcctTransReqBO.toString());
        }
        if (null == busiSubAcctTransReqBO.getZhuzhanghao()) {
            throw new PfscExternalBusinessException("0001", "\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1-\u4e3b\u8d26\u6237[zhuzhanghao]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String reqStr = this.initReqStr(busiSubAcctTransReqBO);
            String transferSubAcctUrl = this.prop.getProperty("FSC_TRANSFER_SUB_ACCT_URL");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(transferSubAcctUrl), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new PfscExternalBusinessException(null, "\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + transferSubAcctUrl + "]");
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new PfscExternalBusinessException("18001", "\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            }
            BusiSubAcctTransRspBO busiSubAcctTransRspBO = this.resolveRspMsg(returnString);
            return busiSubAcctTransRspBO;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5e73\u5b89-\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((CharSequence)((PfscExternalBusinessException)e).getMsgCode()) ? "18000" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u5e73\u5b89-\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u8c03\u7528\u5e73\u5b89-\u5b50\u8d26\u6237\u5212\u8f6c\u670d\u52a1\u5931\u8d25");
        }
    }

    private String initReqStr(BusiSubAcctTransReqBO busiSubAcctTransReqBO) {
        try {
            Date now = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String ctime = formatter.format(now);
            StringBuffer reqSb = new StringBuffer();
            reqSb.append("{").append("\"zhuzhanghao\":").append("\"" + busiSubAcctTransReqBO.getZhuzhanghao() + "\"").append(",").append("\"zhuzhmc\":").append("\"" + busiSubAcctTransReqBO.getZhuzhmc() + "\"").append(",").append("\"tiaozlb\":").append("\"" + busiSubAcctTransReqBO.getTiaozlb() + "\"").append(",").append("\"zhuanczh\":").append("\"" + busiSubAcctTransReqBO.getZhuanczh() + "\"").append(",").append("\"zhuanczhmc\":").append("\"" + busiSubAcctTransReqBO.getZhuanczhmc() + "\"").append(",").append("\"zhuanrzh\":").append("\"" + busiSubAcctTransReqBO.getZhuanrzh() + "\"").append(",").append("\"zhuanrzhmc\":").append("\"" + busiSubAcctTransReqBO.getZhuanrzhmc() + "\"").append(",").append("\"jiaoyije\":").append("\"" + busiSubAcctTransReqBO.getJiaoyije() + "\"").append(",").append("\"zhaiyao\":").append("\"" + busiSubAcctTransReqBO.getZhaiyao() + "\"").append(",").append("\"TRAN_DATE\":").append("\"" + ctime.split("-")[0] + "\"").append(",").append("\"TRAN_TIMESTAMP\":").append("\"" + ctime.split("-")[1] + "\"").append(",").append("\"CONSUMER_SEQ_NO\":").append("\"" + busiSubAcctTransReqBO.getConsumerSeqNo() + "\"").append("}");
            return reqSb.toString();
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u8bf7\u6c42\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u8bf7\u6c42\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
    }

    private BusiSubAcctTransRspBO resolveRspMsg(String returnString) {
        BusiSubAcctTransRspBO rspBO;
        block9: {
            rspBO = new BusiSubAcctTransRspBO();
            rspBO.setRespCode("000002");
            rspBO.setRespDesc("\u672a\u77e5\u9519\u8bef");
            int step = 0;
            try {
                JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
                step = 1;
                JSONObject headJsObj = JSONObject.parseObject((String)rspJsonObject.getString("sys_head"));
                step = 3;
                if (headJsObj == null) {
                    rspBO.setRespCode("000001");
                    rspBO.setRespDesc("\u54cd\u5e94\u62a5\u6587\u7ed3\u6784sys_head\u9519\u8bef");
                    break block9;
                }
                String retStatus = headJsObj.getString("ret_status");
                JSONObject headErrJsObj = JSONObject.parseObject((String)headJsObj.getString("ret")).getJSONObject("struct");
                step = 4;
                if (headErrJsObj == null) {
                    rspBO.setRespCode("000001");
                    rspBO.setRespDesc("\u54cd\u5e94\u62a5\u6587\u7ed3\u6784ret-struct\u9519\u8bef");
                    break block9;
                }
                rspBO.setRespCode(headErrJsObj.getString("ret_code"));
                rspBO.setRespDesc(headErrJsObj.getString("ret_msg"));
                if (!"S".equals(retStatus)) break block9;
                JSONObject bodyJsObj = null;
                try {
                    bodyJsObj = JSONObject.parseObject((String)rspJsonObject.getString("body"));
                    step = 5;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u89e3\u6790\u5e73\u5b89\u5b50\u8d26\u6237\u5212\u8d26\u63a5\u53e3BODY\u5931\u8d25" + e.getMessage() + "\r\n\u8fd4\u56de:\r\n" + returnString, (Throwable)e);
                }
                if (bodyJsObj != null) {
                    rspBO.setRspSeqNo(bodyJsObj.getString("hexlsh"));
                    rspBO.setCcy(bodyJsObj.getString("bizhong"));
                    rspBO.setFromAcctNo(bodyJsObj.getString("zhuanczh"));
                    rspBO.setFromAcctName(bodyJsObj.getString("zhuanczhmc"));
                    rspBO.setToAcctNo(bodyJsObj.getString("zhuanrzh"));
                    rspBO.setToAcctName(bodyJsObj.getString("zhuanrzhmc"));
                    String amt = bodyJsObj.getString("jiaoyije");
                    if (amt != null && amt.length() > 0) {
                        rspBO.setTranAmt(new BigDecimal(amt));
                    }
                }
            }
            catch (Exception e) {
                if (step < 3) {
                    logger.error("\u89e3\u6790\u5e73\u5b89\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38step=" + step + ",\u8fd4\u56de\u5185\u5bb9=" + returnString);
                }
                rspBO.setRespCode("000001");
                rspBO.setRespDesc(e.getMessage());
                e.printStackTrace();
                if (!this.isDebugEnabled) break block9;
                logger.debug("\u8c03\u7528\u5e73\u5b89\u5b50\u8d26\u6237\u5212\u8d26\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587[step:" + step + "]\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        return rspBO;
    }
}

