/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.CancelInvoiceIntfService;
import com.tydic.pfscext.external.api.bo.BusiCancelInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiCancelInvoiceRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CancelInvoiceIntfServiceImpl
implements CancelInvoiceIntfService {
    private static final Logger logger = LoggerFactory.getLogger(CancelInvoiceIntfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private Environment prop;
    private final Long SUPPLIER_NO = 100055L;

    @Override
    public BusiCancelInvoiceRspBO applyInvoice(BusiCancelInvoiceReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getMarkId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[markId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String reqStr = this.initReqStr(reqBO);
            logger.debug("\u53d6\u6d88\u5f00\u7968\u521d\u59cb\u5316\u8bf7\u6c42\u53c2\u6570\uff1a" + reqStr);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            logger.debug("\u53d6\u6d88\u5f00\u7968\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\uff1a" + reqEsbStr);
            String url = this.prop.getProperty("FSC_CANCEL_INVOICE_URL");
            logger.debug("\u53d6\u6d88\u5f00\u7968URL\u5730\u5740\uff1a" + url);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + url + "]");
            }
            logger.info("\u901a\u77e5\u5355\u53f7[" + reqBO.getMarkId() + "]\u8c03\u7528\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiCancelInvoiceRspBO cancelInvoiceRspBO = this.resolveRsp(returnString, reqBO.getSupplierId());
            return cancelInvoiceRspBO;
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((Object)((PfscExternalBusinessException)e).getMsgCode()) ? "\u5931\u8d25" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e.getMessage());
        }
    }

    private BusiCancelInvoiceRspBO resolveRsp(String returnString, Long supplierId) {
        BusiCancelInvoiceRspBO rspBO = new BusiCancelInvoiceRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            Boolean result = null;
            if (!StringUtils.isEmpty((Object)rspJsonObject.get((Object)"result"))) {
                result = "false".equals(rspJsonObject.get((Object)"result")) ? Boolean.valueOf(false) : (Boolean)rspJsonObject.get((Object)"result");
            }
            Boolean success = null;
            if (!StringUtils.isEmpty((Object)rspJsonObject.get((Object)"success"))) {
                success = "false".equals(rspJsonObject.get((Object)"success")) ? Boolean.valueOf(false) : (Boolean)rspJsonObject.get((Object)"success");
            }
            if (this.SUPPLIER_NO.equals(supplierId)) {
                rspBO.setSuccess(success);
            } else if (result != null) {
                rspBO.setResult(result);
            } else if (success != null) {
                rspBO.setResult(success);
            }
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            rspBO.setNeedAudit((String)rspJsonObject.get((Object)"needAudit"));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u8c03\u7528\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u8c03\u7528\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return rspBO;
    }

    private String initReqStr(BusiCancelInvoiceReqBO reqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"markId\":").append("\"" + reqBO.getMarkId() + "\",");
        sb.append("}");
        return sb.toString();
    }
}

