/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiPushErpPayableDetailService;
import com.tydic.pfscext.external.api.bo.BusiPushErpYFDetailReqBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYFDetailRspBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYSDetailReqBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYSDetailRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiPushErpPayableDetailServiceImpl
implements BusiPushErpPayableDetailService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushErpPayableDetailServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiPushErpYFDetailRspBO pushErpYFPayableDetail(BusiPushErpYFDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExternalBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = this.initYFReqStr(reqBO);
        log.info("\u63a8\u9001erp\u5e94\u4ed8\u5355\u5165\u53c2\uff1a" + reqStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_PUSH_ERP_PAY_URL")), this.getRequestHeaders(), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001erp\u5e94\u4ed8\u5355\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_PUSH_ERP_PAY_URL") + "]");
            }
            log.info("\u8c03\u7528\u63a8\u9001erp\u5e94\u4ed8\u5355\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001erp\u5e94\u4ed8\u5355\u4e0b\u53d1\u7cfb\u7edf\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveYFRsp(returnString);
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((Object)((PfscExternalBusinessException)e).getMsgCode()) ? "\u5931\u8d25" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u63a8\u9001erp\u5e94\u4ed8\u5355\u4e0b\u53d1\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public BusiPushErpYSDetailRspBO pushErpYSpayableDetail(BusiPushErpYSDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExternalBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = this.initYSReqStr(reqBO);
        log.info("\u63a8\u9001erp\u5e94\u6536\u5355\u5165\u53c2\uff1a" + reqStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_PUSH_ERP_COLLECT_URL")), this.getRequestHeaders(), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001erp\u5e94\u6536\u5355\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_PUSH_ERP_COLLECT_URL") + "]");
            }
            log.info("\u8c03\u7528\u63a8\u9001erp\u5e94\u6536\u5355\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001erp\u5e94\u6536\u5355\u4e0b\u53d1\u7cfb\u7edf\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveYSRsp(returnString);
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((Object)((PfscExternalBusinessException)e).getMsgCode()) ? "\u5931\u8d25" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u63a8\u9001erp\u5e94\u6536\u5355\u4e0b\u53d1\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e.getMessage());
        }
    }

    private BusiPushErpYSDetailRspBO resolveYSRsp(String returnString) {
        BusiPushErpYSDetailRspBO rspBO = new BusiPushErpYSDetailRspBO();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            JSONArray resultArray = jsonObject.getJSONArray("d");
            JSONObject resultObject = resultArray.getJSONObject(0);
            Boolean isSuccess = resultObject.getBoolean("IsSuccess");
            String message = resultObject.getString("Error");
            if (isSuccess.booleanValue()) {
                rspBO.setRespCode("0000");
            } else {
                rspBO.setRespCode("8888");
            }
            rspBO.setRespDesc(message);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001ERP\u5e94\u6536\u5355\u8fd4\u56de\u62a5\u6587\u89e3\u6790" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private BusiPushErpYFDetailRspBO resolveYFRsp(String returnString) {
        BusiPushErpYFDetailRspBO rspBO = new BusiPushErpYFDetailRspBO();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            JSONArray resultArray = jsonObject.getJSONArray("d");
            JSONObject resultObject = resultArray.getJSONObject(0);
            Boolean isSuccess = resultObject.getBoolean("IsSuccess");
            String message = resultObject.getString("Error");
            if (isSuccess.booleanValue()) {
                rspBO.setRespCode("0000");
            } else {
                rspBO.setRespCode("8888");
            }
            rspBO.setRespDesc(message);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001ERP\u5e94\u4ed8\u5355\u8fd4\u56de\u62a5\u6587\u89e3\u6790\u5931\u8d25" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    public Header[] getRequestHeaders() {
        BasicHeader[] header = new BasicHeader[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8"), new BasicHeader("ESB-Requestsystem", "MALL")};
        return header;
    }

    private String initYFReqStr(BusiPushErpYFDetailReqBO reqBO) {
        return JSON.toJSONString((Object)reqBO);
    }

    private String initYSReqStr(BusiPushErpYSDetailReqBO reqBO) {
        return JSON.toJSONString((Object)reqBO);
    }
}

