/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.aisino.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.pfscext.external.aisino.api.CustomerAccessibleInfoService;
import com.tydic.pfscext.external.aisino.api.bo.CustomerAccessibleInfoReqBO;
import com.tydic.pfscext.external.aisino.api.bo.CustomerAccessibleInfoRspBO;
import com.tydic.pfscext.external.aisino.api.bo.HCXTokenInfoReqBO;
import com.tydic.pfscext.external.aisino.api.bo.HCXTokenInfoRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CustomerAccessibleInfoServiceImpl
implements CustomerAccessibleInfoService {
    private static final Logger log = LoggerFactory.getLogger(CustomerAccessibleInfoServiceImpl.class);
    @Value(value="${HCX_PARTNER_ID}")
    private String partnerId;
    @Value(value="${HCX_PARTNER_NAME}")
    private String partnerName;
    @Autowired
    private Environment prop;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public HCXTokenInfoRspBO getHCXTokenInfo(HCXTokenInfoReqBO reqBO) {
        return null;
    }

    @Override
    public CustomerAccessibleInfoRspBO queryAccessibleInfo(CustomerAccessibleInfoReqBO reqBO, String accessToken) {
        CustomerAccessibleInfoRspBO extRspBO = new CustomerAccessibleInfoRspBO();
        if (null == reqBO.getCorpIdInfo()) {
            throw new PfscExternalBusinessException("8888", "\u4f01\u4e1a\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == accessToken) {
            throw new PfscExternalBusinessException("8888", "\u672a\u83b7\u53d6\u5230\u6838\u8d22\u4fe1token\uff01");
        }
        reqBO.setPartnerId(this.partnerId);
        reqBO.setPartnerName(this.partnerName);
        reqBO.setSerial("1");
        String reqEsbStr = JSONObject.toJSONString((Object)reqBO);
        int random = CustomerAccessibleInfoServiceImpl.getRandom();
        Long timeStamp = CustomerAccessibleInfoServiceImpl.getTimeStamp();
        String sign = CustomerAccessibleInfoServiceImpl.getSign(this.prop.getProperty("ESB_QUERY_ACCESSIBLE_MAPPING_URL"), random, timeStamp, reqEsbStr, accessToken);
        HashMap<String, String> headersMap = new HashMap<String, String>(4);
        headersMap.put("X-SCF-TV", String.valueOf(timeStamp));
        headersMap.put("X-SCF-AUTH-TOKEN", accessToken);
        headersMap.put("X-SCF-SIGN", sign);
        headersMap.put("X-SCF-NONCE", String.valueOf(random));
        log.info("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u670d\u52a1\u5165\u53c2\u62a5\u6587" + reqEsbStr);
        try {
            ResponseEntity<String> responseEntity = this.doPost(this.prop.getProperty("ESB_QUERY_ACCESSIBLE_INFO_URL"), reqEsbStr, MediaType.APPLICATION_JSON, headersMap);
            if (200 == responseEntity.getStatusCodeValue()) {
                String respStr = (String)responseEntity.getBody();
                log.info("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
                extRspBO = CustomerAccessibleInfoServiceImpl.resolveRspMsg(respStr);
            } else {
                log.error("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u67e5\u8be2-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + responseEntity.getStatusCodeValue() + "], [http_url=" + this.prop.getProperty("ESB_QUERY_ACCESSIBLE_INFO_URL") + "]" + reqEsbStr);
                extRspBO.setRespCode("8888");
                extRspBO.setRespDesc("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u8c03\u7528\u5931\u8d25" + e);
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u5931\u8d25");
        }
        return extRspBO;
    }

    public static CustomerAccessibleInfoRspBO resolveRspMsg(String returnString) {
        CustomerAccessibleInfoRspBO extRspBO = new CustomerAccessibleInfoRspBO();
        if (StringUtils.isEmpty((Object)returnString)) {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u6838\u8d22\u4fe1-\u5ba2\u6237\u51c6\u5165\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return extRspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if ("0".equals(jsonObject.get((Object)"code"))) {
            extRspBO.setRespCode("0000");
            extRspBO.setRespDesc(jsonObject.getString("message"));
            JSONArray jsonArray = jsonObject.getJSONArray("dataList");
            JSONObject dataList = jsonArray.getJSONObject(0);
            extRspBO.setCorpName(dataList.getString("corpName"));
            extRspBO.setCorpIdType(dataList.getString("corpIdType"));
            extRspBO.setCorpIdCode(dataList.getString("corpIdCode"));
            extRspBO.setCorpRegState(dataList.getString("corpRegState"));
            String date = dataList.getString("corpAuthDate");
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.CHINA);
                extRspBO.setCorpAuthDate(sdf.parse(date));
            }
            catch (Exception e) {
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38" + e);
            }
            extRspBO.setIsCorpCore(dataList.getString("isCorpCore"));
        } else {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc((String)jsonObject.get((Object)"message"));
        }
        return extRspBO;
    }

    private String initReqStr(CustomerAccessibleInfoReqBO reqBO) {
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        return reqStr;
    }

    public static String getSign(String url, int random, Long timeStamp, String body, String token) {
        String plaintext = url + "X-SCF-NONCE" + "=" + random + "&" + "X-SCF-TV" + "=" + timeStamp + body + token;
        return DigestUtils.md5Hex((byte[])plaintext.getBytes(StandardCharsets.UTF_8)).toUpperCase();
    }

    public static int getRandom() {
        return new Random().nextInt(1000) + 1;
    }

    public static Long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public ResponseEntity<String> doPost(String url, String body, MediaType type, Map<String, String> headersMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(type);
        try {
            httpHeaders.add("X-SCF-TV", headersMap.get("X-SCF-TV"));
            httpHeaders.add("X-SCF-AUTH-TOKEN", headersMap.get("X-SCF-AUTH-TOKEN"));
            httpHeaders.add("X-SCF-SIGN", headersMap.get("X-SCF-SIGN"));
            httpHeaders.add("X-SCF-NONCE", headersMap.get("X-SCF-NONCE"));
        }
        catch (NullPointerException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5fc5\u987b\u8bf7\u6c42\u5934\u6709\u4e3a\u7a7a\u503c" + e);
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("2001", "\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + url);
        }
        return response;
    }
}

