/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.esb.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.esb.api.FscEsbGetElectronicInvoiceExternalService;
import com.tydic.pfscext.external.esb.bo.FscEsbElectronicInvoiceInfoBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetElectronicInvoiceExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetElectronicInvoiceExternalRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscEsbGetElectronicInvoiceExternalServiceImpl
implements FscEsbGetElectronicInvoiceExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscEsbGetElectronicInvoiceExternalServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public FscEsbGetElectronicInvoiceExternalRspBO getElectronicInvoice(FscEsbGetElectronicInvoiceExternalReqBO reqBo) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        FscEsbGetElectronicInvoiceExternalRspBO rspBo = new FscEsbGetElectronicInvoiceExternalRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setInvoiceInfos(new ArrayList<FscEsbElectronicInvoiceInfoBO>());
        if (StrUtil.isBlank((CharSequence)reqBo.getNotificationNo())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getSupplierId())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        String hsn = this.getHsn(reqBo.getSupplierId());
        if (StrUtil.isBlank((CharSequence)hsn)) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u83b7\u53d6hsn\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u914d\u7f6e");
            return rspBo;
        }
        String url = this.getUrl();
        if (StrUtil.isBlank((CharSequence)url)) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u83b7\u53d6\u7535\u7968\u8bf7\u6c42\u5730\u5740\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u914d\u7f6e");
            return rspBo;
        }
        boolean isHttps = false;
        if (url.startsWith("https") || url.startsWith("HTTPS")) {
            isHttps = true;
        }
        log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0URL:" + url);
        JSONObject reqJson = new JSONObject();
        reqJson.put("markId", (Object)reqBo.getNotificationNo());
        String reqEsbStr = ESBParamUtil.getEsbReqStr(reqJson.toJSONString(), hsn, "BUSINESS_PAY");
        log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0URL:{}.\u8bf7\u6c42\u62a5\u6587:{}", (Object)url, (Object)reqEsbStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", isHttps);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u5931\u8d25," + reqBo.getSupplierId(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + url + "].supId:" + reqBo.getSupplierId());
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587:{}.\u8bf7\u6c42\u5730\u5740\uff1a{}.\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{reqEsbStr, url, returnString});
        if (StrUtil.isEmpty((CharSequence)returnString)) {
            log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new PfscExternalBusinessException("18002", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        Boolean success = (Boolean)rspJsonObject.get((Object)"success");
        if (null == resultCode) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
            throw new PfscExternalBusinessException("18000", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        if (success.equals(true) || "9000".equals(resultCode)) {
            JSONArray resultArray = null;
            try {
                resultArray = JSONObject.parseArray((String)rspJsonObject.getString("result"));
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef", (Throwable)e);
                throw new PfscExternalBusinessException("18000", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5730\u5740--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
            if (!CollectionUtils.isEmpty((Collection)resultArray)) {
                for (int i = 0; i < resultArray.size(); ++i) {
                    JSONObject jsonObject = resultArray.getJSONObject(i);
                    FscEsbElectronicInvoiceInfoBO invoiceInfoBo = new FscEsbElectronicInvoiceInfoBO();
                    String invoiceNo = jsonObject.getString("invoiceNo");
                    if (!StringUtils.hasText((String)invoiceNo)) {
                        invoiceNo = jsonObject.getString("invoiceId");
                    }
                    invoiceInfoBo.setInvoiceNo(invoiceNo);
                    invoiceInfoBo.setInvoiceCode(jsonObject.getString("invoiceCode"));
                    invoiceInfoBo.setInvoiceDate(jsonObject.getDate("invoiceDate"));
                    invoiceInfoBo.setInvoiceType(jsonObject.getInteger("invoiceType"));
                    invoiceInfoBo.setElectronicInvoiceUrl(jsonObject.getString("fileUrl"));
                    invoiceInfoBo.setNotificationNo(reqBo.getNotificationNo());
                    rspBo.getInvoiceInfos().add(invoiceInfoBo);
                }
            }
        }
        return rspBo;
    }

    private String getUrl() {
        try {
            return this.prop.getProperty("ESB_ELECTRONIC_INVOICE_URL");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6apollo\u914d\u7f6e\u7535\u5546\u53d1\u7968\u5730\u5740\u5f02\u5e38\uff1a{}", (Object)e.toString());
            return "";
        }
    }

    private String getHsn(String supplierId) {
        try {
            return this.prop.getProperty("SUPPLIER_ID_" + supplierId);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6HSN\u5f02\u5e38\uff1a{}", (Object)e.toString());
            return "";
        }
    }
}

