/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.esb.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.esb.api.FscEsbJDAddressExternalService;
import com.tydic.pfscext.external.esb.bo.FscEsbGetJDAddressFromAddressExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetJDAddressFromAddressExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetJDAddressFromAddressInfoBO;
import com.tydic.pfscext.external.esb.bo.FscEsbJDAddressCheckAreaExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscEsbJDAddressCheckAreaExternalRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscEsbJDAddressExternalServiceImpl
implements FscEsbJDAddressExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscEsbJDAddressExternalServiceImpl.class);
    @Autowired
    private Environment prop;
    @Value(value="${FSC_ESB_CHECK_AREA_JD:http://172.16.100.65:8001/OSN/api/checkArea/v1}")
    private String FSC_ESB_CHECK_AREA_JD;
    @Value(value="${FSC_ESB_GET_JD_ADDRESS_FROM_ADDRESS:http://172.16.100.65:8001/OSN/api/getJDAddressFromAddress/v1}")
    private String FSC_ESB_GET_JD_ADDRESS_FROM_ADDRESS;

    @Override
    public FscEsbJDAddressCheckAreaExternalRspBO dealCheckAreaJD(FscEsbJDAddressCheckAreaExternalReqBO reqBo) {
        HttpRetBean httpRetBean;
        FscEsbJDAddressCheckAreaExternalRspBO rspBo = new FscEsbJDAddressCheckAreaExternalRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBo.getSupplierId() == null) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        String hsn = this.getHsn(reqBo.getSupplierId());
        if (StrUtil.isBlank((CharSequence)hsn)) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u83b7\u53d6hsn\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u914d\u7f6e");
            return rspBo;
        }
        String url = this.FSC_ESB_CHECK_AREA_JD;
        log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0URL:" + url);
        if (StrUtil.isBlank((CharSequence)url)) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027\u8bf7\u6c42\u5730\u5740\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u914d\u7f6e");
            return rspBo;
        }
        if (reqBo.getProvinceId() == null && reqBo.getCityId() == null && reqBo.getCountyId() == null && reqBo.getTownId() == null) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u5730\u5740ID\u5168\u4e3a\u7a7a");
            return rspBo;
        }
        boolean isHttps = false;
        if (url.startsWith("https") || url.startsWith("HTTPS")) {
            isHttps = true;
        }
        String reqJson = this.initReqJson(reqBo, hsn);
        log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0URL:{}.\u8bf7\u6c42\u62a5\u6587:{}", (Object)url, (Object)reqJson);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqJson.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8.name(), isHttps);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u5931\u8d25," + reqBo.getSupplierId(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027\u63a5\u53e3\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + url + "].supId:" + reqBo.getSupplierId());
            throw new PfscExternalBusinessException("18002", "\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587:{}.\u8bf7\u6c42\u5730\u5740\uff1a{}.\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{reqJson, url, returnString});
        if (StrUtil.isEmpty((CharSequence)returnString)) {
            log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new PfscExternalBusinessException("18002", "\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        this.resolveRsp(rspBo, returnString);
        return rspBo;
    }

    @Override
    public FscEsbGetJDAddressFromAddressExternalRspBO gerJDAddressFromAddress(FscEsbGetJDAddressFromAddressExternalReqBO reqBo) {
        HttpRetBean httpRetBean;
        FscEsbGetJDAddressFromAddressExternalRspBO rspBo = new FscEsbGetJDAddressFromAddressExternalRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBo.getSupplierId() == null) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        String hsn = this.getHsn(reqBo.getSupplierId());
        if (StrUtil.isBlank((CharSequence)hsn)) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u83b7\u53d6hsn\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u914d\u7f6e");
            return rspBo;
        }
        String url = this.FSC_ESB_GET_JD_ADDRESS_FROM_ADDRESS;
        log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0URL:" + url);
        if (StrUtil.isBlank((CharSequence)url)) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u8bf7\u6c42\u5730\u5740\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u914d\u7f6e");
            return rspBo;
        }
        boolean isHttps = false;
        if (url.startsWith("https") || url.startsWith("HTTPS")) {
            isHttps = true;
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("address", (Object)reqBo.getAddress());
        String reqEsbStr = ESBParamUtil.getEsbReqStr(reqJson.toJSONString(), hsn, "BUSINESS_PAY");
        log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0URL:{}.\u8bf7\u6c42\u62a5\u6587:{}", (Object)url, (Object)reqEsbStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8.name(), isHttps);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u5931\u8d25," + reqBo.getSupplierId(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u63a5\u53e3\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + url + "].supId:" + reqBo.getSupplierId());
            throw new PfscExternalBusinessException("18002", "\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587:{}.\u8bf7\u6c42\u5730\u5740\uff1a{}.\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{reqEsbStr, url, returnString});
        if (StrUtil.isEmpty((CharSequence)returnString)) {
            log.info("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new PfscExternalBusinessException("18002", "\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        this.resolveRsp(rspBo, returnString);
        return rspBo;
    }

    private void resolveRsp(FscEsbGetJDAddressFromAddressExternalRspBO rspBo, String returnString) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        String resultMessage = (String)rspJsonObject.get((Object)"resultMessage");
        JSONObject result = rspJsonObject.getJSONObject("result");
        Boolean success = rspJsonObject.getBoolean("success");
        if (success.booleanValue()) {
            rspBo.setRespCode(Optional.ofNullable(resultCode).orElse("0000"));
            rspBo.setRespDesc(Optional.ofNullable(resultMessage).orElse("\u6210\u529f"));
            if (result != null) {
                FscEsbGetJDAddressFromAddressInfoBO addressInfo = (FscEsbGetJDAddressFromAddressInfoBO)JSONObject.parseObject((String)result.toJSONString(), FscEsbGetJDAddressFromAddressInfoBO.class);
                rspBo.setAddressInfo(addressInfo);
            }
        }
    }

    private void resolveRsp(FscEsbJDAddressCheckAreaExternalRspBO rspBo, String returnString) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u9a8c\u8bc1\u5730\u5740\u6709\u6548\u6027-\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = rspJsonObject.getString("resultCode");
        String resultMessage = rspJsonObject.getString("resultMessage");
        JSONObject result = rspJsonObject.getJSONObject("result");
        Boolean success = rspJsonObject.getBoolean("success");
        if (success != null && result != null && success.booleanValue()) {
            Boolean success2 = result.getBoolean("success");
            if (success2 != null && success2.booleanValue()) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
            } else {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u6821\u9a8c\u5931\u8d25." + result.getString("message"));
            }
        } else {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u6821\u9a8c\u5931\u8d25." + resultMessage);
        }
    }

    private String initReqJson(FscEsbJDAddressCheckAreaExternalReqBO reqBo, String hsn) {
        JSONObject reqJson = new JSONObject();
        if (reqBo.getProvinceId() != null) {
            reqJson.put("provinceId", (Object)reqBo.getProvinceId());
        }
        if (reqBo.getCityId() != null) {
            reqJson.put("cityId", (Object)reqBo.getCityId());
        }
        if (reqBo.getCountyId() != null) {
            reqJson.put("countyId", (Object)reqBo.getCountyId());
        }
        if (reqBo.getTownId() != null) {
            reqJson.put("townId", (Object)reqBo.getTownId());
        }
        return ESBParamUtil.getEsbReqStr(reqJson.toJSONString(), hsn, "BUSINESS_PAY");
    }

    private String getHsn(Long supplierId) {
        try {
            return this.prop.getProperty("SUPPLIER_ID_" + supplierId);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6HSN\u5f02\u5e38\uff1a{}", (Object)e.toString());
            return "";
        }
    }
}

