/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiApplyInvoiceService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiApplyInvoiceServiceImpl
implements BusiApplyInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BusiApplyInvoiceServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private Environment prop;
    private static final Long SUPPLIER_ID = 100055L;
    private static final Long SUPPLIER_ID_JD_FL = 2022081501L;
    private static final Long SUPPLIER_ID_JD_PC = 1000550L;

    @Override
    public BusiApplyInvoiceRspBO applyInvoice(BusiApplyInvoiceReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getSupplierId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierOrder()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[supplierOrder]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMarkId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[markId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSettlementId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[settlementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceType()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceOrg()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceOrg]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBizInvoiceContent()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[bizInvoiceContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDate()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceDate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTitle()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[title]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceNum()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoicePrice()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoicePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCurrentBatch()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[currentBatch]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalBatch()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[totalBatch]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalBatchInvoiceAmount()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[totalBatchInvoiceAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            log.debug("\u901a\u77e5\u5355\u53f7[" + reqBO.getMarkId() + "]\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0" + reqEsbStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]");
            }
            log.info("\u901a\u77e5\u5355\u53f7[" + reqBO.getMarkId() + "]\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiApplyInvoiceRspBO invoiceRsp = this.resolveRsp(returnString);
            return invoiceRsp;
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((Object)((PfscExternalBusinessException)e).getMsgCode()) ? "\u5931\u8d25" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e.getMessage());
        }
    }

    private String initReqStr(BusiApplyInvoiceReqBO reqBO) {
        StringBuffer supOrSB = new StringBuffer();
        supOrSB.append("[");
        for (int i = 0; i < reqBO.getSupplierOrder().size(); ++i) {
            if (i == 0) {
                supOrSB.append("\"" + reqBO.getSupplierOrder().get(i) + "\"");
                continue;
            }
            supOrSB.append(",").append("\"" + reqBO.getSupplierOrder().get(i) + "\"");
        }
        supOrSB.append("]");
        StringBuffer sb = new StringBuffer();
        if (SUPPLIER_ID.equals(reqBO.getSupplierId()) || SUPPLIER_ID_JD_FL.equals(reqBO.getSupplierId()) || SUPPLIER_ID_JD_PC.equals(reqBO.getSupplierId())) {
            sb.append("{").append("\"supplierOrder\":").append(supOrSB + ",").append("\"markId\":").append("\"" + reqBO.getMarkId() + "\",").append("\"settlementId\":").append("\"" + reqBO.getSettlementId() + "\",").append("\"invoiceType\":").append("" + reqBO.getInvoiceType() + ",").append("\"invoiceOrg\":").append("\"" + reqBO.getInvoiceOrg() + "\",").append("\"bizInvoiceContent\":").append("" + reqBO.getBizInvoiceContent() + ",").append("\"invoiceDate\":").append("\"" + reqBO.getInvoiceDate() + "\",").append("\"title\":").append("\"" + reqBO.getTitle() + "\",").append("\"invoiceNum\":").append("" + reqBO.getInvoiceNum() + ",").append("\"invoicePrice\":").append("" + reqBO.getInvoicePrice() + ",").append("\"invoiceRemark\":").append("\"" + this.getWordCount(Optional.ofNullable(reqBO.getInvoiceRemark()).orElse(""), 40) + "\",").append("\"currentBatch\":").append("\"" + reqBO.getCurrentBatch() + "\",").append("\"totalBatch\":").append("" + reqBO.getTotalBatch() + ",").append("\"totalBatchInvoiceAmount\":").append("" + reqBO.getTotalBatchInvoiceAmount() + ",").append("\"enterpriseTaxpayer\":").append("\"" + reqBO.getEnterpriseTaxpayer() + "\",").append("\"enterpriseRegAddress\":").append("\"" + reqBO.getEnterpriseRegAddress() + "\",").append("\"enterpriseRegPhone\":").append("\"" + reqBO.getEnterpriseRegPhone() + "\",").append("\"enterpriseBankName\":").append("\"" + reqBO.getEnterpriseBankName() + "\",").append("\"enterpriseBankAccount\":").append("\"" + reqBO.getEnterpriseBankAccount() + "\",").append("\"billToParty\":").append("\"" + reqBO.getBillToParty() + "\",").append("\"billToer\":").append("\"" + reqBO.getBillToer() + "\",").append("\"billToContact\":").append("\"" + reqBO.getBillToContact() + "\",").append("\"billToProvince\":").append("" + reqBO.getBillToProvince() + ",").append("\"billToCity\":").append("" + reqBO.getBillToCity() + ",").append("\"billToCounty\":").append("" + reqBO.getBillToCounty() + ",").append("\"billToTown\":").append("" + reqBO.getBillToTown() + ",").append("\"billToAddress\":").append("\"" + reqBO.getBillToAddress() + "\"");
        } else {
            sb.append("{").append("\"supplierOrder\":").append(supOrSB + ",").append("\"markId\":").append("\"" + reqBO.getMarkId() + "\",").append("\"settlementId\":").append("\"" + reqBO.getSettlementId() + "\",").append("\"invoiceType\":").append("" + reqBO.getInvoiceType() + ",").append("\"invoiceOrg\":").append("\"" + reqBO.getInvoiceOrg() + "\",").append("\"bizInvoiceContent\":").append("" + reqBO.getBizInvoiceContent() + ",").append("\"invoiceDate\":").append("\"" + reqBO.getInvoiceDate() + "\",").append("\"title\":").append("\"" + reqBO.getTitle() + "\",").append("\"invoiceNum\":").append("" + reqBO.getInvoiceNum() + ",").append("\"invoicePrice\":").append("" + reqBO.getInvoicePrice() + ",").append("\"invoiceRemark\":").append("\"" + reqBO.getInvoiceRemark() + "\",").append("\"currentBatch\":").append("\"" + reqBO.getCurrentBatch() + "\",").append("\"totalBatch\":").append("" + reqBO.getTotalBatch() + ",").append("\"totalBatchInvoiceAmount\":").append("" + reqBO.getTotalBatchInvoiceAmount() + ",").append("\"enterpriseTaxpayer\":").append("\"" + reqBO.getEnterpriseTaxpayer() + "\",").append("\"address\":").append("\"" + reqBO.getAddress() + "\",").append("\"tel\":").append("\"" + reqBO.getTel() + "\",").append("\"bank\":").append("\"" + reqBO.getBank() + "\",").append("\"account\":").append("\"" + reqBO.getAccount() + "\",").append("\"billToParty\":").append("\"" + reqBO.getBillToParty() + "\",").append("\"billToer\":").append("\"" + reqBO.getBillToer() + "\",").append("\"billToContact\":").append("\"" + reqBO.getBillToContact() + "\",").append("\"billToProvince\":").append("" + reqBO.getBillToProvince() + ",").append("\"billToCity\":").append("" + reqBO.getBillToCity() + ",").append("\"billToCounty\":").append("" + reqBO.getBillToCounty() + ",").append("\"billToTown\":").append("" + reqBO.getBillToTown() + ",").append("\"settlementNakedPrice\":").append("" + reqBO.getSettlementNakedPrice() + ",").append("\"settlementTaxPrice\":").append("" + reqBO.getSettlementTaxPrice() + ",").append("\"billToAddress\":").append("\"" + reqBO.getBillToAddress() + "\"");
        }
        if (null != reqBO.getJdOrgId() && !"".equals(reqBO.getJdOrgId())) {
            sb.append(",").append("\"orgId\":").append("\"" + reqBO.getJdOrgId() + "\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private BusiApplyInvoiceRspBO resolveRsp(String returnString) {
        BusiApplyInvoiceRspBO rspBO = new BusiApplyInvoiceRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            Boolean success = null;
            success = "false".equals(rspJsonObject.get((Object)"success")) ? Boolean.valueOf(false) : (Boolean)rspJsonObject.get((Object)"success");
            rspBO.setSuccess(success);
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return rspBO;
    }

    private String getWordCount(String oldName, int len) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > len) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }
}

