/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiPushErpSaleOrderChangeService;
import com.tydic.pfscext.external.api.bo.BusiPushErpSaleOrderChangeReqBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpSaleOrderChangeRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiPushErpSaleOrderChangeServiceImpl
implements BusiPushErpSaleOrderChangeService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushErpSaleOrderChangeServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiPushErpSaleOrderChangeRspBO pushErpSaleOrderChange(BusiPushErpSaleOrderChangeReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExternalBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JSONObject.toJSONString((Object)reqBO);
        log.info("\u63a8\u9001erp\u4fee\u6539\u53d1\u7968\u62ac\u5934\u5165\u53c2\uff1a" + reqStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_PUSH_ERP_ORDER_CHANGE_URL")), this.getRequestHeaders(), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001erp\u4fee\u6539\u53d1\u7968\u62ac\u5934\u5355\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]");
            }
            log.info("\u8c03\u7528\u63a8\u9001erp\u4fee\u6539\u53d1\u7968\u62ac\u5934\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001erp\u4fee\u6539\u53d1\u7968\u62ac\u5934\u4e0b\u53d1\u7cfb\u7edf\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            if (e instanceof PfscExternalBusinessException) {
                resultCode = StringUtils.isEmpty((Object)((PfscExternalBusinessException)e).getMsgCode()) ? "\u5931\u8d25" : ((PfscExternalBusinessException)e).getMsgCode();
                throw new PfscExternalBusinessException(resultCode, "\u8c03\u7528\u63a8\u9001erp\u4fee\u6539\u53d1\u7968\u62ac\u5934\u4e0b\u53d1\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
            }
            throw new PfscExternalBusinessException("18000", "\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e.getMessage());
        }
    }

    private BusiPushErpSaleOrderChangeRspBO resolveRsp(String returnString) {
        BusiPushErpSaleOrderChangeRspBO rspBO = new BusiPushErpSaleOrderChangeRspBO();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            JSONArray resultArray = jsonObject.getJSONArray("d");
            JSONObject resultObject = resultArray.getJSONObject(0);
            Boolean isSuccess = resultObject.getBoolean("IsSuccess");
            String message = resultObject.getString("Error");
            if (isSuccess.booleanValue()) {
                rspBO.setRespCode("0000");
            } else {
                rspBO.setRespCode("8888");
            }
            rspBO.setRespDesc(message);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001ERP\u4fee\u6539\u53d1\u7968\u62ac\u5934\u8fd4\u56de\u62a5\u6587\u89e3\u6790\u5931\u8d25" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    public Header[] getRequestHeaders() {
        BasicHeader[] header = new BasicHeader[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8"), new BasicHeader("ESB-Requestsystem", "MALL")};
        return header;
    }
}

