/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.FscGetMsgPushService;
import com.tydic.pfscext.external.api.bo.BusiGetMsgReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetMsgRspBO;
import com.tydic.pfscext.external.api.bo.ResultBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscGetMsgPushServiceImpl
implements FscGetMsgPushService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscGetMsgPushServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private Environment prop;

    @Override
    public BusiGetMsgRspBO getMsg(BusiGetMsgReqBO busiGetMsgReqBO) {
        try {
            HttpRetBean httpRetBean;
            String reqStr = this.initReqStr(busiGetMsgReqBO);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiGetMsgReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            LOGGER.info("\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5ba1\u6838\u6d88\u606f\u5165\u53c2\uff1a" + reqEsbStr);
            String url = this.prop.getProperty("ESB_QRY_MSG_URL");
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5ba1\u6838\u6d88\u606fURL\uff1a" + url);
            }
            if ((httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(url), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false)).getStatus() != 200) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + url + "]");
            }
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            }
            LOGGER.info("\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5ba1\u6838\u6d88\u606f\u5165\u53c2\uff1a{}.URL\uff1a{}.\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{reqEsbStr, url, httpRetBean.getStr()});
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiGetMsgRspBO resolveRsp = this.resolveRsp(returnString);
            LOGGER.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u5f00\u59cb\u6253\u5370");
            List<ResultBO> resultList = resolveRsp.getResult();
            if (null != resultList) {
                for (ResultBO resultBO : resultList) {
                    LOGGER.debug("resultBO\uff1a" + resultBO.toString());
                    if (null == resultBO.getResult()) continue;
                    LOGGER.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2Result: " + resultBO.getResult().toString());
                }
            }
            LOGGER.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u6253\u5370\u7ed3\u675f");
            return resolveRsp;
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + e);
            }
            throw new PfscExternalBusinessException("18002", "\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
        }
    }

    private String initReqStr(BusiGetMsgReqBO busiQryMsgReqBO) {
        return JSON.toJSONString((Object)busiQryMsgReqBO);
    }

    private BusiGetMsgRspBO resolveRsp(String returnString) {
        BusiGetMsgRspBO busiQryMsgRspBO = new BusiGetMsgRspBO();
        ArrayList<ResultBO> list = new ArrayList<ResultBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(rspJsonObject.getBoolean("success"));
            busiQryMsgRspBO.setResultCode(Integer.valueOf((String)rspJsonObject.get((Object)"resultCode")));
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (Object singleObject : object) {
                    JSONObject obj = (JSONObject)singleObject;
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    ResultBO jsonStringToJavaBean = (ResultBO)JSON.parseObject((String)jsonStr, ResultBO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return busiQryMsgRspBO;
    }
}

