/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.config;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=-1)
@Configuration
@ConditionalOnProperty(prefix="picker.client", name={"enable"}, havingValue="true")
public class ElasticSearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfiguration.class);
    @Value(value="${es.cluster.address}")
    private String clusterNodes;
    @Value(value="${es.source}")
    private String esSource;
    @Value(value="${es.client.username}")
    private String esClientUsername;
    @Value(value="${es.client.password}")
    private String esClientPassword;
    @Value(value="${es.pool.maxTotal}")
    private int maxTotal;
    @Value(value="${es.pool.connectionTimeout}")
    private int connectionTimeout;
    @Value(value="${es.pool.socketTimeout}")
    private int socketTimeout;
    @Value(value="${es.pool.connectionRequestTimeout}")
    private int connectionRequestTimeout;

    @Bean(value={"restHighLevelClient"}, destroyMethod="close")
    @ConditionalOnMissingBean(value={RestHighLevelClient.class})
    public RestHighLevelClient buildRestClient() {
        RestClientBuilder clientBuilder = null;
        try {
            if (StringUtils.isEmpty((Object)this.clusterNodes)) {
                return null;
            }
            ArrayList<String> ipAddress = new ArrayList<String>(Arrays.asList(this.clusterNodes.split(",")));
            HttpHost[] httpHosts = new HttpHost[ipAddress.size()];
            for (int i = 0; i < ipAddress.size(); ++i) {
                HttpHost httpHost;
                httpHosts[i] = httpHost = new HttpHost(((String)ipAddress.get(i)).split(":")[0], Integer.valueOf(((String)ipAddress.get(i)).split(":")[1]).intValue(), "http");
            }
            clientBuilder = RestClient.builder((HttpHost[])httpHosts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        clientBuilder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(HttpHost host) {
                super.onFailure(new Node(host));
                System.out.println(host.getHostName() + "==\u8282\u70b9\u5931\u8d25\u4e86");
            }
        });
        clientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                return httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(ElasticSearchConfiguration.this.maxTotal).build());
            }
        });
        clientBuilder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(ElasticSearchConfiguration.this.connectionTimeout).setSocketTimeout(ElasticSearchConfiguration.this.socketTimeout).setConnectionRequestTimeout(ElasticSearchConfiguration.this.connectionRequestTimeout);
            }
        });
        if ("AliYun".equals(this.esSource)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esClientUsername, this.esClientPassword));
            clientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchConfiguration.lambda$buildRestClient$0((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new RestHighLevelClient(clientBuilder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildRestClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

