/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.saas.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.osworkflow.ability.bo.TaskInfo;
import com.tydic.osworkflow.ability.bo.TaskInfoWithInst;
import com.tydic.train.saas.atom.api.TrainXsdTaskDealFunction;
import com.tydic.train.saas.atom.bo.TrainXsdTaskDealFunctionReqBO;
import com.tydic.train.saas.atom.bo.TrainXsdTaskDealFunctionRspBO;
import com.tydic.train.service.course.TrainXsdOrderTaskService;
import com.tydic.train.service.lsq.approval.bo.TrainLsqCreateApprovalReqBO;
import com.tydic.train.service.lsq.approval.bo.TrainLsqTaskInstBO;
import com.tydic.train.service.lsq.order.TrainLsqUpdateOrderService;
import com.tydic.train.service.lsq.order.bo.TrainLsqUpdateOrderReqBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainXsdTaskDealFunctionImpl
implements TrainXsdTaskDealFunction {
    private static final Logger log = LoggerFactory.getLogger(TrainXsdTaskDealFunctionImpl.class);
    @Autowired
    private TrainXsdOrderTaskService trainXsdOrderTaskService;
    @Autowired
    private TrainLsqUpdateOrderService trainLsqUpdateOrderService;

    @Override
    public TrainXsdTaskDealFunctionRspBO dealOrderTask(TrainXsdTaskDealFunctionReqBO reqBO) {
        TrainXsdTaskDealFunctionRspBO rspBO = new TrainXsdTaskDealFunctionRspBO();
        this.setCreateApprovalReqBO(reqBO);
        this.setUpdateOrderStatusReqBO(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void setCreateApprovalReqBO(TrainXsdTaskDealFunctionReqBO reqBO) {
        if (reqBO.isCancelFlag()) {
            TrainLsqCreateApprovalReqBO approvalReqBO = new TrainLsqCreateApprovalReqBO();
            approvalReqBO.setCancelFlag(true);
            approvalReqBO.setProcInstId(reqBO.getProcInstId());
            this.trainXsdOrderTaskService.approval(approvalReqBO);
            return;
        }
        TaskInfoWithInst taskInfoWithInst = reqBO.getTaskInfoWithInst();
        TaskInfo task = (TaskInfo)taskInfoWithInst.getTaskInfoList().get(0);
        TrainLsqCreateApprovalReqBO approvalReqBO = new TrainLsqCreateApprovalReqBO();
        approvalReqBO.setProcInstId(taskInfoWithInst.getProcInstId());
        approvalReqBO.setProcDefId(task.getProcDefId());
        approvalReqBO.setProcKey(task.getProcDefKey());
        approvalReqBO.setObjId(task.getBusiness().getBusinessId());
        approvalReqBO.setObjType(Integer.valueOf(1));
        approvalReqBO.setStepCode(task.getStepId());
        approvalReqBO.setStepName(task.getStepName());
        approvalReqBO.setIsFinish(Integer.valueOf(taskInfoWithInst.getIsfinish() != false ? 1 : 0));
        ArrayList<TrainLsqTaskInstBO> taskInstBOS = new ArrayList<TrainLsqTaskInstBO>();
        if (ObjectUtil.isNotEmpty((Object)taskInfoWithInst.getCompletedTaskList())) {
            for (TaskInfo taskInfo : taskInfoWithInst.getCompletedTaskList()) {
                TrainLsqTaskInstBO updateTaskInstBO = new TrainLsqTaskInstBO();
                updateTaskInstBO.setTaskId(taskInfo.getTaskId());
                updateTaskInstBO.setStepStatus(Integer.valueOf(1));
                taskInstBOS.add(updateTaskInstBO);
            }
        }
        approvalReqBO.setTaskInstList(taskInstBOS);
        log.info("\u6d41\u7a0b\u8f6c\u5316\u540e\u5bf9\u8c613 ### {}", (Object)JSON.toJSONString((Object)approvalReqBO));
        this.trainXsdOrderTaskService.approval(approvalReqBO);
    }

    private void setUpdateOrderStatusReqBO(TrainXsdTaskDealFunctionReqBO reqBO) {
        if (reqBO.isCancelFlag()) {
            TrainLsqUpdateOrderReqBO updateOrderReqBO = new TrainLsqUpdateOrderReqBO();
            updateOrderReqBO.setOrderStatus(Integer.valueOf(0));
            updateOrderReqBO.setOrderId(reqBO.getOrderId());
            this.trainLsqUpdateOrderService.updateOrder(updateOrderReqBO);
            return;
        }
        TaskInfoWithInst taskInfoWithInst = reqBO.getTaskInfoWithInst();
        List stepIdList = taskInfoWithInst.getTaskInfoList().stream().map(TaskInfo::getStepId).collect(Collectors.toList());
        Long orderId = Long.valueOf(((TaskInfo)taskInfoWithInst.getTaskInfoList().get(0)).getBusiness().getBusinessId());
        TrainLsqUpdateOrderReqBO updateOrderReqBO = new TrainLsqUpdateOrderReqBO();
        updateOrderReqBO.setOrderId(orderId);
        if (stepIdList.contains("LSQ001")) {
            updateOrderReqBO.setOrderStatus(Integer.valueOf(1));
        }
        if (stepIdList.contains("LSQ002")) {
            updateOrderReqBO.setOrderStatus(Integer.valueOf(2));
        }
        if (stepIdList.contains("LSQ003")) {
            updateOrderReqBO.setOrderStatus(Integer.valueOf(3));
        }
        if (taskInfoWithInst.getIsfinish().booleanValue()) {
            updateOrderReqBO.setOrderStatus(Integer.valueOf(4));
            if ("LSQ001".equals(((TaskInfo)taskInfoWithInst.getCompletedTaskList().get(0)).getStepId())) {
                updateOrderReqBO.setOrderStatus(Integer.valueOf(0));
            }
        }
        log.info("\u6d41\u7a0b\u8f6c\u5316\u540e\u5bf9\u8c614 ### {}", (Object)JSON.toJSONString((Object)updateOrderReqBO));
        this.trainLsqUpdateOrderService.updateOrder(updateOrderReqBO);
    }
}

