/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.tydic.uac.atom.bo.task.UacCancelOrderReqBO;
import com.tydic.uac.atom.bo.task.UacCancelOrderRspBO;
import com.tydic.uac.atom.bo.task.UacDealTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacDealTaskInstRspBO;
import com.tydic.uac.atom.bo.task.UacQryTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacQryTaskInstRspBO;
import com.tydic.uac.atom.task.UacCancelOrderAtomService;
import com.tydic.uac.atom.task.UacDealTaskInstAtomService;
import com.tydic.uac.atom.task.UacQryTaskInstAtomService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacCancelOrderAtomService")
public class UacCancelOrderAtomServiceImpl
implements UacCancelOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(UacCancelOrderAtomServiceImpl.class);
    private UacDealTaskInstAtomService uacDealTaskInstAtomService;
    private UacQryTaskInstAtomService uacQryTaskInstAtomService;

    @Autowired
    public UacCancelOrderAtomServiceImpl(UacDealTaskInstAtomService uacDealTaskInstAtomService, UacQryTaskInstAtomService uacQryTaskInstAtomService) {
        this.uacDealTaskInstAtomService = uacDealTaskInstAtomService;
        this.uacQryTaskInstAtomService = uacQryTaskInstAtomService;
    }

    @Override
    @Transactional
    public UacCancelOrderRspBO dealCoreCancelOrder(UacCancelOrderReqBO reqBO) {
        UacCancelOrderRspBO rspBO = new UacCancelOrderRspBO();
        this.validateArg(reqBO);
        if (UacCommConstant.NO_PROCESS.equals(reqBO.getIfProcess())) {
            log.debug("\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u4e0d\u8fdb\u884c\u6d41\u7a0b\u5904\u7406");
        } else {
            UacQryTaskInstReqBO qryTaskByOrderReqBO = new UacQryTaskInstReqBO();
            qryTaskByOrderReqBO.setOrderId(reqBO.getOrderId());
            UacQryTaskInstRspBO qryTaskByOrderRspBO = this.uacQryTaskInstAtomService.qryTaskInst(qryTaskByOrderReqBO);
            if (!"0000".equals(qryTaskByOrderRspBO.getRespCode())) {
                if (log.isDebugEnabled()) {
                    log.debug("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1,\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + qryTaskByOrderRspBO.getRespDesc());
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1,\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + qryTaskByOrderRspBO.getRespDesc());
                return rspBO;
            }
            UacDealTaskInstReqBO dealTaskInstReqBO = new UacDealTaskInstReqBO();
            dealTaskInstReqBO.setOrderId(reqBO.getOrderId());
            dealTaskInstReqBO.setOperId(reqBO.getCancelOperId());
            dealTaskInstReqBO.setTaskId(qryTaskByOrderRspBO.getTaskInstBO().getTaskId());
            dealTaskInstReqBO.setDealType("DELETE");
            UacDealTaskInstRspBO dealTaskInstRspBO = this.uacDealTaskInstAtomService.dealCoreDealTaskInst(dealTaskInstReqBO);
            if (!"0000".equals(dealTaskInstRspBO.getRespCode())) {
                if (log.isDebugEnabled()) {
                    log.debug("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1,\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u4efb\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + dealTaskInstRspBO.getRespDesc());
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1,\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u4efb\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + dealTaskInstRspBO.getRespDesc());
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u64a4\u9500\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UacCancelOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8000", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("8000", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCancelOperId())) {
            throw new BusinessException("8000", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010cancelOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

