/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.tydic.uac.atom.bo.task.UacFinishOrderReqBO;
import com.tydic.uac.atom.bo.task.UacFinishOrderRspBO;
import com.tydic.uac.atom.task.UacFinishOrderAtomService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrderMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrderPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uacFinishOrderAtomService")
public class UacFinishOrderAtomServiceImpl
implements UacFinishOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(UacFinishOrderAtomServiceImpl.class);
    private UacOrderMapper orderMapper;

    @Autowired
    public UacFinishOrderAtomServiceImpl(UacOrderMapper orderMapper) {
        this.orderMapper = orderMapper;
    }

    @Override
    public UacFinishOrderRspBO dealCoreFinishOrder(UacFinishOrderReqBO reqBO) {
        UacFinishOrderRspBO rspBO = new UacFinishOrderRspBO();
        this.validateArg(reqBO);
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId());
        if (orderPO == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setFinishFlag(UacCommConstant.CORE_ORDER_FINISH_FLAG.FINISH);
        orderPO.setOrderState(UacCommConstant.CORE_ORDER_STATUS.FINISH);
        orderPO.setFinishTime(new Date());
        int update = this.orderMapper.updateById(orderPO);
        if (update < 1) {
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38!");
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u7ae3\u5de5\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UacFinishOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

