/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.tydic.uac.atom.bo.task.UacQryTacheIntfReqBO;
import com.tydic.uac.atom.bo.task.UacQryTacheIntfRspBO;
import com.tydic.uac.atom.task.UacQryTacheIntfAtomService;
import com.tydic.uac.bo.task.InterfaceDefBO;
import com.tydic.uac.dao.task.UacConfInterfaceMapper;
import com.tydic.uac.dao.task.UacConfTacheInterMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.ConfInterfacePO;
import com.tydic.uac.po.task.ConfTacheInterPO;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uacQryTacheIntfAtomService")
public class UacQryTacheIntfAtomServiceImpl
implements UacQryTacheIntfAtomService {
    private UacConfTacheInterMapper confTacheInterMapper;
    private UacConfInterfaceMapper confInterfaceMapper;

    @Autowired
    public UacQryTacheIntfAtomServiceImpl(UacConfTacheInterMapper confTacheInterMapper, UacConfInterfaceMapper confInterfaceMapper) {
        this.confTacheInterMapper = confTacheInterMapper;
        this.confInterfaceMapper = confInterfaceMapper;
    }

    @Override
    public UacQryTacheIntfRspBO qryTacheIntf(UacQryTacheIntfReqBO reqBO) {
        if (reqBO.getFlowFlag() == null || StringUtils.isBlank((CharSequence)reqBO.getTacheCode())) {
            throw new BusinessException("8000", "\u73af\u8282\u7f16\u7801\u548c\u6d41\u7a0b\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UacQryTacheIntfRspBO rspBO = new UacQryTacheIntfRspBO();
        ConfTacheInterPO confTacheInterPO = new ConfTacheInterPO();
        confTacheInterPO.setTacheCode(reqBO.getTacheCode());
        confTacheInterPO.setFlowFlag(reqBO.getFlowFlag());
        List<ConfTacheInterPO> tacheInterList = this.confTacheInterMapper.getListBy(confTacheInterPO);
        if (tacheInterList != null && tacheInterList.size() > 0) {
            LinkedList<InterfaceDefBO> interfaceList = new LinkedList<InterfaceDefBO>();
            for (ConfTacheInterPO tacheInter : tacheInterList) {
                ConfInterfacePO confInterfacePO = new ConfInterfacePO();
                confInterfacePO.setInterCode(tacheInter.getInterCode());
                confInterfacePO.setSysCode(tacheInter.getSysCode());
                if ((confInterfacePO = this.confInterfaceMapper.getModelBy(confInterfacePO)) == null) continue;
                InterfaceDefBO interfaceDefBO = new InterfaceDefBO();
                BeanUtils.copyProperties((Object)confInterfacePO, (Object)interfaceDefBO);
                interfaceDefBO.setSort(tacheInter.getSort());
                interfaceDefBO.setFlowFlag(tacheInter.getFlowFlag());
                interfaceList.add(interfaceDefBO);
            }
            rspBO.setInterfaceList(interfaceList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u73af\u8282\u63a5\u53e3\u6210\u529f");
        return rspBO;
    }
}

