/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.tydic.uac.atom.bo.task.UacQryTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacQryTaskInstRspBO;
import com.tydic.uac.atom.task.UacQryTaskInstAtomService;
import com.tydic.uac.bo.task.TaskInstBO;
import com.tydic.uac.dao.task.UacConfTacheStateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.ConfTacheStatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uacQryTaskInstAtomService")
public class UacQryTaskInstAtomServiceImpl
implements UacQryTaskInstAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UacQryTaskInstAtomServiceImpl.class);
    private UacConfTacheStateMapper confTacheStateMapper;
    private UacOrdTaskMapper ordTaskMapper;

    @Autowired
    public UacQryTaskInstAtomServiceImpl(UacConfTacheStateMapper confTacheStateMapper, UacOrdTaskMapper ordTaskMapper) {
        this.confTacheStateMapper = confTacheStateMapper;
        this.ordTaskMapper = ordTaskMapper;
    }

    @Override
    public UacQryTaskInstRspBO qryTaskInst(UacQryTaskInstReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        if (orderId == null) {
            throw new BusinessException("8000", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UacQryTaskInstRspBO rspBO = new UacQryTaskInstRspBO();
        String curState = reqBO.getCurState();
        String taskId = reqBO.getTaskId();
        OrdTaskPO ordTaskPO = new OrdTaskPO();
        ordTaskPO.setOrderId(orderId);
        if (reqBO.getObjId() != null) {
            ordTaskPO.setObjId(reqBO.getObjId());
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                ordTaskPO.setTaskId(taskId);
                ordTaskPO = this.ordTaskMapper.getModelBy(ordTaskPO);
                if (ordTaskPO == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355Id\u4e3a" + orderId + "\uff0c\u4efb\u52a1Id\u4e3a" + taskId + "\u7684\u4efb\u52a1\u5b9e\u4f8b");
                    return rspBO;
                }
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTacheCode())) {
                ordTaskPO.setTacheCode(reqBO.getTacheCode());
            } else if (StringUtils.isNotBlank((CharSequence)curState)) {
                ConfTacheStatePO tacheStatePO = new ConfTacheStatePO();
                tacheStatePO.setOrdState(curState);
                tacheStatePO.setStateType("A00");
                tacheStatePO = this.confTacheStateMapper.getModelBy(tacheStatePO);
                if (tacheStatePO != null) {
                    ordTaskPO.setTacheCode(tacheStatePO.getTacheCode());
                }
            } else if ((ordTaskPO = this.ordTaskMapper.queryDealTaskId(ordTaskPO)) == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355Id\u4e3a" + orderId + "\u7684\u5f85\u5904\u7406\u4efb\u52a1\u5b9e\u4f8b");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)ordTaskPO.getTaskId()) && StringUtils.isNotBlank((CharSequence)ordTaskPO.getTacheCode())) {
                ordTaskPO = this.ordTaskMapper.getModelBy(ordTaskPO);
            }
            if (ordTaskPO == null || StringUtils.isBlank((CharSequence)ordTaskPO.getTaskId())) {
                ordTaskPO = new OrdTaskPO();
                ordTaskPO.setOrderId(orderId);
                ordTaskPO = this.ordTaskMapper.queryDealTaskId(ordTaskPO);
                if (ordTaskPO == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355Id\u4e3a" + orderId + "\u7684\u5f85\u5904\u7406\u4efb\u52a1\u5b9e\u4f8b");
                    return rspBO;
                }
            }
            TaskInstBO taskInstBO = new TaskInstBO();
            BeanUtils.copyProperties((Object)ordTaskPO, (Object)taskInstBO);
            rspBO.setTaskInstBO(taskInstBO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5b9e\u4f8b\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

