/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.osworkflow.engine.runtime.TaskService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskRspBO;
import com.tydic.uac.atom.task.UacCreateTaskAtomService;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.busi.UacAutoTaskAuditCreateBusiService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalLogMapper;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.dao.ApprovalStepTempDateMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalLogPO;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uac.po.ApprovalStepTempDataPO;
import com.tydic.uac.util.UacCommTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UacAutoTaskAuditCreateBusiServiceImpl
implements UacAutoTaskAuditCreateBusiService {
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private ApprovalStepTempDateMapper approvalStepTempDateMapper;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String sysCode;
    private static final Logger LOGGER = LoggerFactory.getLogger(UacAutoTaskAuditCreateBusiServiceImpl.class);
    @Autowired
    private UacCreateTaskAtomService uacCreateTaskAtomService;
    @Autowired
    private ApprovalLogMapper approvalLogMapper;
    @Autowired
    private TaskService taskService;

    @Transactional
    public UacNoTaskAuditCreateRspBO auditOrderCreate(UacNoTaskAuditCreateReqBO reqBO) {
        this.val(reqBO);
        UacNoTaskAuditCreateRspBO rspBO = new UacNoTaskAuditCreateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        StepWithOutInstance stepInstance = this.processService.newProcessStartBuilder().procDefId(reqBO.getProcDefId()).procDefKey(reqBO.getProcDefKey()).sysCode(this.sysCode).startWithOutInstance();
        Sequence sequence = Sequence.getInstance();
        stepInstance = this.proc(stepInstance, reqBO);
        if (stepInstance.getIsFinish() != null && stepInstance.getIsFinish().booleanValue()) {
            rspBO.setFinish(Boolean.valueOf(true));
            return rspBO;
        }
        rspBO.setFinish(Boolean.valueOf(false));
        ArrayList<Long> orderIds = new ArrayList<Long>();
        for (UacNoTaskAuditCreateInfoReqBO bo : reqBO.getCreateBusiReqBO()) {
            Long orderId = bo.getOrderId() != null ? bo.getOrderId() : Long.valueOf(sequence.nextId());
            orderIds.add(orderId);
            ApprovalOrderPO approvalOrderPO = this.saveApprovalOrder(bo, orderId, reqBO.getAuditConsumerType(), sequence.nextId(), stepInstance.getStepId());
            this.saveApprovalObj(bo, orderId, approvalOrderPO.getAuditOrderId(), sequence);
            this.saveTempData(orderId, approvalOrderPO.getAuditOrderId(), stepInstance);
            this.createTask(orderId, approvalOrderPO.getAuditOrderId(), stepInstance, reqBO);
            if (reqBO.getIsSaveCreateLog() == null || !reqBO.getIsSaveCreateLog().booleanValue()) continue;
            this.saveLog(approvalOrderPO, reqBO, stepInstance, bo);
        }
        BeanUtils.copyProperties((Object)stepInstance, (Object)rspBO);
        rspBO.setCustomAttributes(stepInstance.getCustomAttributes());
        rspBO.setOrderId(orderIds);
        return rspBO;
    }

    private StepWithOutInstance proc(StepWithOutInstance stepInstance, UacNoTaskAuditCreateReqBO reqBO) {
        return this.taskService.newTaskCompleteBuilder().procDefId(stepInstance.getProcDefId()).procDefKey(stepInstance.getProcDefKey()).sysCode(this.sysCode).stepId(stepInstance.getStepId()).variables(reqBO.getVariables()).completeWithOutInstance();
    }

    private void saveLog(ApprovalOrderPO approvalOrderPO, UacNoTaskAuditCreateReqBO reqBO, StepWithOutInstance stepInstance, UacNoTaskAuditCreateInfoReqBO infoReqBO) {
        List candidates;
        Sequence sequence = Sequence.getInstance();
        ApprovalLogPO logPO = new ApprovalLogPO();
        BeanUtils.copyProperties((Object)approvalOrderPO, (Object)logPO);
        logPO.setId(sequence.nextId());
        logPO.setOrderId(approvalOrderPO.getOrderId());
        logPO.setOperid(reqBO.getCreateOperId());
        logPO.setOperName(reqBO.getCreateOperName());
        logPO.setAuditOrderId(approvalOrderPO.getAuditOrderId());
        if (StringUtils.isNotBlank((CharSequence)infoReqBO.getRemark())) {
            logPO.setAuditAdvice(infoReqBO.getRemark());
        } else {
            logPO.setAuditAdvice("\u53d1\u8d77\u5ba1\u6279");
        }
        logPO.setNextStepId(stepInstance.getStepId());
        logPO.setNextStepName(stepInstance.getStepName());
        logPO.setNextStepDesc(stepInstance.getStepDesc());
        logPO.setFinish(stepInstance.getIsFinish() != false ? 1 : 0);
        logPO.setOperDept(reqBO.getCreateOperDept());
        logPO.setDealTime(new Date());
        if (stepInstance.getCustomAttributes() != null && !stepInstance.getCustomAttributes().isEmpty()) {
            int i = 0;
            StringBuilder id = new StringBuilder();
            StringBuilder name = new StringBuilder();
            for (String key : stepInstance.getCustomAttributes().keySet()) {
                name.append(",").append(stepInstance.getCustomAttributes().get(key));
                id.append(",").append(key);
                if (++i != 50) continue;
                break;
            }
            logPO.setNextStationId(id.substring(id.indexOf(",") + 1));
            logPO.setNextStationName(name.substring(name.indexOf(",") + 1));
        }
        if (stepInstance.getTaskList() != null && !stepInstance.getTaskList().isEmpty() && (candidates = ((Task)stepInstance.getTaskList().get(0)).getCandidates()) != null && candidates.size() > 0) {
            int i = 0;
            StringBuilder id = new StringBuilder();
            StringBuilder name = new StringBuilder();
            for (String str : candidates) {
                JSONObject jsonObject = JSON.parseObject((String)str);
                jsonObject.getString("userName");
                jsonObject.getString("userId");
                name.append(",").append(jsonObject.getString("userName"));
                id.append(",").append(jsonObject.getString("userId"));
                if (++i == 50) break;
                logPO.setNextOperId(id.substring(id.indexOf(",") + 1));
                logPO.setNextOperName(name.substring(name.indexOf(",") + 1));
            }
        }
        try {
            this.approvalLogMapper.insert(logPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private void createTask(Long orderId, Long auditOrderId, StepWithOutInstance instance, UacNoTaskAuditCreateReqBO reqBO) {
        UacCreateTaskReqBO uacCreateTaskReqBO = new UacCreateTaskReqBO();
        uacCreateTaskReqBO.setAuditOrderId(auditOrderId);
        uacCreateTaskReqBO.setOrderId(orderId);
        uacCreateTaskReqBO.setCandidates(reqBO.getCandidates());
        uacCreateTaskReqBO.setInstance(instance);
        UacCreateTaskRspBO uacCreateTaskRspBO = this.uacCreateTaskAtomService.createTask(uacCreateTaskReqBO);
        if (!"0000".equals(uacCreateTaskRspBO.getRespCode())) {
            throw new BusinessException("6001", "\u521b\u5efa\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
        }
    }

    private void saveTempData(Long orderId, Long auditOrderId, StepWithOutInstance instance) {
        ApprovalStepTempDataPO dataPO = new ApprovalStepTempDataPO();
        dataPO.setAuditOrderId(auditOrderId);
        dataPO.setStepId(instance.getStepId());
        dataPO.setStepName(instance.getStepName());
        dataPO.setCreateTime(new Date());
        dataPO.setOrderId(orderId);
        dataPO.setStepDesc(instance.getStepDesc());
        try {
            this.approvalStepTempDateMapper.insert(dataPO);
        }
        catch (Exception e) {
            LOGGER.debug("\u4fdd\u5b58\u6b65\u9aa4\u5931\u8d25" + e);
            throw new BusinessException("6001", "\u4fdd\u5b58\u6b65\u9aa4\u5931\u8d25" + e);
        }
    }

    private void saveApprovalObj(UacNoTaskAuditCreateInfoReqBO reqBO, Long orderId, Long auditOrderId, Sequence sequence) {
        ArrayList<ApprovalObjPO> list = new ArrayList<ApprovalObjPO>();
        for (ApprovalObjBO approvalObjBO : reqBO.getApprovalObjInfo()) {
            ApprovalObjPO approvalObjPO = new ApprovalObjPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
            BeanUtils.copyProperties((Object)approvalObjBO, (Object)approvalObjPO);
            approvalObjPO.setAuditOrderId(auditOrderId);
            approvalObjPO.setId(sequence.nextId());
            approvalObjPO.setObjType(reqBO.getObjType());
            approvalObjPO.setOrderId(orderId);
            list.add(approvalObjPO);
        }
        try {
            this.approvalObjMapper.insertBatch(list);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fdd\u5b58\u5ba1\u6279\u5bf9\u8c61\u5931\u8d25");
        }
    }

    private ApprovalOrderPO saveApprovalOrder(UacNoTaskAuditCreateInfoReqBO reqBO, Long orderId, Integer auditConsumerType, Long auditId, String stepId) {
        ApprovalOrderPO approvalOrderPO = new ApprovalOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approvalOrderPO);
        approvalOrderPO.setOrderId(orderId);
        approvalOrderPO.setAuditOrderId(auditId);
        approvalOrderPO.setObjType(reqBO.getObjType());
        approvalOrderPO.setObjNum(UacCommTools.string2Integer(reqBO.getObjNum()));
        approvalOrderPO.setStatus(UacCommConstant.STATUS.UNDER_REVIEW);
        approvalOrderPO.setAuditConsumerType(auditConsumerType);
        approvalOrderPO.setStepId(stepId);
        approvalOrderPO.setCreateTime(new Date());
        try {
            this.approvalOrderMapper.insert(approvalOrderPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fdd\u5b58\u5ba1\u6279\u5355\u8868\u5931\u8d25");
        }
        return approvalOrderPO;
    }

    private void val(UacNoTaskAuditCreateReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProcDefId() == null && reqBO.getProcDefKey() == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2procDefKey,procDefId\u90fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCreateBusiReqBO())) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2createBusiReqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

