/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.ActivityCenterSearchEsService;
import com.tydic.commodity.atom.UccFieldsSearchCacheAtomService;
import com.tydic.commodity.bo.ability.ActivityCenterSearchEsReqBO;
import com.tydic.commodity.bo.ability.ActivityCenterSearchEsRspBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.search.SearchCommodityService;
import com.tydic.commodity.search.bo.CommodityRspBo;
import com.tydic.commodity.search.bo.SearchEsReqBO;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=ActivityCenterSearchEsService.class)
public class ActivityCenterSearchEsServiceImpl
implements ActivityCenterSearchEsService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCenterSearchEsServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(ActivityCenterSearchEsServiceImpl.class);
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccFieldsSearchCacheAtomService uccFieldsSearchCacheAtomService;
    private static Integer esSeaarchSize = 10000;

    public ActivityCenterSearchEsRspBO qryBySearchBar(ActivityCenterSearchEsReqBO reqBo) {
        ActivityCenterSearchEsRspBO rspBO = new ActivityCenterSearchEsRspBO();
        if (reqBo.getSkuList() != null && reqBo.getIgnoreList() != null && reqBo.getSkuList().size() > 0 && reqBo.getIgnoreList().size() > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e0d\u80fd\u540c\u65f6\u8fc7\u6ee4\u67e5\u8be2");
            return rspBO;
        }
        SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)searchEsReqBO));
        SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
        if (searchEsRspBo == null) {
            LOGGER.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBO);
        List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
        List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        rspBO.setResult(result);
        int size = reqBo.getPageSize();
        int no = reqBo.getPageNo();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        if (esSeaarchSize.compareTo(searchEsRspBo.getTotal()) > 0) {
            totalPage = searchEsRspBo.getTotal() / size;
            add = searchEsRspBo.getTotal() % size == 0 ? 0 : 1;
            total = searchEsRspBo.getTotal();
        } else {
            totalPage = esSeaarchSize / size;
            total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
            if (total.compareTo(searchEsRspBo.getTotal()) > 0) {
                total = searchEsRspBo.getTotal();
            }
        }
        rspBO.setTotal(totalPage + add);
        rspBO.setPageNo(no);
        if (searchEsRspBo.getQueryParams() != null && searchEsRspBo.getPropParams() != null) {
            searchEsRspBo.getQueryParams().addAll(searchEsRspBo.getPropParams());
        }
        rspBO.setRecordsTotal(total.intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        LOGGER.info("\u8d2d\u7269\u8f66\u67e5\u8be2\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setL1CategoryId(commodityRspBo.getL1_category_id());
                searchBarEsRspInfo.setL2CategoryId(commodityRspBo.getL2_category_id());
                searchBarEsRspInfo.setL3CategoryId(commodityRspBo.getL3_category_id());
                searchBarEsRspInfo.setL1CategoryName(commodityRspBo.getL1_category_name());
                searchBarEsRspInfo.setL2CategoryName(commodityRspBo.getL2_category_name());
                searchBarEsRspInfo.setL3CategoryName(commodityRspBo.getL3_category_name());
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setViewOrder(Integer.valueOf(commodityRspBo.getView_order()));
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }
}

