/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.tydic.commodity.ability.api.UccAgreementCommodityPictureAbilityService;
import com.tydic.commodity.bo.FTPTreeBO;
import com.tydic.commodity.bo.ability.AgreementCommodityPicBO;
import com.tydic.commodity.bo.ability.UccAgreementCommodityPicReqBO;
import com.tydic.commodity.bo.ability.UccAgreementCommodityPicRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.po.AgreementCommodityPicPO;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.FileUtils;
import com.tydic.commodity.util.ListCloneUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccAgreementCommodityPictureAbilityService.class)
public class UccAgreementCommodityPictureAbilityServiceImpl
implements UccAgreementCommodityPictureAbilityService {
    private static final String ftpFilePath = "/home/tydicftp/agreement";
    @Value(value="${ftp.fileHost}")
    private String fileHost;
    @Value(value="${ftp.fileUser}")
    private String fileUser;
    @Value(value="${ftp.filePwd}")
    private String filePwd;
    @Value(value="${ftp.filePort}")
    private String filePort;
    @Value(value="${ftp.timeOut}")
    private String timeOut;
    private String[] picSuffix = new String[]{"-001", "-002", "-003", "-004", "-005", "-006"};
    @Autowired
    private FileClient fileClient;
    private static String filedir = "ucc/";
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    public UccAgreementCommodityPicRspBO exportAgreeNotPictureCommodity(UccAgreementCommodityPicReqBO reqBO) {
        UccAgreementCommodityPicRspBO rspBO = new UccAgreementCommodityPicRspBO();
        AgreementCommodityPicPO agreementCommodityPicPO = new AgreementCommodityPicPO();
        agreementCommodityPicPO.setAgreementId(reqBO.getAgreementId());
        agreementCommodityPicPO.setPlatformAgreementNumber(reqBO.getPlatformAgreementNumber());
        agreementCommodityPicPO.setEnterpriseAgreementNumber(reqBO.getEnterpriseAgreementNumber());
        agreementCommodityPicPO.setOrganizationName(reqBO.getOrganizationName());
        List<AgreementCommodityPicPO> agreementCommodityPicPOS = this.uccCommodityMapper.queryNotAgreementCommodityPic(agreementCommodityPicPO);
        if (CollectionUtils.isNotEmpty(agreementCommodityPicPOS)) {
            try {
                List agreementCommodityPicBOS = ListCloneUtils.clonePOListToBOList(agreementCommodityPicPOS, AgreementCommodityPicBO.class);
                rspBO.setRows(agreementCommodityPicBOS);
                rspBO.setRecordsTotal(agreementCommodityPicBOS.size());
                rspBO.setTotal(agreementCommodityPicBOS.size());
                rspBO.setAgreementCommodityPicBOS(agreementCommodityPicBOS);
            }
            catch (Exception e) {
                rspBO.setRespDesc("8888");
                rspBO.setRespCode("\u5931\u8d25");
                return rspBO;
            }
        }
        rspBO.setRespDesc("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }

    public String getUrl(String key) {
        return UccAgreementCommodityPictureAbilityServiceImpl.splitUrl(key);
    }

    public static String splitUrl(String url) {
        if (url.indexOf("?Expires") != -1) {
            return url.split("Expires")[0].substring(0, url.split("Expires")[0].length() - 1);
        }
        return url;
    }

    public UccAgreementCommodityPicRspBO readListFTP(UccAgreementCommodityPicReqBO reqBO) {
        UccAgreementCommodityPicRspBO uccAgreementCommodityPicRspBO = new UccAgreementCommodityPicRspBO();
        FTPTreeBO ftpTreeBO = new FTPTreeBO("commodity");
        FtpConfig ftpConfig = new FtpConfig(this.fileHost, this.fileUser, this.filePwd, Integer.valueOf(this.filePort), Integer.valueOf(this.timeOut));
        FTPTreeBO treeBO = null;
        try {
            treeBO = FileUtils.recursionTree((String)ftpFilePath, (FTPTreeBO)ftpTreeBO, (FtpConfig)ftpConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        uccAgreementCommodityPicRspBO.setRespDesc("\u6210\u529f");
        uccAgreementCommodityPicRspBO.setRespCode("0000");
        uccAgreementCommodityPicRspBO.setFtpTreeBO(treeBO);
        return uccAgreementCommodityPicRspBO;
    }

    public UccAgreementCommodityPicRspBO pictureCheck(UccAgreementCommodityPicReqBO reqBO) {
        UccAgreementCommodityPicRspBO rspBO = this.exportAgreeNotPictureCommodity(reqBO);
        List agreementCommodityPicPOS = rspBO.getRows();
        Map<String, File> map = this.downFTPFile(reqBO);
        if (map == null || map.size() <= 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u8bfb\u53d6\u5230\u56fe\u7247");
            return rspBO;
        }
        InputStream bis = null;
        int nonePicCommodityCounts = 0;
        block18: for (AgreementCommodityPicPO agreementCommodityPicPO : agreementCommodityPicPOS) {
            UccCommodityPicPo commodityPicPo;
            if (!StringUtils.isNotBlank((String)agreementCommodityPicPO.getCommodityCode())) continue;
            this.uccCommodityPicMapper.deleteByCommodityId(agreementCommodityPicPO.getCommodityId(), agreementCommodityPicPO.getSupplierShopId());
            if (map.get(agreementCommodityPicPO.getCommodityCode()) == null) {
                for (int i = 0; i < this.picSuffix.length; ++i) {
                    if (map.get(agreementCommodityPicPO.getCommodityCode() + this.picSuffix[i]) != null) {
                        File file = map.get(agreementCommodityPicPO.getCommodityCode() + this.picSuffix[i]);
                        try {
                            String originalFilename = file.getName();
                            bis = new BufferedInputStream(new FileInputStream(file));
                            String ossPath = this.fileClient.uploadFileByInputStream(filedir, originalFilename, bis);
                            if (!StringUtils.isNotBlank((String)ossPath)) continue;
                            String filePath = this.getUrl(ossPath);
                            commodityPicPo = new UccCommodityPicPo();
                            commodityPicPo.setCommodityPicId(this.uccBatchSequence.nextId());
                            commodityPicPo.setCommodityId(agreementCommodityPicPO.getCommodityId());
                            commodityPicPo.setCreateTime(new Date());
                            commodityPicPo.setCommodityPicUrl(filePath);
                            if (i == 0) {
                                commodityPicPo.setCommodityPicType(1);
                            } else {
                                commodityPicPo.setCommodityPicType(2);
                            }
                            commodityPicPo.setSupplierShopId(agreementCommodityPicPO.getSupplierShopId());
                            commodityPicPo.setUpdateTime(new Date());
                            this.uccCommodityPicMapper.addcommodityPic(commodityPicPo);
                            continue;
                        }
                        catch (Exception e) {
                            throw new BusinessException("8888", "\u56fe\u7247\u6821\u9a8c\u4e0a\u4f20oss\u5931\u8d25");
                        }
                        finally {
                            try {
                                bis.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (i != 0) continue block18;
                    ++nonePicCommodityCounts;
                    continue block18;
                }
                continue;
            }
            File file = map.get(agreementCommodityPicPO.getCommodityCode());
            try {
                String originalFilename = file.getName();
                String ossPath = this.fileClient.uploadFileByInputStream(filedir, originalFilename, bis = new BufferedInputStream(new FileInputStream(file)));
                if (!StringUtils.isNotBlank((String)ossPath)) continue;
                String filePath = this.getUrl(ossPath);
                this.uccCommodityPicMapper.deleteByCommodityId(agreementCommodityPicPO.getCommodityId(), agreementCommodityPicPO.getSupplierShopId());
                commodityPicPo = new UccCommodityPicPo();
                commodityPicPo.setCommodityPicId(this.uccBatchSequence.nextId());
                commodityPicPo.setCommodityId(agreementCommodityPicPO.getCommodityId());
                commodityPicPo.setCreateTime(new Date());
                commodityPicPo.setCommodityPicUrl(filePath);
                commodityPicPo.setCommodityPicType(1);
                commodityPicPo.setSupplierShopId(agreementCommodityPicPO.getSupplierShopId());
                commodityPicPo.setUpdateTime(new Date());
                this.uccCommodityPicMapper.addcommodityPic(commodityPicPo);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u56fe\u7247\u6821\u9a8c\u4e0a\u4f20oss\u5931\u8d25");
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((File)entry.getValue()).isFile() || !((File)entry.getValue()).exists()) continue;
            ((File)entry.getValue()).delete();
        }
        rspBO.setNonePicCommodityCounts(Integer.valueOf(nonePicCommodityCounts));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public Map<String, File> downFTPFile(UccAgreementCommodityPicReqBO reqBO) {
        UccAgreementCommodityPicRspBO uccAgreementCommodityPicRspBO = new UccAgreementCommodityPicRspBO();
        FtpConfig ftpConfig = new FtpConfig(this.fileHost, this.fileUser, this.filePwd, Integer.valueOf(this.filePort), Integer.valueOf(this.timeOut));
        String listPath = "/" + reqBO.getFtpFilePath();
        listPath.replaceAll("/", "/");
        Map map = null;
        try {
            map = FileUtils.downFile((String)(ftpFilePath + listPath), (FtpConfig)ftpConfig, new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

