/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.ability.api.UccAvailableCommdQryAbilityService;
import com.tydic.commodity.atom.UccAvailableCommdQryAtomService;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryReqBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryRspBO;
import com.tydic.commodity.bo.ability.UccAvailableCommdQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccAvailableCommdQryAbilityRspBO;
import com.tydic.commodity.bo.busi.AvailableCommdBO_busi;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccAvailableCommdQryAbilityService.class)
public class UccAvailableCommdQryAbilityServiceImpl
implements UccAvailableCommdQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAvailableCommdQryAbilityServiceImpl.class);
    @Autowired
    private UccAvailableCommdQryAtomService uccAvailableCommdQryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAvailableCommdQryAbilityServiceImpl.class);

    public UccAvailableCommdQryAbilityRspBO qryAvailableCommd(UccAvailableCommdQryAbilityReqBO reqBO) {
        String supplierCode;
        Long supplierId;
        UccAvailableCommdQryAbilityRspBO rspBO = new UccAvailableCommdQryAbilityRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        try {
            SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            supplierId = supplierShopPo.getSupplierId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        try {
            SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId);
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        ArrayList<String> extSkuIds = new ArrayList<String>();
        try {
            for (Long skuId : reqBO.getSkuIds()) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setSkuId(skuId);
                List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                    rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                String extSkuId = uccSkuPoList.get(0).getExtSkuId();
                if (StringUtils.isEmpty((CharSequence)extSkuId)) {
                    rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                extSkuIds.add(extSkuId);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        try {
            UccAvailableCommdQryReqBO uccAvailableCommdQryReqBO = new UccAvailableCommdQryReqBO();
            uccAvailableCommdQryReqBO.setSupplierCode(supplierCode);
            uccAvailableCommdQryReqBO.setSkuIds(extSkuIds);
            UccAvailableCommdQryRspBO uccAvailableCommdQryRspBO = this.uccAvailableCommdQryAtomService.qryAvailableCommd(uccAvailableCommdQryReqBO);
            BeanUtils.copyProperties((Object)((Object)uccAvailableCommdQryRspBO), (Object)rspBO);
            Iterator<AvailableCommdBO_busi> var1 = uccAvailableCommdQryRspBO.getAvailableCommdInfos().iterator();
            ArrayList<AvailableCommdBO_busi> availableCommdBO_busis = new ArrayList<AvailableCommdBO_busi>();
            while (var1.hasNext()) {
                AvailableCommdBO_busi availableCommdBO_busi = var1.next();
                String skuId = this.extSkuToSku(availableCommdBO_busi.getSkuId(), reqBO.getSupplierShopId()).toString();
                availableCommdBO_busi.setSkuId(skuId);
                availableCommdBO_busis.add(availableCommdBO_busi);
            }
            rspBO.setAvailableCommdInfos(availableCommdBO_busis);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    public String judge(UccAvailableCommdQryAbilityReqBO reqBO) {
        String s = "";
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            s = "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSupplierShopId() == null) {
            s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return s;
    }

    public Long extSkuToSku(String extSkuId, Long supplierShopId) {
        if (StringUtils.isEmpty((CharSequence)extSkuId) || supplierShopId == null) {
            return null;
        }
        Long skuId = -1L;
        try {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSupplierShopId(supplierShopId);
            uccSkuPo.setExtSkuId(extSkuId);
            List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                return skuId;
            }
            skuId = uccSkuPoList.get(0).getSkuId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return skuId;
    }
}

