/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.UccMallESearchTOCommodityAbilityService;
import com.tydic.commodity.bo.ability.UccCommodityToEsBO;
import com.tydic.commodity.bo.ability.UccCommodityToEsRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.search.config.ElasticsearchUtil;
import com.tydic.commodity.search.config.EsConfig;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccMallESearchTOCommodityAbilityService.class)
public class UccMallESearchTOCommodityAbilityServiceImpl
implements UccMallESearchTOCommodityAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallESearchTOCommodityAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    public UccCommodityToEsRspBO autoCommodityToEs() {
        List<UccCommodityToEsBO> uccCommodityToEsBOS = this.uccSkuMapper.selectSuggestSkuToEs();
        this.syncCommodityInfoToEs(uccCommodityToEsBOS);
        UccCommodityToEsRspBO rspBO = new UccCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u540c\u6b65\u5546\u54c1\u7c7b\u578b\u5230ES");
        return rspBO;
    }

    private void syncCommodityInfoToEs(List<UccCommodityToEsBO> toEsBOList) {
        for (UccCommodityToEsBO uccCommodityToEsBO : toEsBOList) {
            String jsonStr = JSONObject.toJSONString((Object)uccCommodityToEsBO);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = String.valueOf(uccCommodityToEsBO.getCommodityTypeId());
            String id = this.elasticsearchUtil.addData("search", "suggest", esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + uccCommodityToEsBO.getCommodityTypeName() + "|" + uccCommodityToEsBO.getCommodityTypeId() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }
}

