/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.commodity.ability.api.UccQryGiftInfoAbilityService;
import com.tydic.commodity.bo.ability.UccQryGiftInfoReqBO;
import com.tydic.commodity.bo.ability.UccQryGiftInfoRspBO;
import com.tydic.commodity.bo.busi.GiftVO;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.external.bo.QryGiftFromEcommerceReqBo;
import com.tydic.commodity.external.bo.QryGiftFromEcommerceRspBo;
import com.tydic.commodity.external.service.UccQryGiftFromEcommerceService;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccQryGiftInfoAbilityService.class)
public class UccQryGiftInfoAbilityServiceImpl
implements UccQryGiftInfoAbilityService {
    @Autowired
    private UccQryGiftFromEcommerceService uccQryGiftFromEcommerceService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccQryGiftInfoRspBO qryGift(UccQryGiftInfoReqBO reqBo) {
        UccQryGiftInfoRspBO rspBo = new UccQryGiftInfoRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId() || null == reqBo.getProvince() || null == reqBo.getCity() || null == reqBo.getCounty() || null == reqBo.getTown()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u3001\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBo.getSkuId());
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        uccSkuPo = skuPoList.get(0);
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        QryGiftFromEcommerceReqBo qryGiftFromEcommerceReqBo = new QryGiftFromEcommerceReqBo();
        qryGiftFromEcommerceReqBo.setSupplierId(supplierId);
        qryGiftFromEcommerceReqBo.setProvince(reqBo.getProvince());
        qryGiftFromEcommerceReqBo.setCity(reqBo.getCity());
        qryGiftFromEcommerceReqBo.setCounty(reqBo.getCounty());
        qryGiftFromEcommerceReqBo.setTown(reqBo.getTown());
        qryGiftFromEcommerceReqBo.setSupplierCode(supplierCode);
        qryGiftFromEcommerceReqBo.setSkuId(uccSkuPo.getExtSkuId());
        QryGiftFromEcommerceRspBo qryGiftFromEcommerceRspBo = this.uccQryGiftFromEcommerceService.qryGift(qryGiftFromEcommerceReqBo);
        if (!"0000".equals(qryGiftFromEcommerceRspBo.getRespCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(qryGiftFromEcommerceRspBo.getRespDesc());
            return rspBo;
        }
        rspBo.setMaxNum(qryGiftFromEcommerceRspBo.getMaxNum());
        rspBo.setMinNum(qryGiftFromEcommerceRspBo.getMinNum());
        rspBo.setPromoStartTime(qryGiftFromEcommerceRspBo.getPromoStartTime());
        rspBo.setPromoEndTime(qryGiftFromEcommerceRspBo.getPromoEndTime());
        rspBo.setGifts(JSONArray.parseArray((String)JSON.toJSONString((Object)qryGiftFromEcommerceRspBo.getGifts()), GiftVO.class));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

