/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.atom.BO.UccDealSkuPriceReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuPriceRespBO;
import com.tydic.commodity.atom.BO.UccPriceBO;
import com.tydic.commodity.atom.UccDealSkuPriceAtomService;
import com.tydic.commodity.utils.HttpTool;
import com.tydic.commodity.utils.UccPropertiesUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class UccDealSkuPriceAtomServiceImpl
implements UccDealSkuPriceAtomService {
    @Override
    public UccDealSkuPriceRespBO dealSkuPrice(UccDealSkuPriceReqBO uccDealSkuPriceReqBO) {
        String getPriceUrl = UccPropertiesUtil.getProperty("outinterface.getPriceUrl");
        JdbcTemplate jdbcTemplate = uccDealSkuPriceReqBO.getJdbcTemplate();
        List skuCodeList = uccDealSkuPriceReqBO.getSkuCodeList();
        String skuListStr = uccDealSkuPriceReqBO.getSkuListStr();
        String supplierCode = uccDealSkuPriceReqBO.getSupplierCode();
        UccDealSkuPriceRespBO uccDealSkuPriceRespBO = new UccDealSkuPriceRespBO();
        JSONObject reqObj = new JSONObject();
        reqObj.put("hsn", (Object)supplierCode);
        reqObj.put("sku", (Object)skuCodeList);
        reqObj.put("serialNumber", (Object)"sjd79and83cgem");
        reqObj.put("timeStamp", (Object)DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-ddHH:mm:ss"));
        String respJson = HttpTool.sendPostJson(getPriceUrl, reqObj.toJSONString());
        JSONObject resultObj = JSONObject.parseObject((String)respJson);
        boolean success = (Boolean)resultObj.get((Object)"success");
        if (!success) {
            uccDealSkuPriceRespBO.setRespCode("8888");
            uccDealSkuPriceRespBO.setRespDesc("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25," + resultObj.getString("resultMessage"));
            return uccDealSkuPriceRespBO;
        }
        List<UccPriceBO> uccPriceBOList = this.dealPriceResult(resultObj, supplierCode, skuCodeList);
        if (!CollectionUtils.isEmpty(uccPriceBOList)) {
            jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=? and sku_source=1 and sku in (" + skuListStr + ")", new Object[]{supplierCode});
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (UccPriceBO uccPriceBO : uccPriceBOList) {
                Object[] param = new Object[]{uccPriceBO.getSkuId(), uccPriceBO.getEcPrice(), uccPriceBO.getPrice(), supplierCode, 1};
                params.add(param);
            }
            jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_PRICE (sku,EXTERNAL_PRICE,CON_PRICE,SUPPLIER_CODE,sku_source) VALUES (?,?,?,?,?)", params);
        }
        uccDealSkuPriceRespBO.setRespCode("0000");
        uccDealSkuPriceRespBO.setRespDesc("\u6210\u529f");
        return uccDealSkuPriceRespBO;
    }

    private List<UccPriceBO> dealPriceResult(JSONObject respObj, String supplierCode, List<String> skuCodeList) {
        ArrayList<UccPriceBO> uccPriceBOList = new ArrayList<UccPriceBO>();
        JSONArray result = respObj.getJSONArray("result");
        if ("jd".equals(supplierCode)) {
            if (!result.isEmpty()) {
                for (int i = 0; i < result.size(); ++i) {
                    JSONObject jsonObject = result.getJSONObject(i);
                    UccPriceBO uccPriceBO = new UccPriceBO();
                    if (!skuCodeList.contains(jsonObject.getString("skuId"))) {
                        uccPriceBO.setEcPrice(Double.valueOf(0.0));
                        uccPriceBO.setPrice(Double.valueOf(0.0));
                    } else {
                        uccPriceBO.setEcPrice(jsonObject.getDouble("jdPrice"));
                        uccPriceBO.setPrice(jsonObject.getDouble("price"));
                    }
                    uccPriceBO.setSkuId(jsonObject.getString("skuId"));
                    uccPriceBOList.add(uccPriceBO);
                }
            } else {
                skuCodeList.forEach(sku -> {
                    UccPriceBO uccPriceBO = new UccPriceBO();
                    uccPriceBO.setEcPrice(Double.valueOf(0.0));
                    uccPriceBO.setPrice(Double.valueOf(0.0));
                    uccPriceBO.setSkuId(sku);
                    uccPriceBOList.add(uccPriceBO);
                });
            }
        } else if (!result.isEmpty()) {
            for (int i = 0; i < result.size(); ++i) {
                JSONObject jsonObject = result.getJSONObject(i);
                UccPriceBO uccPriceBO = new UccPriceBO();
                if (!skuCodeList.contains(jsonObject.getString("skuId"))) {
                    uccPriceBO.setEcPrice(Double.valueOf(0.0));
                    uccPriceBO.setPrice(Double.valueOf(0.0));
                } else {
                    uccPriceBO.setEcPrice(jsonObject.getDouble("ecPrice"));
                    uccPriceBO.setPrice(jsonObject.getDouble("price"));
                }
                uccPriceBO.setSkuId(jsonObject.getString("skuId"));
                uccPriceBOList.add(uccPriceBO);
            }
        } else {
            skuCodeList.forEach(sku -> {
                UccPriceBO uccPriceBO = new UccPriceBO();
                uccPriceBO.setEcPrice(Double.valueOf(0.0));
                uccPriceBO.setPrice(Double.valueOf(0.0));
                uccPriceBO.setSkuId(sku);
                uccPriceBOList.add(uccPriceBO);
            });
        }
        return uccPriceBOList;
    }
}

