/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomRspBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uac.config.ProperticeVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccSkuStatusUpdatesAtomService")
public class UccSkuStatusUpdatesAtomServiceImpl
implements UccSkuStatusUpdatesAtomService {
    @Autowired
    private UccSkuLogMapper skuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ProperticeVo properticeVo;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    public static final Logger LOGGER = LoggerFactory.getLogger(UccSkuStatusUpdatesAtomServiceImpl.class);

    @Override
    public UccSkuStatusUpdatesAtomRspBO dealUccSkuStatusUpdates(UccSkuStatusUpdatesAtomReqBO reqBO) {
        List<UccSkuPo> uccSkuPos;
        UccSkuStatusUpdatesAtomRspBO rspBO = new UccSkuStatusUpdatesAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u5546\u54c1");
            return rspBO;
        }
        this.addSkuLog(reqBO.getSupplierShopId(), reqBO.getSkuIds());
        try {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPo.setSkuStatus(reqBO.getState());
            this.uccSkuMapper.batchUpdateById(reqBO.getSkuIds(), uccSkuPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
        if (reqBO.getSyncAgrFlag() != null && reqBO.getSyncAgrFlag() == 0 && CollectionUtils.isNotEmpty(uccSkuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId()))) {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
                try {
                    this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getUacNotifyTopic(), this.properticeVo.getUacNotifyTag(), JSONObject.toJSONString((Object)notifyMessageBO)));
                }
                catch (Exception var16) {
                    throw new com.tydic.uac.exception.BusinessException("6001", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u53d1\u9001\u6d88\u606f\u961f\u5217MQ\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + var16.getMessage());
                }
            }
        }
        if (reqBO.getSyncAdtFlag() == null || reqBO.getSyncAdtFlag() == 0) {
            // empty if block
        }
        return rspBO;
    }

    private void addSkuLog(Long supplierShopId, List<Long> skuIds) {
        if (supplierShopId == null || CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(skuIds, supplierShopId);
        ArrayList<UccSkuLogPo> skuLogPoList = new ArrayList<UccSkuLogPo>();
        if (CollectionUtils.isNotEmpty(uccSkuPos)) {
            try {
                for (UccSkuPo uccSkuPo1 : uccSkuPos) {
                    UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo1, (Object)uccSkuLogPo);
                    Long batchId = this.uccBatchSequence.nextId();
                    uccSkuLogPo.setBatchId(batchId);
                    skuLogPoList.add(uccSkuLogPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
            }
            if (CollectionUtils.isNotEmpty(skuLogPoList)) {
                try {
                    this.skuLogMapper.addSkuLog(skuLogPoList);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u5355\u54c1\u65e5\u5fd7\u8868\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38");
                }
            }
        }
    }
}

