/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.imp.BO.CommodityInfoCheckReqBO;
import com.tydic.commodity.batchimp.imp.UccPutawayApproveProc;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import com.tydic.commodity.utils.UccPropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UccPutawayApproveOnlyProc
implements Runnable {
    private JdbcTemplate jdbcTemplate;
    private String supplierCode;
    private Integer supplierSource;
    private String pageNumber;
    private static final int DEAL_COUNT = 50;
    private static final Logger log = LoggerFactory.getLogger(UccPutawayApproveProc.class);
    private int channel_count;
    private int channel_id;

    public UccPutawayApproveOnlyProc(JdbcTemplate jdbcTemplate, String supplierCode, Integer supplierSource, String pageNumber, int channel_id, int channel_count) {
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
        this.supplierSource = supplierSource;
        this.pageNumber = pageNumber;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
    }

    @Override
    public void run() {
        Long aLong = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=? and SUPPLIER_SOURCE = ?", Long.class, new Object[]{this.supplierCode, this.supplierSource});
        Long shopId = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_SHOP_ID from ucc_supplier_shop where SUPPLIER_ID=?", Long.class, new Object[]{aLong});
        HttpRequest http = new HttpRequest();
        String url = UccPropertiesUtil.getProperty("elcCommodityExaminationUrl");
        if (StringUtils.isEmpty((Object)url)) {
            log.error("\u5ba1\u6838\u5730\u5740\u4e3a\u7a7a");
        } else {
            List maps = this.jdbcTemplate.queryForList("select COMMODITY_ID from ucc_commodity where SUPPLIER_SHOP_ID=? and mod(COMMODITY_ID,?)=?", new Object[]{shopId, this.channel_count, this.channel_id});
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty((Collection)maps)) {
                for (Map next : maps) {
                    Long sku = (Long)next.get("COMMODITY_ID");
                    skuList.add(sku);
                }
            }
            int dealTimes = (int)Math.ceil((double)skuList.size() / 50.0);
            for (int i = 1; i <= dealTimes; ++i) {
                int startPos = (i - 1) * 50;
                int endPos = startPos + 50;
                if (endPos > skuList.size()) {
                    endPos = skuList.size();
                }
                List longs = skuList.subList(startPos, endPos);
                CommodityInfoCheckReqBO commodityInfoCheckReqBO = new CommodityInfoCheckReqBO();
                Long[] commoditys = new Long[longs.size()];
                for (int j = 0; j < commoditys.length; ++j) {
                    commoditys[j] = (Long)longs.get(j);
                }
                commodityInfoCheckReqBO.setCommodityId(commoditys);
                commodityInfoCheckReqBO.setSupplierId(aLong + "");
                Gson gson = new Gson();
                log.info("gson.toJson(commodityInfoCheckReqBO):" + gson.toJson((Object)commodityInfoCheckReqBO));
                String s = http.sendPostJsoneshy(url, gson.toJson((Object)commodityInfoCheckReqBO));
                JsonParser parse = new JsonParser();
                JsonObject asJsonObject = parse.parse(s).getAsJsonObject();
                String respCode = asJsonObject.get("respCode").getAsString();
                if ("0000".equals(respCode)) {
                    log.info("\u7ed3\u679c:" + s);
                    continue;
                }
                String respDesc = asJsonObject.get("respDesc").getAsString();
                log.info("\u53d1\u9001\u5ba1\u6838\u5931\u8d25:" + respDesc);
            }
        }
    }
}

