/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.deli;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.batchimp.initialize.req.model.deli.DeliPageNumReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliPageNum;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DeliApiGetPageNumProc {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private String clientId;
    private static final Logger log = LoggerFactory.getLogger(DeliApiGetPageNumProc.class);
    private String supplierCode;

    public DeliApiGetPageNumProc(JdbcTemplate jdbcTemplate, DeliToken token, String supplierCode) {
        this.token = token.getAccess_token();
        this.apiuri = "http://testb2binner.nbdeli.com/REST/CGDC/Goods/getPageNum";
        this.jdbcTemplate = jdbcTemplate;
        this.clientId = token.getClientId();
        this.supplierCode = supplierCode;
    }

    public void run() throws Exception {
        log.info(this.apiuri + "=====" + this.token);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = df.format(new Date());
        DeliPageNumReq deliPageNumReq = new DeliPageNumReq();
        deliPageNumReq.setClientId(this.clientId);
        deliPageNumReq.setTimestamp(timestamp);
        deliPageNumReq.setToken(this.token);
        Gson gson = new Gson();
        String org_json = HttpRequest.sendPostJson(this.apiuri, gson.toJson((Object)deliPageNumReq));
        log.info(">>>>==========" + org_json);
        JsonParser parse = new JsonParser();
        if (!org_json.equals("")) {
            ArrayList<Object[]> skupoollist = new ArrayList<Object[]>();
            JsonArray subObject = parse.parse(org_json).getAsJsonObject().get("result").getAsJsonArray();
            int count = 0;
            for (JsonElement elem : subObject) {
                ++count;
                DeliPageNum sp = new DeliPageNum();
                sp.setName(elem.getAsJsonObject().get("name").getAsString());
                sp.setPage_num(elem.getAsJsonObject().get("page_num").getAsString());
                log.info(elem.getAsJsonObject().get("name").getAsString());
                log.info(elem.getAsJsonObject().get("page_num").getAsString());
                Object[] obj = new Object[]{Sequence.getInstance().nextId(), sp.getName(), sp.getPage_num(), this.supplierCode};
                skupoollist.add(obj);
                if (count % 100 != 0) continue;
                this.jdbcTemplate.batchUpdate("INSERT INTO UCC_COMMODITY_PAGE_NUM(id, name, page_num,SUPPLIER_CODE) VALUES (?,?,?,?)", skupoollist);
                skupoollist.clear();
            }
            this.jdbcTemplate.batchUpdate("INSERT INTO UCC_COMMODITY_PAGE_NUM(id, name, page_num,SUPPLIER_CODE) VALUES (?,?,?,?)", skupoollist);
            this.jdbcTemplate.execute("UPDATE UCC_COMMODITY_PAGE_NUM SET curr_page_no = 0,flag = 0,total_page_count = 1");
        } else {
            log.info("\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
        }
    }
}

