/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.batchimp.initialize.resp.model.jd.JDPageNum;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiProductGetNumPageProc {
    private String token;
    private String apiuri;
    private String supplierCode;
    private JdbcTemplate jdbcTemplate;
    private static final Logger log = LoggerFactory.getLogger(JDApiProductGetNumPageProc.class);

    public JDApiProductGetNumPageProc(String token, JdbcTemplate jdbcTemplate, String supplierCode) {
        this.token = token;
        this.apiuri = "https://bizapi.jd.com/api/product/getPageNum";
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
    }

    public void run() throws Exception {
        log.info(this.apiuri + this.token);
        String org_json = HttpRequest.sendPost(this.apiuri, "token=" + this.token);
        log.info(org_json);
        JsonParser parse = new JsonParser();
        JsonArray jsonArr = parse.parse(org_json).getAsJsonObject().get("result").getAsJsonArray();
        ArrayList<Object[]> skupoollist = new ArrayList<Object[]>();
        for (int i = 0; i < jsonArr.size(); ++i) {
            JsonObject subObject = jsonArr.get(i).getAsJsonObject();
            JDPageNum sp = new JDPageNum();
            sp.setName(subObject.get("name").getAsString());
            sp.setPage_num(subObject.get("page_num").getAsInt());
            log.info(subObject.get("name").getAsString());
            log.info(subObject.get("page_num").getAsString());
            Object[] obj = new Object[]{Sequence.getInstance().nextId(), sp.getName(), sp.getPage_num(), this.supplierCode};
            skupoollist.add(obj);
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO UCC_COMMODITY_PAGE_NUM(id, name, page_num,SUPPLIER_CODE) VALUES (?,?,?,?)", skupoollist);
        this.jdbcTemplate.update("UPDATE UCC_COMMODITY_PAGE_NUM SET curr_page_no = 0,flag = 0,total_page_count = 1 where SUPPLIER_CODE = ?", new Object[]{this.supplierCode});
    }
}

