/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiSkuGiftProc
implements Runnable {
    private String token;
    private String apiuri1;
    private String apiuri2;
    private String apiuri3;
    private JdbcTemplate jdbcTemplate;
    private int channel_id;
    private int channel_count;
    private static final Logger log = LoggerFactory.getLogger(JDApiSkuGiftProc.class);

    public JDApiSkuGiftProc(String token, JdbcTemplate jdbcTemplate, int channel_id, int channel_count) {
        this.token = token;
        this.apiuri1 = "https://bizapi.jd.com/api/product/getSkuGift";
        this.jdbcTemplate = jdbcTemplate;
        this.channel_id = channel_id;
        this.channel_count = channel_count;
    }

    @Override
    public void run() {
        log.info("channel_id = [" + this.channel_id + "] start");
        List rows = this.jdbcTemplate.queryForList("select name,page_num,sku from jd_sku_set where mod(sku,?) = ?  ", new Object[]{this.channel_count, this.channel_id});
        ArrayList<Object[]> sku_detail_list_obj = new ArrayList<Object[]>();
        JsonParser parse = new JsonParser();
        String org_json1 = null;
        for (Map map : rows) {
            long sku = Long.parseLong(map.get("sku").toString());
            try {
                org_json1 = HttpRequest.sendPost(this.apiuri1, "token=" + this.token + "&skuId=" + sku + "&province=0&city=0&county=0&town=0");
                log.info("sku  " + sku + "  GIFT_INFO = " + org_json1);
                if (org_json1.indexOf("html") == -1 && parse.parse(org_json1).getAsJsonObject().get("result") != null && !parse.parse(org_json1).getAsJsonObject().get("result").isJsonNull()) {
                    int maxNum = 0;
                    int minNum = 0;
                    String promoStartTime = "";
                    String promoEndTime = "";
                    long giftskuId = 0L;
                    int num = 0;
                    int giftType = 0;
                    JsonObject jsonObj = parse.parse(org_json1).getAsJsonObject().get("result").getAsJsonObject();
                    for (JsonElement je : jsonObj.get("gifts").getAsJsonArray()) {
                        maxNum = jsonObj.get("maxNum").getAsInt();
                        minNum = jsonObj.get("minNum").getAsInt();
                        giftskuId = je.getAsJsonObject().get("skuId").getAsLong();
                        num = je.getAsJsonObject().get("num").getAsInt();
                        giftType = je.getAsJsonObject().get("giftType").getAsInt();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date date1 = new Date(jsonObj.get("promoStartTime").getAsLong());
                        Date date2 = new Date(jsonObj.get("promoEndTime").getAsLong());
                        promoStartTime = sdf.format(date1);
                        promoEndTime = sdf.format(date2);
                        Object[] obj = new Object[]{sku, giftskuId, num, giftType, maxNum, minNum, promoStartTime, promoEndTime};
                        sku_detail_list_obj.add(obj);
                    }
                }
                if (sku_detail_list_obj.size() <= 100) continue;
                this.jdbcTemplate.batchUpdate("INSERT INTO jd_sku_gift (skuId,giftskuId,num,giftType,maxNum,minNum,promoStartTime,promoEndTime) VALUES (?,?,?,?,?,?,?,?)", sku_detail_list_obj);
                log.info("batch commit 100 :" + sku_detail_list_obj.size());
                sku_detail_list_obj.clear();
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                System.out.println(e.toString());
            }
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO jd_sku_gift (skuId,giftskuId,num,giftType,maxNum,minNum,promoStartTime,promoEndTime) VALUES (?,?,?,?,?,?,?,?)", sku_detail_list_obj);
        log.info("batch commit rest :" + sku_detail_list_obj.size());
        sku_detail_list_obj.clear();
        log.info("channel_id = [" + this.channel_id + "] end");
    }
}

